
package org.palladiosimulator.retriever.vulnerability.core.nvd;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;


/**
 * JSON Schema for Common Vulnerability Scoring System version 2.0
 * <p>
 * 
 * 
 */
@Generated("jsonschema2pojo")
public class CvssV20Data {

    /**
     * CVSS Version
     * (Required)
     * 
     */
    @SerializedName("version")
    @Expose
    private CvssV20Data .Version version;
    /**
     * 
     * (Required)
     * 
     */
    @SerializedName("vectorString")
    @Expose
    private String vectorString;
    @SerializedName("accessVector")
    @Expose
    private CvssV20Data .AccessVectorType accessVector;
    @SerializedName("accessComplexity")
    @Expose
    private CvssV20Data .AccessComplexityType accessComplexity;
    @SerializedName("authentication")
    @Expose
    private CvssV20Data .AuthenticationType authentication;
    @SerializedName("confidentialityImpact")
    @Expose
    private CvssV20Data .CiaType confidentialityImpact;
    @SerializedName("integrityImpact")
    @Expose
    private CvssV20Data .CiaType integrityImpact;
    @SerializedName("availabilityImpact")
    @Expose
    private CvssV20Data .CiaType availabilityImpact;
    /**
     * 
     * (Required)
     * 
     */
    @SerializedName("baseScore")
    @Expose
    private Double baseScore;
    @SerializedName("exploitability")
    @Expose
    private CvssV20Data .ExploitabilityType exploitability;
    @SerializedName("remediationLevel")
    @Expose
    private CvssV20Data .RemediationLevelType remediationLevel;
    @SerializedName("reportConfidence")
    @Expose
    private CvssV20Data .ReportConfidenceType reportConfidence;
    @SerializedName("temporalScore")
    @Expose
    private Double temporalScore;
    @SerializedName("collateralDamagePotential")
    @Expose
    private CvssV20Data .CollateralDamagePotentialType collateralDamagePotential;
    @SerializedName("targetDistribution")
    @Expose
    private CvssV20Data .TargetDistributionType targetDistribution;
    @SerializedName("confidentialityRequirement")
    @Expose
    private CvssV20Data .CiaRequirementType confidentialityRequirement;
    @SerializedName("integrityRequirement")
    @Expose
    private CvssV20Data .CiaRequirementType integrityRequirement;
    @SerializedName("availabilityRequirement")
    @Expose
    private CvssV20Data .CiaRequirementType availabilityRequirement;
    @SerializedName("environmentalScore")
    @Expose
    private Double environmentalScore;

    /**
     * CVSS Version
     * (Required)
     * 
     */
    public CvssV20Data .Version getVersion() {
        return version;
    }

    /**
     * CVSS Version
     * (Required)
     * 
     */
    public void setVersion(CvssV20Data .Version version) {
        this.version = version;
    }

    /**
     * 
     * (Required)
     * 
     */
    public String getVectorString() {
        return vectorString;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setVectorString(String vectorString) {
        this.vectorString = vectorString;
    }

    public CvssV20Data .AccessVectorType getAccessVector() {
        return accessVector;
    }

    public void setAccessVector(CvssV20Data .AccessVectorType accessVector) {
        this.accessVector = accessVector;
    }

    public CvssV20Data .AccessComplexityType getAccessComplexity() {
        return accessComplexity;
    }

    public void setAccessComplexity(CvssV20Data .AccessComplexityType accessComplexity) {
        this.accessComplexity = accessComplexity;
    }

    public CvssV20Data .AuthenticationType getAuthentication() {
        return authentication;
    }

    public void setAuthentication(CvssV20Data .AuthenticationType authentication) {
        this.authentication = authentication;
    }

    public CvssV20Data .CiaType getConfidentialityImpact() {
        return confidentialityImpact;
    }

    public void setConfidentialityImpact(CvssV20Data .CiaType confidentialityImpact) {
        this.confidentialityImpact = confidentialityImpact;
    }

    public CvssV20Data .CiaType getIntegrityImpact() {
        return integrityImpact;
    }

    public void setIntegrityImpact(CvssV20Data .CiaType integrityImpact) {
        this.integrityImpact = integrityImpact;
    }

    public CvssV20Data .CiaType getAvailabilityImpact() {
        return availabilityImpact;
    }

    public void setAvailabilityImpact(CvssV20Data .CiaType availabilityImpact) {
        this.availabilityImpact = availabilityImpact;
    }

    /**
     * 
     * (Required)
     * 
     */
    public Double getBaseScore() {
        return baseScore;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setBaseScore(Double baseScore) {
        this.baseScore = baseScore;
    }

    public CvssV20Data .ExploitabilityType getExploitability() {
        return exploitability;
    }

    public void setExploitability(CvssV20Data .ExploitabilityType exploitability) {
        this.exploitability = exploitability;
    }

    public CvssV20Data .RemediationLevelType getRemediationLevel() {
        return remediationLevel;
    }

    public void setRemediationLevel(CvssV20Data .RemediationLevelType remediationLevel) {
        this.remediationLevel = remediationLevel;
    }

    public CvssV20Data .ReportConfidenceType getReportConfidence() {
        return reportConfidence;
    }

    public void setReportConfidence(CvssV20Data .ReportConfidenceType reportConfidence) {
        this.reportConfidence = reportConfidence;
    }

    public Double getTemporalScore() {
        return temporalScore;
    }

    public void setTemporalScore(Double temporalScore) {
        this.temporalScore = temporalScore;
    }

    public CvssV20Data .CollateralDamagePotentialType getCollateralDamagePotential() {
        return collateralDamagePotential;
    }

    public void setCollateralDamagePotential(CvssV20Data .CollateralDamagePotentialType collateralDamagePotential) {
        this.collateralDamagePotential = collateralDamagePotential;
    }

    public CvssV20Data .TargetDistributionType getTargetDistribution() {
        return targetDistribution;
    }

    public void setTargetDistribution(CvssV20Data .TargetDistributionType targetDistribution) {
        this.targetDistribution = targetDistribution;
    }

    public CvssV20Data .CiaRequirementType getConfidentialityRequirement() {
        return confidentialityRequirement;
    }

    public void setConfidentialityRequirement(CvssV20Data .CiaRequirementType confidentialityRequirement) {
        this.confidentialityRequirement = confidentialityRequirement;
    }

    public CvssV20Data .CiaRequirementType getIntegrityRequirement() {
        return integrityRequirement;
    }

    public void setIntegrityRequirement(CvssV20Data .CiaRequirementType integrityRequirement) {
        this.integrityRequirement = integrityRequirement;
    }

    public CvssV20Data .CiaRequirementType getAvailabilityRequirement() {
        return availabilityRequirement;
    }

    public void setAvailabilityRequirement(CvssV20Data .CiaRequirementType availabilityRequirement) {
        this.availabilityRequirement = availabilityRequirement;
    }

    public Double getEnvironmentalScore() {
        return environmentalScore;
    }

    public void setEnvironmentalScore(Double environmentalScore) {
        this.environmentalScore = environmentalScore;
    }

    @Generated("jsonschema2pojo")
    public enum AccessComplexityType {

        @SerializedName("HIGH")
        HIGH("HIGH"),
        @SerializedName("MEDIUM")
        MEDIUM("MEDIUM"),
        @SerializedName("LOW")
        LOW("LOW");
        private final String value;
        private final static Map<String, CvssV20Data .AccessComplexityType> CONSTANTS = new HashMap<String, CvssV20Data .AccessComplexityType>();

        static {
            for (CvssV20Data .AccessComplexityType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        AccessComplexityType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static CvssV20Data .AccessComplexityType fromValue(String value) {
            CvssV20Data .AccessComplexityType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum AccessVectorType {

        @SerializedName("NETWORK")
        NETWORK("NETWORK"),
        @SerializedName("ADJACENT_NETWORK")
        ADJACENT_NETWORK("ADJACENT_NETWORK"),
        @SerializedName("LOCAL")
        LOCAL("LOCAL");
        private final String value;
        private final static Map<String, CvssV20Data .AccessVectorType> CONSTANTS = new HashMap<String, CvssV20Data .AccessVectorType>();

        static {
            for (CvssV20Data .AccessVectorType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        AccessVectorType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static CvssV20Data .AccessVectorType fromValue(String value) {
            CvssV20Data .AccessVectorType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum AuthenticationType {

        @SerializedName("MULTIPLE")
        MULTIPLE("MULTIPLE"),
        @SerializedName("SINGLE")
        SINGLE("SINGLE"),
        @SerializedName("NONE")
        NONE("NONE");
        private final String value;
        private final static Map<String, CvssV20Data .AuthenticationType> CONSTANTS = new HashMap<String, CvssV20Data .AuthenticationType>();

        static {
            for (CvssV20Data .AuthenticationType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        AuthenticationType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static CvssV20Data .AuthenticationType fromValue(String value) {
            CvssV20Data .AuthenticationType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum CiaRequirementType {

        @SerializedName("LOW")
        LOW("LOW"),
        @SerializedName("MEDIUM")
        MEDIUM("MEDIUM"),
        @SerializedName("HIGH")
        HIGH("HIGH"),
        @SerializedName("NOT_DEFINED")
        NOT_DEFINED("NOT_DEFINED");
        private final String value;
        private final static Map<String, CvssV20Data .CiaRequirementType> CONSTANTS = new HashMap<String, CvssV20Data .CiaRequirementType>();

        static {
            for (CvssV20Data .CiaRequirementType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        CiaRequirementType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static CvssV20Data .CiaRequirementType fromValue(String value) {
            CvssV20Data .CiaRequirementType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum CiaType {

        @SerializedName("NONE")
        NONE("NONE"),
        @SerializedName("PARTIAL")
        PARTIAL("PARTIAL"),
        @SerializedName("COMPLETE")
        COMPLETE("COMPLETE");
        private final String value;
        private final static Map<String, CvssV20Data .CiaType> CONSTANTS = new HashMap<String, CvssV20Data .CiaType>();

        static {
            for (CvssV20Data .CiaType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        CiaType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static CvssV20Data .CiaType fromValue(String value) {
            CvssV20Data .CiaType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum CollateralDamagePotentialType {

        @SerializedName("NONE")
        NONE("NONE"),
        @SerializedName("LOW")
        LOW("LOW"),
        @SerializedName("LOW_MEDIUM")
        LOW_MEDIUM("LOW_MEDIUM"),
        @SerializedName("MEDIUM_HIGH")
        MEDIUM_HIGH("MEDIUM_HIGH"),
        @SerializedName("HIGH")
        HIGH("HIGH"),
        @SerializedName("NOT_DEFINED")
        NOT_DEFINED("NOT_DEFINED");
        private final String value;
        private final static Map<String, CvssV20Data .CollateralDamagePotentialType> CONSTANTS = new HashMap<String, CvssV20Data .CollateralDamagePotentialType>();

        static {
            for (CvssV20Data .CollateralDamagePotentialType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        CollateralDamagePotentialType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static CvssV20Data .CollateralDamagePotentialType fromValue(String value) {
            CvssV20Data .CollateralDamagePotentialType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum ExploitabilityType {

        @SerializedName("UNPROVEN")
        UNPROVEN("UNPROVEN"),
        @SerializedName("PROOF_OF_CONCEPT")
        PROOF_OF_CONCEPT("PROOF_OF_CONCEPT"),
        @SerializedName("FUNCTIONAL")
        FUNCTIONAL("FUNCTIONAL"),
        @SerializedName("HIGH")
        HIGH("HIGH"),
        @SerializedName("NOT_DEFINED")
        NOT_DEFINED("NOT_DEFINED");
        private final String value;
        private final static Map<String, CvssV20Data .ExploitabilityType> CONSTANTS = new HashMap<String, CvssV20Data .ExploitabilityType>();

        static {
            for (CvssV20Data .ExploitabilityType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        ExploitabilityType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static CvssV20Data .ExploitabilityType fromValue(String value) {
            CvssV20Data .ExploitabilityType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum RemediationLevelType {

        @SerializedName("OFFICIAL_FIX")
        OFFICIAL_FIX("OFFICIAL_FIX"),
        @SerializedName("TEMPORARY_FIX")
        TEMPORARY_FIX("TEMPORARY_FIX"),
        @SerializedName("WORKAROUND")
        WORKAROUND("WORKAROUND"),
        @SerializedName("UNAVAILABLE")
        UNAVAILABLE("UNAVAILABLE"),
        @SerializedName("NOT_DEFINED")
        NOT_DEFINED("NOT_DEFINED");
        private final String value;
        private final static Map<String, CvssV20Data .RemediationLevelType> CONSTANTS = new HashMap<String, CvssV20Data .RemediationLevelType>();

        static {
            for (CvssV20Data .RemediationLevelType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        RemediationLevelType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static CvssV20Data .RemediationLevelType fromValue(String value) {
            CvssV20Data .RemediationLevelType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum ReportConfidenceType {

        @SerializedName("UNCONFIRMED")
        UNCONFIRMED("UNCONFIRMED"),
        @SerializedName("UNCORROBORATED")
        UNCORROBORATED("UNCORROBORATED"),
        @SerializedName("CONFIRMED")
        CONFIRMED("CONFIRMED"),
        @SerializedName("NOT_DEFINED")
        NOT_DEFINED("NOT_DEFINED");
        private final String value;
        private final static Map<String, CvssV20Data .ReportConfidenceType> CONSTANTS = new HashMap<String, CvssV20Data .ReportConfidenceType>();

        static {
            for (CvssV20Data .ReportConfidenceType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        ReportConfidenceType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static CvssV20Data .ReportConfidenceType fromValue(String value) {
            CvssV20Data .ReportConfidenceType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum TargetDistributionType {

        @SerializedName("NONE")
        NONE("NONE"),
        @SerializedName("LOW")
        LOW("LOW"),
        @SerializedName("MEDIUM")
        MEDIUM("MEDIUM"),
        @SerializedName("HIGH")
        HIGH("HIGH"),
        @SerializedName("NOT_DEFINED")
        NOT_DEFINED("NOT_DEFINED");
        private final String value;
        private final static Map<String, CvssV20Data .TargetDistributionType> CONSTANTS = new HashMap<String, CvssV20Data .TargetDistributionType>();

        static {
            for (CvssV20Data .TargetDistributionType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        TargetDistributionType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static CvssV20Data .TargetDistributionType fromValue(String value) {
            CvssV20Data .TargetDistributionType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }


    /**
     * CVSS Version
     * 
     */
    @Generated("jsonschema2pojo")
    public enum Version {

        @SerializedName("2.0")
        _2_0("2.0");
        private final String value;
        private final static Map<String, CvssV20Data .Version> CONSTANTS = new HashMap<String, CvssV20Data .Version>();

        static {
            for (CvssV20Data .Version c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        Version(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static CvssV20Data .Version fromValue(String value) {
            CvssV20Data .Version constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
