
package org.palladiosimulator.retriever.vulnerability.core.nvd;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;


/**
 * JSON Schema for Common Vulnerability Scoring System version 3.1
 * <p>
 * 
 * 
 */
@Generated("jsonschema2pojo")
public class CvssV31Data {

    /**
     * CVSS Version
     * (Required)
     * 
     */
    @SerializedName("version")
    @Expose
    private CvssV31Data .Version version;
    /**
     * 
     * (Required)
     * 
     */
    @SerializedName("vectorString")
    @Expose
    private String vectorString;
    @SerializedName("attackVector")
    @Expose
    private CvssV31Data .AttackVectorType attackVector;
    @SerializedName("attackComplexity")
    @Expose
    private CvssV31Data .AttackComplexityType attackComplexity;
    @SerializedName("privilegesRequired")
    @Expose
    private CvssV31Data .PrivilegesRequiredType privilegesRequired;
    @SerializedName("userInteraction")
    @Expose
    private CvssV31Data .UserInteractionType userInteraction;
    @SerializedName("scope")
    @Expose
    private CvssV31Data .ScopeType scope;
    @SerializedName("confidentialityImpact")
    @Expose
    private CvssV31Data .CiaType confidentialityImpact;
    @SerializedName("integrityImpact")
    @Expose
    private CvssV31Data .CiaType integrityImpact;
    @SerializedName("availabilityImpact")
    @Expose
    private CvssV31Data .CiaType availabilityImpact;
    /**
     * 
     * (Required)
     * 
     */
    @SerializedName("baseScore")
    @Expose
    private Double baseScore;
    /**
     * 
     * (Required)
     * 
     */
    @SerializedName("baseSeverity")
    @Expose
    private CvssV31Data .SeverityType baseSeverity;
    @SerializedName("exploitCodeMaturity")
    @Expose
    private CvssV31Data .ExploitCodeMaturityType exploitCodeMaturity;
    @SerializedName("remediationLevel")
    @Expose
    private CvssV31Data .RemediationLevelType remediationLevel;
    @SerializedName("reportConfidence")
    @Expose
    private CvssV31Data .ConfidenceType reportConfidence;
    @SerializedName("temporalScore")
    @Expose
    private Double temporalScore;
    @SerializedName("temporalSeverity")
    @Expose
    private CvssV31Data .SeverityType temporalSeverity;
    @SerializedName("confidentialityRequirement")
    @Expose
    private CvssV31Data .CiaRequirementType confidentialityRequirement;
    @SerializedName("integrityRequirement")
    @Expose
    private CvssV31Data .CiaRequirementType integrityRequirement;
    @SerializedName("availabilityRequirement")
    @Expose
    private CvssV31Data .CiaRequirementType availabilityRequirement;
    @SerializedName("modifiedAttackVector")
    @Expose
    private CvssV31Data .ModifiedAttackVectorType modifiedAttackVector;
    @SerializedName("modifiedAttackComplexity")
    @Expose
    private CvssV31Data .ModifiedAttackComplexityType modifiedAttackComplexity;
    @SerializedName("modifiedPrivilegesRequired")
    @Expose
    private CvssV31Data .ModifiedPrivilegesRequiredType modifiedPrivilegesRequired;
    @SerializedName("modifiedUserInteraction")
    @Expose
    private CvssV31Data .ModifiedUserInteractionType modifiedUserInteraction;
    @SerializedName("modifiedScope")
    @Expose
    private CvssV31Data .ModifiedScopeType modifiedScope;
    @SerializedName("modifiedConfidentialityImpact")
    @Expose
    private CvssV31Data .ModifiedCiaType modifiedConfidentialityImpact;
    @SerializedName("modifiedIntegrityImpact")
    @Expose
    private CvssV31Data .ModifiedCiaType modifiedIntegrityImpact;
    @SerializedName("modifiedAvailabilityImpact")
    @Expose
    private CvssV31Data .ModifiedCiaType modifiedAvailabilityImpact;
    @SerializedName("environmentalScore")
    @Expose
    private Double environmentalScore;
    @SerializedName("environmentalSeverity")
    @Expose
    private CvssV31Data .SeverityType environmentalSeverity;

    /**
     * CVSS Version
     * (Required)
     * 
     */
    public CvssV31Data .Version getVersion() {
        return version;
    }

    /**
     * CVSS Version
     * (Required)
     * 
     */
    public void setVersion(CvssV31Data .Version version) {
        this.version = version;
    }

    /**
     * 
     * (Required)
     * 
     */
    public String getVectorString() {
        return vectorString;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setVectorString(String vectorString) {
        this.vectorString = vectorString;
    }

    public CvssV31Data .AttackVectorType getAttackVector() {
        return attackVector;
    }

    public void setAttackVector(CvssV31Data .AttackVectorType attackVector) {
        this.attackVector = attackVector;
    }

    public CvssV31Data .AttackComplexityType getAttackComplexity() {
        return attackComplexity;
    }

    public void setAttackComplexity(CvssV31Data .AttackComplexityType attackComplexity) {
        this.attackComplexity = attackComplexity;
    }

    public CvssV31Data .PrivilegesRequiredType getPrivilegesRequired() {
        return privilegesRequired;
    }

    public void setPrivilegesRequired(CvssV31Data .PrivilegesRequiredType privilegesRequired) {
        this.privilegesRequired = privilegesRequired;
    }

    public CvssV31Data .UserInteractionType getUserInteraction() {
        return userInteraction;
    }

    public void setUserInteraction(CvssV31Data .UserInteractionType userInteraction) {
        this.userInteraction = userInteraction;
    }

    public CvssV31Data .ScopeType getScope() {
        return scope;
    }

    public void setScope(CvssV31Data .ScopeType scope) {
        this.scope = scope;
    }

    public CvssV31Data .CiaType getConfidentialityImpact() {
        return confidentialityImpact;
    }

    public void setConfidentialityImpact(CvssV31Data .CiaType confidentialityImpact) {
        this.confidentialityImpact = confidentialityImpact;
    }

    public CvssV31Data .CiaType getIntegrityImpact() {
        return integrityImpact;
    }

    public void setIntegrityImpact(CvssV31Data .CiaType integrityImpact) {
        this.integrityImpact = integrityImpact;
    }

    public CvssV31Data .CiaType getAvailabilityImpact() {
        return availabilityImpact;
    }

    public void setAvailabilityImpact(CvssV31Data .CiaType availabilityImpact) {
        this.availabilityImpact = availabilityImpact;
    }

    /**
     * 
     * (Required)
     * 
     */
    public Double getBaseScore() {
        return baseScore;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setBaseScore(Double baseScore) {
        this.baseScore = baseScore;
    }

    /**
     * 
     * (Required)
     * 
     */
    public CvssV31Data .SeverityType getBaseSeverity() {
        return baseSeverity;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setBaseSeverity(CvssV31Data .SeverityType baseSeverity) {
        this.baseSeverity = baseSeverity;
    }

    public CvssV31Data .ExploitCodeMaturityType getExploitCodeMaturity() {
        return exploitCodeMaturity;
    }

    public void setExploitCodeMaturity(CvssV31Data .ExploitCodeMaturityType exploitCodeMaturity) {
        this.exploitCodeMaturity = exploitCodeMaturity;
    }

    public CvssV31Data .RemediationLevelType getRemediationLevel() {
        return remediationLevel;
    }

    public void setRemediationLevel(CvssV31Data .RemediationLevelType remediationLevel) {
        this.remediationLevel = remediationLevel;
    }

    public CvssV31Data .ConfidenceType getReportConfidence() {
        return reportConfidence;
    }

    public void setReportConfidence(CvssV31Data .ConfidenceType reportConfidence) {
        this.reportConfidence = reportConfidence;
    }

    public Double getTemporalScore() {
        return temporalScore;
    }

    public void setTemporalScore(Double temporalScore) {
        this.temporalScore = temporalScore;
    }

    public CvssV31Data .SeverityType getTemporalSeverity() {
        return temporalSeverity;
    }

    public void setTemporalSeverity(CvssV31Data .SeverityType temporalSeverity) {
        this.temporalSeverity = temporalSeverity;
    }

    public CvssV31Data .CiaRequirementType getConfidentialityRequirement() {
        return confidentialityRequirement;
    }

    public void setConfidentialityRequirement(CvssV31Data .CiaRequirementType confidentialityRequirement) {
        this.confidentialityRequirement = confidentialityRequirement;
    }

    public CvssV31Data .CiaRequirementType getIntegrityRequirement() {
        return integrityRequirement;
    }

    public void setIntegrityRequirement(CvssV31Data .CiaRequirementType integrityRequirement) {
        this.integrityRequirement = integrityRequirement;
    }

    public CvssV31Data .CiaRequirementType getAvailabilityRequirement() {
        return availabilityRequirement;
    }

    public void setAvailabilityRequirement(CvssV31Data .CiaRequirementType availabilityRequirement) {
        this.availabilityRequirement = availabilityRequirement;
    }

    public CvssV31Data .ModifiedAttackVectorType getModifiedAttackVector() {
        return modifiedAttackVector;
    }

    public void setModifiedAttackVector(CvssV31Data .ModifiedAttackVectorType modifiedAttackVector) {
        this.modifiedAttackVector = modifiedAttackVector;
    }

    public CvssV31Data .ModifiedAttackComplexityType getModifiedAttackComplexity() {
        return modifiedAttackComplexity;
    }

    public void setModifiedAttackComplexity(CvssV31Data .ModifiedAttackComplexityType modifiedAttackComplexity) {
        this.modifiedAttackComplexity = modifiedAttackComplexity;
    }

    public CvssV31Data .ModifiedPrivilegesRequiredType getModifiedPrivilegesRequired() {
        return modifiedPrivilegesRequired;
    }

    public void setModifiedPrivilegesRequired(CvssV31Data .ModifiedPrivilegesRequiredType modifiedPrivilegesRequired) {
        this.modifiedPrivilegesRequired = modifiedPrivilegesRequired;
    }

    public CvssV31Data .ModifiedUserInteractionType getModifiedUserInteraction() {
        return modifiedUserInteraction;
    }

    public void setModifiedUserInteraction(CvssV31Data .ModifiedUserInteractionType modifiedUserInteraction) {
        this.modifiedUserInteraction = modifiedUserInteraction;
    }

    public CvssV31Data .ModifiedScopeType getModifiedScope() {
        return modifiedScope;
    }

    public void setModifiedScope(CvssV31Data .ModifiedScopeType modifiedScope) {
        this.modifiedScope = modifiedScope;
    }

    public CvssV31Data .ModifiedCiaType getModifiedConfidentialityImpact() {
        return modifiedConfidentialityImpact;
    }

    public void setModifiedConfidentialityImpact(CvssV31Data .ModifiedCiaType modifiedConfidentialityImpact) {
        this.modifiedConfidentialityImpact = modifiedConfidentialityImpact;
    }

    public CvssV31Data .ModifiedCiaType getModifiedIntegrityImpact() {
        return modifiedIntegrityImpact;
    }

    public void setModifiedIntegrityImpact(CvssV31Data .ModifiedCiaType modifiedIntegrityImpact) {
        this.modifiedIntegrityImpact = modifiedIntegrityImpact;
    }

    public CvssV31Data .ModifiedCiaType getModifiedAvailabilityImpact() {
        return modifiedAvailabilityImpact;
    }

    public void setModifiedAvailabilityImpact(CvssV31Data .ModifiedCiaType modifiedAvailabilityImpact) {
        this.modifiedAvailabilityImpact = modifiedAvailabilityImpact;
    }

    public Double getEnvironmentalScore() {
        return environmentalScore;
    }

    public void setEnvironmentalScore(Double environmentalScore) {
        this.environmentalScore = environmentalScore;
    }

    public CvssV31Data .SeverityType getEnvironmentalSeverity() {
        return environmentalSeverity;
    }

    public void setEnvironmentalSeverity(CvssV31Data .SeverityType environmentalSeverity) {
        this.environmentalSeverity = environmentalSeverity;
    }

    @Generated("jsonschema2pojo")
    public enum AttackComplexityType {

        @SerializedName("HIGH")
        HIGH("HIGH"),
        @SerializedName("LOW")
        LOW("LOW");
        private final String value;
        private final static Map<String, CvssV31Data .AttackComplexityType> CONSTANTS = new HashMap<String, CvssV31Data .AttackComplexityType>();

        static {
            for (CvssV31Data .AttackComplexityType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        AttackComplexityType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static CvssV31Data .AttackComplexityType fromValue(String value) {
            CvssV31Data .AttackComplexityType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum AttackVectorType {

        @SerializedName("NETWORK")
        NETWORK("NETWORK"),
        @SerializedName("ADJACENT_NETWORK")
        ADJACENT_NETWORK("ADJACENT_NETWORK"),
        @SerializedName("LOCAL")
        LOCAL("LOCAL"),
        @SerializedName("PHYSICAL")
        PHYSICAL("PHYSICAL");
        private final String value;
        private final static Map<String, CvssV31Data .AttackVectorType> CONSTANTS = new HashMap<String, CvssV31Data .AttackVectorType>();

        static {
            for (CvssV31Data .AttackVectorType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        AttackVectorType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static CvssV31Data .AttackVectorType fromValue(String value) {
            CvssV31Data .AttackVectorType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum CiaRequirementType {

        @SerializedName("LOW")
        LOW("LOW"),
        @SerializedName("MEDIUM")
        MEDIUM("MEDIUM"),
        @SerializedName("HIGH")
        HIGH("HIGH"),
        @SerializedName("NOT_DEFINED")
        NOT_DEFINED("NOT_DEFINED");
        private final String value;
        private final static Map<String, CvssV31Data .CiaRequirementType> CONSTANTS = new HashMap<String, CvssV31Data .CiaRequirementType>();

        static {
            for (CvssV31Data .CiaRequirementType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        CiaRequirementType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static CvssV31Data .CiaRequirementType fromValue(String value) {
            CvssV31Data .CiaRequirementType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum CiaType {

        @SerializedName("NONE")
        NONE("NONE"),
        @SerializedName("LOW")
        LOW("LOW"),
        @SerializedName("HIGH")
        HIGH("HIGH");
        private final String value;
        private final static Map<String, CvssV31Data .CiaType> CONSTANTS = new HashMap<String, CvssV31Data .CiaType>();

        static {
            for (CvssV31Data .CiaType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        CiaType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static CvssV31Data .CiaType fromValue(String value) {
            CvssV31Data .CiaType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum ConfidenceType {

        @SerializedName("UNKNOWN")
        UNKNOWN("UNKNOWN"),
        @SerializedName("REASONABLE")
        REASONABLE("REASONABLE"),
        @SerializedName("CONFIRMED")
        CONFIRMED("CONFIRMED"),
        @SerializedName("NOT_DEFINED")
        NOT_DEFINED("NOT_DEFINED");
        private final String value;
        private final static Map<String, CvssV31Data .ConfidenceType> CONSTANTS = new HashMap<String, CvssV31Data .ConfidenceType>();

        static {
            for (CvssV31Data .ConfidenceType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        ConfidenceType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static CvssV31Data .ConfidenceType fromValue(String value) {
            CvssV31Data .ConfidenceType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum ExploitCodeMaturityType {

        @SerializedName("UNPROVEN")
        UNPROVEN("UNPROVEN"),
        @SerializedName("PROOF_OF_CONCEPT")
        PROOF_OF_CONCEPT("PROOF_OF_CONCEPT"),
        @SerializedName("FUNCTIONAL")
        FUNCTIONAL("FUNCTIONAL"),
        @SerializedName("HIGH")
        HIGH("HIGH"),
        @SerializedName("NOT_DEFINED")
        NOT_DEFINED("NOT_DEFINED");
        private final String value;
        private final static Map<String, CvssV31Data .ExploitCodeMaturityType> CONSTANTS = new HashMap<String, CvssV31Data .ExploitCodeMaturityType>();

        static {
            for (CvssV31Data .ExploitCodeMaturityType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        ExploitCodeMaturityType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static CvssV31Data .ExploitCodeMaturityType fromValue(String value) {
            CvssV31Data .ExploitCodeMaturityType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum ModifiedAttackComplexityType {

        @SerializedName("HIGH")
        HIGH("HIGH"),
        @SerializedName("LOW")
        LOW("LOW"),
        @SerializedName("NOT_DEFINED")
        NOT_DEFINED("NOT_DEFINED");
        private final String value;
        private final static Map<String, CvssV31Data .ModifiedAttackComplexityType> CONSTANTS = new HashMap<String, CvssV31Data .ModifiedAttackComplexityType>();

        static {
            for (CvssV31Data .ModifiedAttackComplexityType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        ModifiedAttackComplexityType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static CvssV31Data .ModifiedAttackComplexityType fromValue(String value) {
            CvssV31Data .ModifiedAttackComplexityType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum ModifiedAttackVectorType {

        @SerializedName("NETWORK")
        NETWORK("NETWORK"),
        @SerializedName("ADJACENT_NETWORK")
        ADJACENT_NETWORK("ADJACENT_NETWORK"),
        @SerializedName("LOCAL")
        LOCAL("LOCAL"),
        @SerializedName("PHYSICAL")
        PHYSICAL("PHYSICAL"),
        @SerializedName("NOT_DEFINED")
        NOT_DEFINED("NOT_DEFINED");
        private final String value;
        private final static Map<String, CvssV31Data .ModifiedAttackVectorType> CONSTANTS = new HashMap<String, CvssV31Data .ModifiedAttackVectorType>();

        static {
            for (CvssV31Data .ModifiedAttackVectorType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        ModifiedAttackVectorType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static CvssV31Data .ModifiedAttackVectorType fromValue(String value) {
            CvssV31Data .ModifiedAttackVectorType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum ModifiedCiaType {

        @SerializedName("NONE")
        NONE("NONE"),
        @SerializedName("LOW")
        LOW("LOW"),
        @SerializedName("HIGH")
        HIGH("HIGH"),
        @SerializedName("NOT_DEFINED")
        NOT_DEFINED("NOT_DEFINED");
        private final String value;
        private final static Map<String, CvssV31Data .ModifiedCiaType> CONSTANTS = new HashMap<String, CvssV31Data .ModifiedCiaType>();

        static {
            for (CvssV31Data .ModifiedCiaType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        ModifiedCiaType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static CvssV31Data .ModifiedCiaType fromValue(String value) {
            CvssV31Data .ModifiedCiaType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum ModifiedPrivilegesRequiredType {

        @SerializedName("HIGH")
        HIGH("HIGH"),
        @SerializedName("LOW")
        LOW("LOW"),
        @SerializedName("NONE")
        NONE("NONE"),
        @SerializedName("NOT_DEFINED")
        NOT_DEFINED("NOT_DEFINED");
        private final String value;
        private final static Map<String, CvssV31Data .ModifiedPrivilegesRequiredType> CONSTANTS = new HashMap<String, CvssV31Data .ModifiedPrivilegesRequiredType>();

        static {
            for (CvssV31Data .ModifiedPrivilegesRequiredType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        ModifiedPrivilegesRequiredType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static CvssV31Data .ModifiedPrivilegesRequiredType fromValue(String value) {
            CvssV31Data .ModifiedPrivilegesRequiredType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum ModifiedScopeType {

        @SerializedName("UNCHANGED")
        UNCHANGED("UNCHANGED"),
        @SerializedName("CHANGED")
        CHANGED("CHANGED"),
        @SerializedName("NOT_DEFINED")
        NOT_DEFINED("NOT_DEFINED");
        private final String value;
        private final static Map<String, CvssV31Data .ModifiedScopeType> CONSTANTS = new HashMap<String, CvssV31Data .ModifiedScopeType>();

        static {
            for (CvssV31Data .ModifiedScopeType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        ModifiedScopeType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static CvssV31Data .ModifiedScopeType fromValue(String value) {
            CvssV31Data .ModifiedScopeType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum ModifiedUserInteractionType {

        @SerializedName("NONE")
        NONE("NONE"),
        @SerializedName("REQUIRED")
        REQUIRED("REQUIRED"),
        @SerializedName("NOT_DEFINED")
        NOT_DEFINED("NOT_DEFINED");
        private final String value;
        private final static Map<String, CvssV31Data .ModifiedUserInteractionType> CONSTANTS = new HashMap<String, CvssV31Data .ModifiedUserInteractionType>();

        static {
            for (CvssV31Data .ModifiedUserInteractionType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        ModifiedUserInteractionType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static CvssV31Data .ModifiedUserInteractionType fromValue(String value) {
            CvssV31Data .ModifiedUserInteractionType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum PrivilegesRequiredType {

        @SerializedName("HIGH")
        HIGH("HIGH"),
        @SerializedName("LOW")
        LOW("LOW"),
        @SerializedName("NONE")
        NONE("NONE");
        private final String value;
        private final static Map<String, CvssV31Data .PrivilegesRequiredType> CONSTANTS = new HashMap<String, CvssV31Data .PrivilegesRequiredType>();

        static {
            for (CvssV31Data .PrivilegesRequiredType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        PrivilegesRequiredType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static CvssV31Data .PrivilegesRequiredType fromValue(String value) {
            CvssV31Data .PrivilegesRequiredType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum RemediationLevelType {

        @SerializedName("OFFICIAL_FIX")
        OFFICIAL_FIX("OFFICIAL_FIX"),
        @SerializedName("TEMPORARY_FIX")
        TEMPORARY_FIX("TEMPORARY_FIX"),
        @SerializedName("WORKAROUND")
        WORKAROUND("WORKAROUND"),
        @SerializedName("UNAVAILABLE")
        UNAVAILABLE("UNAVAILABLE"),
        @SerializedName("NOT_DEFINED")
        NOT_DEFINED("NOT_DEFINED");
        private final String value;
        private final static Map<String, CvssV31Data .RemediationLevelType> CONSTANTS = new HashMap<String, CvssV31Data .RemediationLevelType>();

        static {
            for (CvssV31Data .RemediationLevelType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        RemediationLevelType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static CvssV31Data .RemediationLevelType fromValue(String value) {
            CvssV31Data .RemediationLevelType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum ScopeType {

        @SerializedName("UNCHANGED")
        UNCHANGED("UNCHANGED"),
        @SerializedName("CHANGED")
        CHANGED("CHANGED");
        private final String value;
        private final static Map<String, CvssV31Data .ScopeType> CONSTANTS = new HashMap<String, CvssV31Data .ScopeType>();

        static {
            for (CvssV31Data .ScopeType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        ScopeType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static CvssV31Data .ScopeType fromValue(String value) {
            CvssV31Data .ScopeType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum SeverityType {

        @SerializedName("NONE")
        NONE("NONE"),
        @SerializedName("LOW")
        LOW("LOW"),
        @SerializedName("MEDIUM")
        MEDIUM("MEDIUM"),
        @SerializedName("HIGH")
        HIGH("HIGH"),
        @SerializedName("CRITICAL")
        CRITICAL("CRITICAL");
        private final String value;
        private final static Map<String, CvssV31Data .SeverityType> CONSTANTS = new HashMap<String, CvssV31Data .SeverityType>();

        static {
            for (CvssV31Data .SeverityType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        SeverityType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static CvssV31Data .SeverityType fromValue(String value) {
            CvssV31Data .SeverityType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

    @Generated("jsonschema2pojo")
    public enum UserInteractionType {

        @SerializedName("NONE")
        NONE("NONE"),
        @SerializedName("REQUIRED")
        REQUIRED("REQUIRED");
        private final String value;
        private final static Map<String, CvssV31Data .UserInteractionType> CONSTANTS = new HashMap<String, CvssV31Data .UserInteractionType>();

        static {
            for (CvssV31Data .UserInteractionType c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        UserInteractionType(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static CvssV31Data .UserInteractionType fromValue(String value) {
            CvssV31Data .UserInteractionType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }


    /**
     * CVSS Version
     * 
     */
    @Generated("jsonschema2pojo")
    public enum Version {

        @SerializedName("3.1")
        _3_1("3.1");
        private final String value;
        private final static Map<String, CvssV31Data .Version> CONSTANTS = new HashMap<String, CvssV31Data .Version>();

        static {
            for (CvssV31Data .Version c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        Version(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }

        public String value() {
            return this.value;
        }

        public static CvssV31Data .Version fromValue(String value) {
            CvssV31Data .Version constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
