/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.interpreter.linking.impl;

import de.uka.ipd.sdq.simucomframework.variables.converter.NumberConverter;
import de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStackframe;
import java.util.Map;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.palladiosimulator.simulizar.interpreter.linking.ITransmissionPayloadDemandCalculator;

public class StackFrameBytesizeAccumulatingDemandCalculator
implements ITransmissionPayloadDemandCalculator<SimulatedStackframe<Object>, Double> {
    private static final Logger LOGGER = Logger.getLogger(StackFrameBytesizeAccumulatingDemandCalculator.class);

    @Inject
    public StackFrameBytesizeAccumulatingDemandCalculator() {
    }

    @Override
    public Double calculatePayloadDemand(SimulatedStackframe<Object> payload) {
        double demand = 0.0;
        for (Map.Entry entry : payload.getContents()) {
            if (!((String)entry.getKey()).endsWith("BYTESIZE")) continue;
            if (((String)entry.getKey()).contains(".INNER.")) {
                LOGGER.warn((Object)"Network demand cannot be properly determined for INNER BYTESIZE characterizations yet, the simulation will assume that there is just a single element in the collection. Please enable the \"simulate middleware marshalling / demarshalling of remote calls\" in the feature settings tab or directly define the BYTESIZE of the collection.");
            }
            demand += NumberConverter.toDouble(entry.getValue());
        }
        return demand;
    }
}

