/*
 * Decompiled with CFR 0.152.
 */
package org.somox.gast2seff.visitors;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import tools.mdsd.jamopp.model.java.expressions.Expression;
import tools.mdsd.jamopp.model.java.members.Method;
import tools.mdsd.jamopp.model.java.references.MethodCall;
import tools.mdsd.jamopp.model.java.references.Reference;
import tools.mdsd.jamopp.model.java.statements.Statement;

public class MethodCallFinder {
    private static final Logger logger = Logger.getLogger((String)MethodCallFinder.class.getSimpleName());
    private final HashMap<Statement, List<Method>> methodListCacheForStatement = new HashMap();

    public List<Method> getMethodCalls(Statement statement) {
        if (!this.methodListCacheForStatement.containsKey(statement)) {
            LinkedList<Method> calledMethods = new LinkedList<Method>();
            HashSet<EObject> investigatedEObjects = new HashSet<EObject>();
            this.findMethodCallsInChildren((EObject)statement, calledMethods, investigatedEObjects);
            this.methodListCacheForStatement.put(statement, calledMethods);
        }
        return this.methodListCacheForStatement.get(statement);
    }

    private void findMethodCallsInChildren(EObject eObject, LinkedList<Method> calledMethods, Set<EObject> investigatedEObjects) {
        if (eObject == null) {
            return;
        }
        TreeIterator treeIterator = eObject.eAllContents();
        while (treeIterator.hasNext()) {
            EObject current = (EObject)treeIterator.next();
            if (investigatedEObjects.contains(current)) continue;
            investigatedEObjects.add(current);
            if (!(current instanceof MethodCall var6_6)) continue;
            this.findMethodCallsInArguments((EList<Expression>)methodCall.getArguments(), calledMethods, investigatedEObjects);
            this.addMethodToCollection(calledMethods, (MethodCall)methodCall);
            this.findMethodCallsInNext(methodCall.getNext(), calledMethods, investigatedEObjects);
        }
    }

    private void findMethodCallsInNext(Reference next, LinkedList<Method> calledMethods, Set<EObject> investigatedEObjects) {
        this.findMethodCallsInChildren((EObject)next, calledMethods, investigatedEObjects);
    }

    private void findMethodCallsInArguments(EList<Expression> arguments, LinkedList<Method> calledMethods, Set<EObject> investigatedEObjects) {
        for (Expression expression : arguments) {
            if (expression instanceof MethodCall) {
                investigatedEObjects.add((EObject)expression);
                this.addMethodToCollection(calledMethods, (MethodCall)expression);
            }
            this.findMethodCallsInChildren((EObject)expression, calledMethods, investigatedEObjects);
        }
    }

    private void addMethodToCollection(LinkedList<Method> calledMethods, MethodCall methodCall) {
        if (methodCall.getTarget() instanceof Method) {
            Method target = (Method)methodCall.getTarget();
            calledMethods.add(target);
        }
    }
}

