/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.jamopp.extraction;

import com.google.common.collect.Lists;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.splevo.jamopp.extraction.FileResourceHandling;
import org.splevo.jamopp.extraction.SPLevoResourceSet;
import org.splevo.jamopp.extraction.cache.ReferenceCache;
import org.splevo.jamopp.extraction.resource.JavaSourceOrClassFileResourceCachingFactoryImpl;
import tools.mdsd.jamopp.model.java.JavaClasspath;
import tools.mdsd.jamopp.parser.JaMoPPJDTParser;
import tools.mdsd.jamopp.resource.JavaResource2Factory;

public class JaMoPPSoftwareModelExtractor {
    private static final Logger LOGGER = Logger.getLogger(JaMoPPSoftwareModelExtractor.class);
    public static final boolean EXTRACTOR_EXTRACT_LAYOUT_BY_DEFAULT = false;
    public static final String EXTRACTOR_ID = "JaMoPPSoftwareModelExtractor";
    private static final String EXTRACTOR_LABEL = "JaMoPP Software Model Extractor";
    private List<Resource> sourceResources;

    public ResourceSet extractSoftwareModelFromProjects(Collection<IJavaProject> projects, IProgressMonitor monitor, String sourceModelPath, boolean extractLayoutInfo) {
        HashSet<File> javaFiles = new HashSet<File>();
        try {
            for (IJavaProject sourceProject : projects) {
                IPackageFragmentRoot[] iPackageFragmentRootArray = sourceProject.getAllPackageFragmentRoots();
                int n = iPackageFragmentRootArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IPackageFragmentRoot packageFragmentRoot = iPackageFragmentRootArray[n2];
                    if (packageFragmentRoot.getKind() == 1) {
                        IJavaElement[] iJavaElementArray = packageFragmentRoot.getChildren();
                        int n3 = iJavaElementArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IJavaElement rootChild = iJavaElementArray[n4];
                            IPackageFragment packageFragment = (IPackageFragment)rootChild;
                            IJavaElement[] iJavaElementArray2 = packageFragment.getChildren();
                            int n5 = iJavaElementArray2.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                IJavaElement sourceFile = iJavaElementArray2[n6];
                                if (sourceFile.getElementType() == 5) {
                                    javaFiles.add(sourceFile.getResource().getRawLocation().toFile());
                                }
                                ++n6;
                            }
                            ++n4;
                        }
                    }
                    ++n2;
                }
            }
        }
        catch (JavaModelException javaModelError) {
            LOGGER.warn((Object)"Error while accessing an analysed project:\n%s", (Throwable)javaModelError);
        }
        return this.loadJavaFilesIntoResourceSet(javaFiles, sourceModelPath, extractLayoutInfo);
    }

    public ResourceSet extractSoftwareModelFromFolders(Iterable<File> sourceFolders, IProgressMonitor monitor, String sourceModelPath, boolean extractLayoutInfo) {
        ArrayList<File> javaFiles = new ArrayList<File>();
        for (File sourceFolder : sourceFolders) {
            javaFiles.add(sourceFolder);
        }
        return this.loadJavaFilesIntoResourceSet(javaFiles, sourceModelPath, extractLayoutInfo);
    }

    private ResourceSet loadJavaFilesIntoResourceSet(Collection<File> javaFiles, String sourceModelPath, boolean extractLayoutInfo) {
        if (sourceModelPath != null) {
            LOGGER.info((Object)("Using cache file: " + sourceModelPath));
        }
        ResourceSet targetResourceSet = this.setUpResourceSet(sourceModelPath, extractLayoutInfo);
        ArrayList<Resource> resources = new ArrayList<Resource>();
        Path commonParent = this.findCommonParent(javaFiles).toPath();
        JaMoPPJDTParser parser = new JaMoPPJDTParser();
        parser.setResourceSet(targetResourceSet);
        if (Files.isDirectory(commonParent, new LinkOption[0])) {
            parser.parseDirectory(commonParent);
        } else if (Files.isRegularFile(commonParent, new LinkOption[0])) {
            parser.parseFile(commonParent);
        }
        resources.addAll((Collection<Resource>)targetResourceSet.getResources());
        ReferenceCache cache = this.getReferenceCache(targetResourceSet);
        int resourceCount = 0;
        for (Resource resource : resources) {
            LOGGER.info((Object)("Resolving resource: " + ++resourceCount + "/" + resources.size() + " resourceName: " + resource.getURI().toString()));
            cache.resolve(resource);
        }
        this.triggerCacheSave(targetResourceSet);
        this.sourceResources = resources;
        return targetResourceSet;
    }

    private File findCommonParent(Collection<File> files) {
        File first = files.stream().findAny().orElse(null);
        if (first == null) {
            return null;
        }
        File[] resultContainer = new File[]{first};
        files.stream().filter(file2 -> file2 != first).forEach(file -> {
            File common = this.findCommonParent(resultContainer[0], (File)file);
            if (common != null) {
                fileArray[0] = common;
            }
        });
        return first == resultContainer[0] ? null : resultContainer[0];
    }

    private File findCommonParent(File one, File other) {
        if (one == null || other == null) {
            return null;
        }
        Path currentParent = one.getAbsoluteFile().toPath().normalize();
        Path otherPath = other.getAbsoluteFile().toPath().normalize();
        while (currentParent != null) {
            if (otherPath.startsWith(currentParent)) {
                return currentParent.toFile();
            }
            currentParent = currentParent.getParent();
        }
        return null;
    }

    private void triggerCacheSave(ResourceSet targetResourceSet) {
        ReferenceCache cache = this.getReferenceCache(targetResourceSet);
        LOGGER.debug((Object)("References not resolved from Cache: " + cache.getNotResolvedFromCacheCounterReference()));
        cache.save();
    }

    private ReferenceCache getReferenceCache(ResourceSet resourceSet) {
        Map factoryMap = resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap();
        Object factoryObject = factoryMap.get("java");
        JavaSourceOrClassFileResourceCachingFactoryImpl factory = (JavaSourceOrClassFileResourceCachingFactoryImpl)factoryObject;
        return factory.getReferenceCache();
    }

    private ResourceSet setUpResourceSet(String sourceModelDirectory, boolean extractLayoutInfo) {
        ArrayList directories = Lists.newArrayList();
        if (sourceModelDirectory != null) {
            directories.add(sourceModelDirectory);
        }
        SPLevoResourceSet rs = new SPLevoResourceSet();
        rs.setURIResourceMap(new HashMap());
        this.initResourceSet((ResourceSet)rs, directories);
        return rs;
    }

    public String getId() {
        return EXTRACTOR_ID;
    }

    public String getLabel() {
        return EXTRACTOR_LABEL;
    }

    public void prepareResourceSet(ResourceSet rs, List<String> sourceModelPaths, boolean loadLayoutInformation) {
        this.initResourceSet(rs, sourceModelPaths);
    }

    private void initResourceSet(ResourceSet rs, List<String> sourceModelPaths) {
        Map options = rs.getLoadOptions();
        options.put(FileResourceHandling.ResourceHandlingOptions.USE_PLATFORM_RESOURCE, FileResourceHandling.ResourceHandlingOptions.USE_PLATFORM_RESOURCE.getDefault());
        JavaResource2Factory originalFactory = new JavaResource2Factory();
        JavaSourceOrClassFileResourceCachingFactoryImpl cachedJaMoPPFactory = new JavaSourceOrClassFileResourceCachingFactoryImpl((Resource.Factory)originalFactory, sourceModelPaths);
        JavaClasspath.get();
        Map factoryMap = rs.getResourceFactoryRegistry().getExtensionToFactoryMap();
        factoryMap.put("java", cachedJaMoPPFactory);
    }

    public List<Resource> getSourceResources() {
        return this.sourceResources;
    }
}

