/*
 * Decompiled with CFR 0.152.
 */
package org.somox.metrics;

import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.somox.metrics.MetricID;
import org.somox.sourcecodedecorator.ComponentImplementingClassesLink;

public class ClusteringRelation {
    private final ComponentImplementingClassesLink sourceComponent;
    private final ComponentImplementingClassesLink targetComponent;
    private final Map<MetricID, Double> result = new HashMap<MetricID, Double>();
    private final Map<MetricID, Double> unmodifiableResult = Collections.unmodifiableMap(this.result);
    private static DecimalFormat format = new DecimalFormat(".00");

    public ClusteringRelation(ComponentImplementingClassesLink sourceComponent, ComponentImplementingClassesLink targetComponent) {
        if (sourceComponent == null || targetComponent == null || sourceComponent == targetComponent) {
            throw new IllegalArgumentException("Components must not be null or the same in a clustering relation");
        }
        this.sourceComponent = sourceComponent;
        this.targetComponent = targetComponent;
    }

    public ComponentImplementingClassesLink getSourceComponent() {
        return this.sourceComponent;
    }

    public ComponentImplementingClassesLink getTargetComponent() {
        return this.targetComponent;
    }

    public List<ComponentImplementingClassesLink> getComponents() {
        return Collections.unmodifiableList(Arrays.asList(this.sourceComponent, this.targetComponent));
    }

    public void setResultMetric(MetricID metric, double value) {
        if (this.result.containsKey(metric)) {
            throw new IllegalArgumentException("Metric added to clustering relation is already set");
        }
        if (Double.isNaN(value) || Double.isInfinite(value)) {
            throw new IllegalArgumentException("Metric value is not a valid number. Some computations went wrong");
        }
        this.result.put(metric, value);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<MetricID, Double> metricResult : this.result.entrySet()) {
            String metricFullName = metricResult.getKey().getMetricID();
            stringBuilder.append(metricFullName.substring(metricFullName.lastIndexOf(".") + 1));
            stringBuilder.append(" = ");
            stringBuilder.append(format.format(metricResult.getValue()));
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public Map<MetricID, Double> getResult() {
        return this.unmodifiableResult;
    }
}

