/*
 * Decompiled with CFR 0.152.
 */
package org.somox.metrics.basic;

import java.util.Set;
import org.apache.log4j.Logger;
import org.somox.filter.BaseFilter;
import org.somox.filter.FilteredCollectionsFactory;
import org.somox.kdmhelper.KDMHelper;
import org.somox.metrics.ClusteringRelation;
import org.somox.metrics.MetricID;
import org.somox.metrics.abstractmetrics.AbstractCountingMetric;
import tools.mdsd.jamopp.model.java.classifiers.ConcreteClassifier;
import tools.mdsd.jamopp.model.java.commons.Commentable;

public class InterfaceAccessesCount
extends AbstractCountingMetric {
    private static final Logger logger = Logger.getLogger(InterfaceAccessesCount.class);
    public static final MetricID METRIC_ID = new MetricID("org.somox.metrics.basic.InterfaceAccessesCount");
    private static final BaseFilter<ConcreteClassifier> interfaceClassesFilter = new BaseFilter<ConcreteClassifier>(){

        public boolean passes(ConcreteClassifier clazz) {
            return KDMHelper.isInterface((Commentable)clazz);
        }
    };

    @Override
    protected void internalComputeDirected(ClusteringRelation relationToCompute) {
        Set<ConcreteClassifier> classes1 = this.getComponentToClassHelper().deriveImplementingClasses(relationToCompute.getSourceComponent());
        Set<ConcreteClassifier> classes2 = this.getComponentToClassHelper().deriveImplementingClasses(relationToCompute.getTargetComponent());
        long accessesToInterfaces = this.getAccessGraphCache().calculateNumberOfAccessesToClassesInSet(classes1, FilteredCollectionsFactory.getFilteredHashSet(interfaceClassesFilter, classes2));
        if (logger.isTraceEnabled()) {
            logger.trace((Object)(relationToCompute.getSourceComponent() + " --> " + relationToCompute.getTargetComponent() + " Interface Accesses = " + accessesToInterfaces));
        }
        relationToCompute.setResultMetric(this.getMID(), accessesToInterfaces);
    }

    @Override
    public MetricID getMID() {
        return METRIC_ID;
    }

    @Override
    public boolean isCommutative() {
        return false;
    }
}

