/*
 * Decompiled with CFR 0.152.
 */
package org.somox.metrics.helper;

import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.jgrapht.Graph;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.somox.configuration.SoMoXConfiguration;
import org.somox.filter.AccessedTargetBlacklistFilter;
import org.somox.filter.EClassBasedFilter;
import org.somox.kdmhelper.GetAccessedType;
import org.somox.kdmhelper.KDMHelper;
import org.somox.metrics.helper.ClassAccessGraphEdge;
import org.somox.metrics.helper.ComponentToImplementingClassesHelper;
import org.somox.metrics.util.GraphPrinter;
import tools.mdsd.jamopp.model.java.classifiers.ConcreteClassifier;
import tools.mdsd.jamopp.model.java.commons.Commentable;
import tools.mdsd.jamopp.model.java.types.Type;
import tools.mdsd.jamopp.model.java.types.TypeReference;

public class Class2ClassAccessGraphHelper {
    private static final Logger logger = Logger.getLogger(Class2ClassAccessGraphHelper.class);
    private static final EClassBasedFilter<TypeReference> accessFilter = new EClassBasedFilter<TypeReference>(new EClass[0]){

        public boolean passes(EObject object) {
            return object == null || !(object instanceof TypeReference) || !KDMHelper.isInheritanceTypeAccess((TypeReference)((TypeReference)object));
        }
    };

    public static DefaultDirectedGraph<ConcreteClassifier, ClassAccessGraphEdge> computeFilteredClass2ClassAccessGraph(SoMoXConfiguration somoxConfiguration, Set<ConcreteClassifier> componentsImplementingClasses) {
        DefaultDirectedGraph accessGraph = new DefaultDirectedGraph(ClassAccessGraphEdge.class);
        for (ConcreteClassifier clazz : componentsImplementingClasses) {
            accessGraph.addVertex((Object)clazz);
        }
        assert (Class2ClassAccessGraphHelper.noPrimitiveTypesAsVertexes((DefaultDirectedGraph<ConcreteClassifier, ClassAccessGraphEdge>)accessGraph));
        AccessedTargetBlacklistFilter filter = new AccessedTargetBlacklistFilter(somoxConfiguration.getClassifierFilter());
        for (ConcreteClassifier clazz : componentsImplementingClasses) {
            Class2ClassAccessGraphHelper.addAccessesToGraph((Graph<ConcreteClassifier, ClassAccessGraphEdge>)accessGraph, filter, clazz);
        }
        assert (Class2ClassAccessGraphHelper.noPrimitiveTypesAsVertexes((DefaultDirectedGraph<ConcreteClassifier, ClassAccessGraphEdge>)accessGraph));
        if (logger.isDebugEnabled()) {
            GraphPrinter.dumpGraph(new ComponentToImplementingClassesHelper(), accessGraph, somoxConfiguration.getFileLocations().getAnalyserInputFile(), 0, 0);
        }
        return accessGraph;
    }

    private static boolean noPrimitiveTypesAsVertexes(DefaultDirectedGraph<ConcreteClassifier, ClassAccessGraphEdge> accessGraph) {
        boolean result = true;
        for (Type clazz : accessGraph.vertexSet()) {
            result &= !KDMHelper.isPrimitive((Type)clazz);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private static void addAccessesToGraph(Graph<ConcreteClassifier, ClassAccessGraphEdge> graph, AccessedTargetBlacklistFilter filter, ConcreteClassifier clazz) {
        for (TypeReference singleAccess : accessFilter.filter((Iterable)KDMHelper.getAllAccesses((Commentable)clazz))) {
            void accessedClass;
            ConcreteClassifier concreteClassifier;
            Type accessedType = GetAccessedType.getAccessedType((TypeReference)singleAccess);
            Type type = accessedType;
            if (!(type instanceof ConcreteClassifier) || (concreteClassifier = (ConcreteClassifier)type) != (ConcreteClassifier)type || clazz == accessedClass) continue;
            ClassAccessGraphEdge edge = (ClassAccessGraphEdge)graph.getEdge((Object)clazz, (Object)accessedClass);
            if (edge == null) {
                if (graph.containsVertex((Object)clazz) && graph.containsVertex((Object)accessedClass)) {
                    edge = (ClassAccessGraphEdge)graph.addEdge((Object)clazz, (Object)accessedClass);
                } else {
                    logger.trace((Object)("Do not add edge between " + clazz + " and " + accessedClass));
                }
            }
            if (edge == null) continue;
            edge.incrementCount();
        }
    }
}

