/*
 * Decompiled with CFR 0.152.
 */
package org.somox.metrics.helper;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.somox.sourcecodedecorator.ComponentImplementingClassesLink;
import org.somox.sourcecodedecorator.InterfaceSourceCodeLink;
import tools.mdsd.jamopp.model.java.classifiers.ConcreteClassifier;
import tools.mdsd.jamopp.model.java.types.Type;

public class ComponentToImplementingClassesHelper {
    private final Map<ComponentImplementingClassesLink, Set<ConcreteClassifier>> mapOfImplementingClasses = new HashMap<ComponentImplementingClassesLink, Set<ConcreteClassifier>>();

    public synchronized Set<ConcreteClassifier> deriveImplementingClasses(ComponentImplementingClassesLink componentCandidate) {
        Set<ConcreteClassifier> result;
        if (!this.mapOfImplementingClasses.containsKey(componentCandidate)) {
            HashSet<ConcreteClassifier> classSet = new HashSet<ConcreteClassifier>();
            for (Type type : componentCandidate.getImplementingClasses()) {
                if (!(type instanceof ConcreteClassifier)) continue;
                classSet.add((ConcreteClassifier)type);
            }
            for (ComponentImplementingClassesLink subComponent : componentCandidate.getSubComponents()) {
                classSet.addAll(this.deriveImplementingClasses(subComponent));
            }
            for (InterfaceSourceCodeLink providedIfLink : componentCandidate.getProvidedInterfaces()) {
                if (classSet.contains(providedIfLink.getGastClass()) || !(providedIfLink.getGastClass() instanceof ConcreteClassifier)) continue;
                classSet.add(providedIfLink.getGastClass());
            }
            if (classSet.size() == 0) {
                throw new RuntimeException("Component must have associated classes");
            }
            this.mapOfImplementingClasses.put(componentCandidate, classSet);
        }
        if ((result = this.mapOfImplementingClasses.get(componentCandidate)) == null) {
            throw new IllegalStateException("The component to class cache did not contain a value which has been asserted to be there. There might be a concurrency issue here");
        }
        return result;
    }

    public Set<ConcreteClassifier> collectAllClasses(List<ComponentImplementingClassesLink> componentCandidates) {
        HashSet<ConcreteClassifier> allOtherComponentClasses = new HashSet<ConcreteClassifier>();
        for (ComponentImplementingClassesLink classLink : componentCandidates) {
            allOtherComponentClasses.addAll(this.deriveImplementingClasses(classLink));
        }
        return allOtherComponentClasses;
    }
}

