/*
 * Decompiled with CFR 0.152.
 */
package org.somox.ui.preferences;

import java.util.LinkedList;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.somox.configuration.ConfigurationDefinition;
import org.somox.ui.Activator;
import org.somox.ui.SoMoXUILogger;

public class SoMoXPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public SoMoXPreferencePage() {
        super(1);
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
        this.setDescription("SoMoX Preference Page");
    }

    public void createFieldEditors() {
        LinkedList<ConfigurationDefinition> configs = Activator.getDefault().getGuiSoMoXCoreController().getGlobalConfigurationDefinitions();
        SoMoXUILogger.logInfo("Number of configs to be build: " + configs.size());
        for (ConfigurationDefinition config : configs) {
            if (ConfigurationDefinition.Type.DIRECTORY.equals((Object)config.getType())) {
                this.addField((FieldEditor)new DirectoryFieldEditor(config.getId(), config.getName(), this.getFieldEditorParent()));
                continue;
            }
            if (ConfigurationDefinition.Type.STRING.equals((Object)config.getType())) {
                StringFieldEditor editor = new StringFieldEditor(config.getId(), config.getName(), this.getFieldEditorParent());
                if (config.getDefaultValue() != null) {
                    this.getPreferenceStore().setDefault(config.getId(), config.getDefaultValue());
                }
                this.addField((FieldEditor)editor);
                continue;
            }
            if (!ConfigurationDefinition.Type.BOOLEAN.equals((Object)config.getType())) continue;
            this.addField((FieldEditor)new BooleanFieldEditor(config.getId(), config.getName(), this.getFieldEditorParent()));
        }
    }

    public void init(IWorkbench workbench) {
    }
}

