/*
 * Decompiled with CFR 0.152.
 */
package org.somox.util;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.palladiosimulator.pcm.core.CoreFactory;
import org.palladiosimulator.pcm.core.PCMRandomVariable;
import org.palladiosimulator.pcm.repository.DataType;
import org.palladiosimulator.pcm.repository.PrimitiveDataType;
import org.palladiosimulator.pcm.repository.Repository;
import org.palladiosimulator.pcm.resourceenvironment.ProcessingResourceSpecification;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;
import org.palladiosimulator.pcm.resourceenvironment.ResourceEnvironment;
import org.palladiosimulator.pcm.resourceenvironment.ResourceenvironmentFactory;
import org.palladiosimulator.pcm.resourceenvironment.ResourceenvironmentPackage;
import org.palladiosimulator.pcm.resourcetype.ProcessingResourceType;
import org.palladiosimulator.pcm.resourcetype.ResourceRepository;
import org.palladiosimulator.pcm.resourcetype.ResourceType;
import org.palladiosimulator.pcm.resourcetype.SchedulingPolicy;

public class DefaultResourceEnvironment {
    public static final String RESOURCETYPE_URI = "pathmap://PCM_MODELS/Palladio.resourcetype";
    public static final String PRIMITIVETYPES_URI = "pathmap://PCM_MODELS/PrimitiveTypes.repository";
    private static final String CPU_RESOURCETYPE_NAME = "CPU";
    private static final String DELAY_RESOURCETYPE_NAME = "DELAY";
    private static ResourceEnvironment resourceEnvironment;
    private static ResourceRepository resourceRepository;
    private static Repository primitiveTypesRepository;

    private DefaultResourceEnvironment() {
    }

    public static ResourceEnvironment getDefaultResourceEnvironment() {
        if (resourceEnvironment == null) {
            resourceEnvironment = DefaultResourceEnvironment.createDefaultResourceEnvironment();
        }
        return resourceEnvironment;
    }

    private static Map<String, PrimitiveDataType> getPrimitiveDataTypes() {
        HashMap<String, PrimitiveDataType> primitives = new HashMap<String, PrimitiveDataType>();
        if (primitiveTypesRepository == null) {
            primitiveTypesRepository = DefaultResourceEnvironment.getPrimitiveTypesRepository();
        }
        for (DataType d : primitiveTypesRepository.getDataTypes__Repository()) {
            if (!(d instanceof PrimitiveDataType var3_3)) continue;
            primitives.put(pdt.getType().getName(), (PrimitiveDataType)pdt);
        }
        return primitives;
    }

    public static PrimitiveDataType getPrimitiveDataTypeInteger() {
        return DefaultResourceEnvironment.getPrimitiveDataTypes().get("INT");
    }

    public static PrimitiveDataType getPrimitiveDataTypeDouble() {
        return DefaultResourceEnvironment.getPrimitiveDataTypes().get("DOUBLE");
    }

    public static PrimitiveDataType getPrimitiveDataTypeBool() {
        return DefaultResourceEnvironment.getPrimitiveDataTypes().get("BOOL");
    }

    public static PrimitiveDataType getPrimitiveDataTypeChar() {
        return DefaultResourceEnvironment.getPrimitiveDataTypes().get("CHAR");
    }

    public static PrimitiveDataType getPrimitiveDataTypeByte() {
        return DefaultResourceEnvironment.getPrimitiveDataTypes().get("BYTE");
    }

    public static PrimitiveDataType getPrimitiveDataTypeString() {
        return DefaultResourceEnvironment.getPrimitiveDataTypes().get("STRING");
    }

    public static ResourceEnvironment createDefaultResourceEnvironment() {
        ResourceenvironmentFactory factory = ResourceenvironmentPackage.eINSTANCE.getResourceenvironmentFactory();
        ResourceEnvironment resourceEnvironment = factory.createResourceEnvironment();
        resourceEnvironment.setEntityName("SoMoX Default ResourceEnvironment");
        ResourceContainer container = factory.createResourceContainer();
        container.setEntityName("SoMoX Default ResourceContainer");
        ProcessingResourceSpecification spec = factory.createProcessingResourceSpecification();
        spec.setActiveResourceType_ActiveResourceSpecification(DefaultResourceEnvironment.getCPUProcessingResourceType());
        spec.setNumberOfReplicas(1);
        spec.setSchedulingPolicy(DefaultResourceEnvironment.getProcessorSharingSchedulingPolicy());
        PCMRandomVariable processingRate = CoreFactory.eINSTANCE.createPCMRandomVariable();
        processingRate.setSpecification("1");
        spec.setProcessingRate_ProcessingResourceSpecification(processingRate);
        container.getActiveResourceSpecifications_ResourceContainer().add((Object)spec);
        resourceEnvironment.getResourceContainer_ResourceEnvironment().add((Object)container);
        return resourceEnvironment;
    }

    public static SchedulingPolicy getProcessorSharingSchedulingPolicy() {
        return (SchedulingPolicy)DefaultResourceEnvironment.getResourceRepository().getSchedulingPolicies__ResourceRepository().get(0);
    }

    public static ProcessingResourceType getCPUProcessingResourceType() {
        return DefaultResourceEnvironment.getProcessingResourceType(CPU_RESOURCETYPE_NAME);
    }

    public static ProcessingResourceType getDelayProcessingResourceType() {
        return DefaultResourceEnvironment.getProcessingResourceType(DELAY_RESOURCETYPE_NAME);
    }

    private static ProcessingResourceType getProcessingResourceType(String name) {
        EList resourceTypes = DefaultResourceEnvironment.getResourceRepository().getAvailableResourceTypes_ResourceRepository();
        for (ResourceType type : resourceTypes) {
            if (!type.getEntityName().equals(name)) continue;
            return (ProcessingResourceType)type;
        }
        throw new RuntimeException("Could not find resource type named \"" + name + "\" in " + RESOURCETYPE_URI);
    }

    protected static Repository getPrimitiveTypesRepository() {
        if (primitiveTypesRepository != null) {
            return primitiveTypesRepository;
        }
        Resource.Factory.Registry reg = Resource.Factory.Registry.INSTANCE;
        Map m = reg.getExtensionToFactoryMap();
        m.put("repository", new XMIResourceFactoryImpl());
        URI uri = URI.createURI((String)PRIMITIVETYPES_URI);
        ResourceSetImpl resSet = new ResourceSetImpl();
        Resource resource = resSet.getResource(uri, true);
        primitiveTypesRepository = (Repository)resource.getContents().get(0);
        return primitiveTypesRepository;
    }

    public static ResourceRepository getResourceRepository() {
        if (resourceRepository != null) {
            return resourceRepository;
        }
        Resource.Factory.Registry reg = Resource.Factory.Registry.INSTANCE;
        Map m = reg.getExtensionToFactoryMap();
        m.put("resourcetype", new XMIResourceFactoryImpl());
        URI uri = URI.createURI((String)RESOURCETYPE_URI);
        ResourceSetImpl resSet = new ResourceSetImpl();
        Resource resource = resSet.getResource(uri, true);
        resourceRepository = (ResourceRepository)resource.getContents().get(0);
        return resourceRepository;
    }
}

