/*
 * Decompiled with CFR 0.152.
 */
package tools.descartes.dlim.generator.editor.wizards;

import java.util.Iterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;
import tools.descartes.dlim.Combinator;
import tools.descartes.dlim.Constant;
import tools.descartes.dlim.DlimFactory;
import tools.descartes.dlim.DlimPackage;
import tools.descartes.dlim.Function;
import tools.descartes.dlim.Operator;
import tools.descartes.dlim.Sequence;
import tools.descartes.dlim.TimeDependentFunctionContainer;
import tools.descartes.dlim.Trend;
import tools.descartes.dlim.assistant.CalibrationException;
import tools.descartes.dlim.assistant.Calibrator;
import tools.descartes.dlim.extractor.HLDlimParameterContainer;
import tools.descartes.dlim.generator.ModelEvaluator;
import tools.descartes.dlim.generator.editor.wizards.DlimModelWizardPage;

public class DlimTrendModelWizardPage
extends DlimModelWizardPage {
    private Text periodNumText;
    private Text listControlText;
    private Combo shapeCombo;
    private Combo operatorCombo;
    private List trendList;
    private Button addToListButton;
    private Button toggleDecompositionButton;
    private double periodNum = 7.0;
    private double offset = 0.0;
    private double periodDuration;
    private double addToList = 0.0;
    private Combinator trendCombinator;

    protected DlimTrendModelWizardPage(String pageName, Sequence rootSequence) {
        super(pageName, rootSequence);
    }

    @Override
    protected void fillInteractiveArea(Composite interactiveArea) {
        Composite textFieldComposite = new Composite(interactiveArea, 0);
        GridLayout fieldLayout = new GridLayout(4, false);
        fieldLayout.marginWidth = 5;
        fieldLayout.marginHeight = 5;
        fieldLayout.verticalSpacing = 2;
        fieldLayout.horizontalSpacing = 0;
        textFieldComposite.setLayout((Layout)fieldLayout);
        this.createPeriodNumField(textFieldComposite);
        Composite listComposite = new Composite(interactiveArea, 0);
        GridLayout listLayout = new GridLayout(1, false);
        listLayout.marginWidth = 5;
        listLayout.marginHeight = 5;
        listLayout.verticalSpacing = 0;
        listLayout.horizontalSpacing = 0;
        listComposite.setLayout((Layout)listLayout);
        this.createTrendList(listComposite);
        Composite listControlComposite = new Composite(interactiveArea, 0);
        GridLayout listControlLayout = new GridLayout(3, false);
        listControlLayout.marginWidth = 5;
        listControlLayout.marginHeight = 5;
        listControlLayout.verticalSpacing = 0;
        listControlLayout.horizontalSpacing = 4;
        listControlComposite.setLayout((Layout)listControlLayout);
        this.createListControlField(listControlComposite);
        Composite dropDownComposite = new Composite(interactiveArea, 0);
        GridLayout dropDownLayout = new GridLayout(2, false);
        dropDownLayout.marginWidth = 5;
        dropDownLayout.marginHeight = 5;
        dropDownLayout.verticalSpacing = 2;
        dropDownLayout.horizontalSpacing = 0;
        dropDownComposite.setLayout((Layout)dropDownLayout);
        this.createFormSelectionField(dropDownComposite);
        this.createOperatorSelectionField(dropDownComposite);
        Composite toggleDecompositionComposite = new Composite(interactiveArea, 0);
        GridLayout decompositionLayout = new GridLayout(1, false);
        decompositionLayout.marginWidth = 5;
        decompositionLayout.marginHeight = 5;
        decompositionLayout.verticalSpacing = 0;
        decompositionLayout.horizontalSpacing = 0;
        toggleDecompositionComposite.setLayout((Layout)decompositionLayout);
        this.createDecompositionButton(toggleDecompositionComposite);
    }

    private void createPeriodNumField(Composite parent) {
        Label fieldLabel = new Label(parent, 0);
        fieldLabel.setText("Number of Seasonal Periods within one Trend: ");
        fieldLabel.setAlignment(131072);
        this.periodNumText = new Text(parent, 2048);
        this.periodNumText.setText("" + this.periodNum);
        this.addValidationListener(this.periodNumText);
        GridData textData = new GridData();
        textData.grabExcessHorizontalSpace = false;
        textData.horizontalAlignment = 1;
        textData.widthHint = 40;
        this.periodNumText.setLayoutData((Object)textData);
    }

    private void createFormSelectionField(Composite parent) {
        Label fieldLabel = new Label(parent, 0);
        fieldLabel.setText("    Select Trend Shape: ");
        fieldLabel.setAlignment(131072);
        this.shapeCombo = new Combo(parent, 2048);
        GridData textData = new GridData();
        textData.grabExcessHorizontalSpace = true;
        textData.horizontalAlignment = 1;
        textData.widthHint = 120;
        this.shapeCombo.setLayoutData((Object)textData);
        for (String name : this.getInitialTrendNames()) {
            this.shapeCombo.add(name);
        }
        this.shapeCombo.select(0);
        this.addValidationListener(this.shapeCombo);
    }

    private void createOperatorSelectionField(Composite parent) {
        Label fieldLabel = new Label(parent, 0);
        fieldLabel.setText("    Select Operator: ");
        fieldLabel.setAlignment(131072);
        this.operatorCombo = new Combo(parent, 2048);
        GridData textData = new GridData();
        textData.grabExcessHorizontalSpace = true;
        textData.horizontalAlignment = 1;
        textData.widthHint = 120;
        this.operatorCombo.setLayoutData((Object)textData);
        Operator[] operatorArray = Operator.values();
        int n = operatorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Operator op = operatorArray[n2];
            this.operatorCombo.add(op.getLiteral());
            ++n2;
        }
        this.operatorCombo.setText("MULT");
        this.addValidationListener(this.operatorCombo);
    }

    private void createTrendList(Composite parent) {
        GridData parentData = new GridData();
        parentData.grabExcessHorizontalSpace = true;
        parentData.grabExcessVerticalSpace = true;
        parentData.horizontalAlignment = 4;
        parentData.verticalAlignment = 4;
        parentData.heightHint = 160;
        parent.setLayoutData((Object)parentData);
        Label fieldLabel = new Label(parent, 0);
        fieldLabel.setText("Interpolate max. seasonal peak to target arrival rate using Trend: ");
        fieldLabel.setAlignment(16384);
        this.trendList = new List(parent, 2048);
        GridData textData = new GridData();
        textData.grabExcessHorizontalSpace = true;
        textData.grabExcessVerticalSpace = true;
        textData.horizontalAlignment = 4;
        textData.verticalAlignment = 4;
        this.trendList.setLayoutData((Object)textData);
        this.trendList.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 127) {
                    DlimTrendModelWizardPage.this.trendList.remove(DlimTrendModelWizardPage.this.trendList.getSelectionIndices());
                    DlimTrendModelWizardPage.this.validatePage();
                }
            }
        });
    }

    private void createListControlField(Composite parent) {
        Label fieldLabel = new Label(parent, 0);
        fieldLabel.setText("    Interpolate max. seasonal peak to target arrival rate: ");
        fieldLabel.setAlignment(131072);
        this.listControlText = new Text(parent, 2048);
        this.listControlText.setText("");
        GridData textData = new GridData();
        textData.grabExcessHorizontalSpace = false;
        textData.horizontalAlignment = 1;
        textData.widthHint = 70;
        this.listControlText.setLayoutData((Object)textData);
        this.addToListButton = new Button(parent, 8);
        this.addToListButton.setText("Add");
        this.addToListButton.setEnabled(false);
        this.listControlText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    DlimTrendModelWizardPage.this.addToList = Double.parseDouble(DlimTrendModelWizardPage.this.listControlText.getText().trim());
                    DlimTrendModelWizardPage.this.addToListButton.setEnabled(true);
                }
                catch (NumberFormatException numberFormatException) {
                    DlimTrendModelWizardPage.this.addToListButton.setEnabled(false);
                }
            }
        });
        this.addToListButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.handleEvent(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.handleEvent(e);
            }

            private void handleEvent(SelectionEvent e) {
                DlimTrendModelWizardPage.this.trendList.add("" + DlimTrendModelWizardPage.this.addToList);
                DlimTrendModelWizardPage.this.validatePage();
            }
        });
    }

    private void createDecompositionButton(Composite parent) {
        GridData parentData = new GridData();
        parentData.horizontalAlignment = 4;
        parent.setLayoutData((Object)parentData);
        this.toggleDecompositionButton = new Button(parent, 32);
        this.toggleDecompositionButton.setText("Explicitly show Trend Contribution in Plot");
        this.toggleDecompositionButton.setSelection(true);
        this.toggleDecompositionButton.setLayoutData((Object)new GridData(131072, 128, true, true, 1, 1));
        this.getDlimPlotter().setDecompositionMode(true);
        this.toggleDecompositionButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DlimTrendModelWizardPage.this.getDlimPlotter().setDecompositionMode(DlimTrendModelWizardPage.this.toggleDecompositionButton.getSelection());
                DlimTrendModelWizardPage.this.validatePage();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                DlimTrendModelWizardPage.this.getDlimPlotter().setDecompositionMode(DlimTrendModelWizardPage.this.toggleDecompositionButton.getSelection());
                DlimTrendModelWizardPage.this.validatePage();
            }
        });
    }

    @Override
    protected boolean validatePage() {
        try {
            this.periodNum = Double.parseDouble(this.periodNumText.getText().trim());
            if (this.periodNum < 0.0) {
                this.setMessage("The Trends' duration cannot be negative", 3);
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.setMessage("Number of Periods per Trend must be a number.", 3);
            return false;
        }
        this.setMessage(this.getDescription());
        this.populateModel();
        this.updatePlot();
        return true;
    }

    private void populateModel() {
        DlimFactory factory = DlimPackage.eINSTANCE.getDlimFactory();
        this.getRootSequence().getCombine().remove((Object)this.trendCombinator);
        this.getRootSequence().setTerminateAfterLoops(1);
        try {
            this.trendCombinator = factory.createCombinator();
            this.trendCombinator.setOperator(Operator.get((String)this.operatorCombo.getText().trim()));
            Sequence trendSequence = factory.createSequence();
            trendSequence.setName("trends");
            trendSequence.setTerminateAfterLoops(1);
            this.trendCombinator.setFunction((Function)trendSequence);
            if (this.periodNum > 0.0 && this.trendList.getItemCount() > 1) {
                Constant offsetConstant;
                int loops = (int)this.periodNum * (this.trendList.getItemCount() - 1);
                if (this.offset > 0.0) {
                    TimeDependentFunctionContainer offsetElement = factory.createTimeDependentFunctionContainer();
                    offsetElement.setName("trendOffset");
                    offsetElement.setDuration(this.offset);
                    offsetConstant = factory.createConstant();
                    offsetElement.setFunction((Function)offsetConstant);
                    trendSequence.getSequenceFunctionContainers().add((Object)offsetElement);
                    ++loops;
                }
                int i = 1;
                while (i < this.trendList.getItemCount()) {
                    TimeDependentFunctionContainer trendElement = factory.createTimeDependentFunctionContainer();
                    trendElement.setName("trend" + i);
                    trendElement.setDuration(this.periodDuration * this.periodNum);
                    Iterator trend = (Trend)factory.create((EClass)DlimPackage.eINSTANCE.getEClassifier(this.shapeCombo.getText().trim()));
                    trendElement.setFunction((Function)trend);
                    trendSequence.getSequenceFunctionContainers().add((Object)trendElement);
                    ++i;
                }
                if (this.offset > 0.0) {
                    TimeDependentFunctionContainer offsetElement = factory.createTimeDependentFunctionContainer();
                    offsetElement.setName("holdLastValue");
                    offsetElement.setDuration(this.periodDuration - this.offset);
                    offsetConstant = factory.createConstant();
                    offsetElement.setFunction((Function)offsetConstant);
                    trendSequence.getSequenceFunctionContainers().add((Object)offsetElement);
                }
                this.getRootSequence().getCombine().add((Object)this.trendCombinator);
                this.getRootSequence().setTerminateAfterLoops(loops);
                i = 0;
                for (TimeDependentFunctionContainer e : trendSequence.getSequenceFunctionContainers()) {
                    Function f = e.getFunction();
                    if (!(f instanceof Trend)) continue;
                    Trend trend = (Trend)f;
                    trend.setFunctionOutputAtStart(this.calibrateTrendStartValue(trend, Double.parseDouble(this.trendList.getItem(i).trim()), i));
                    trend.setFunctionOutputAtEnd(this.calibrateTrendEndValue(trend, Double.parseDouble(this.trendList.getItem(++i).trim()), i));
                }
                if (this.offset > 0.0) {
                    Constant offset1 = (Constant)((TimeDependentFunctionContainer)trendSequence.getSequenceFunctionContainers().get(0)).getFunction();
                    offset1.setConstant(((Trend)((TimeDependentFunctionContainer)trendSequence.getSequenceFunctionContainers().get(1)).getFunction()).getFunctionOutputAtStart());
                    int lastIndex = trendSequence.getSequenceFunctionContainers().size() - 1;
                    Constant offset2 = (Constant)((TimeDependentFunctionContainer)trendSequence.getSequenceFunctionContainers().get(lastIndex)).getFunction();
                    offset2.setConstant(((Trend)((TimeDependentFunctionContainer)trendSequence.getSequenceFunctionContainers().get(lastIndex - 1)).getFunction()).getFunctionOutputAtEnd());
                }
            }
        }
        catch (NullPointerException nullPointerException) {}
    }

    private double calibrateTrendStartValue(Trend trend, double value, int index) {
        ModelEvaluator evaluator = new ModelEvaluator(this.getRootSequence(), 0, "dlim:calibration");
        double startValue = value;
        try {
            startValue = Calibrator.calibrateTrendStartValue((double)value, (Trend)trend, (ModelEvaluator)evaluator);
        }
        catch (CalibrationException e) {
            this.setMessage("Trend Value " + index + ": " + e.getMessage(), 2);
        }
        return startValue;
    }

    private double calibrateTrendEndValue(Trend trend, double value, int index) {
        ModelEvaluator evaluator = new ModelEvaluator(this.getRootSequence(), 0, "dlim:calibration");
        double endValue = value;
        try {
            endValue = Calibrator.calibrateTrendEndValue((double)value, (Trend)trend, (ModelEvaluator)evaluator);
        }
        catch (CalibrationException e) {
            this.setMessage("Trend Value " + index + ": " + e.getMessage(), 2);
        }
        return endValue;
    }

    protected void calculatePeriodDuration(double highestPeakTime, double periodDuration) {
        this.periodDuration = periodDuration;
        this.offset = highestPeakTime;
        try {
            this.validatePage();
        }
        catch (NullPointerException nullPointerException) {}
    }

    public String getTrendShape() {
        return this.shapeCombo.getText();
    }

    public String getOperatorLiteral() {
        return this.operatorCombo.getText();
    }

    @Override
    protected void parseParameters(HLDlimParameterContainer container) {
        this.shapeCombo.setText(container.getTrendShape());
        this.operatorCombo.setText(container.getOperatorLiteral());
        this.periodNumText.setText("" + container.getSeasonalsPerTrend());
        this.listControlText.setText("");
        this.periodNum = container.getSeasonalsPerTrend();
        this.offset = container.getTrendOffset();
        this.periodDuration = container.getSeasonalPeriod();
        this.trendList.removeAll();
        int i = 0;
        while (i < container.getTrendPoints().length) {
            this.trendList.add("" + container.getTrendPoints()[i]);
            ++i;
        }
    }
}

