/*
 * Decompiled with CFR 0.152.
 */
package tools.descartes.dlim.exporter.utils;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import tools.descartes.dlim.generator.Activator;
import tools.descartes.dlim.generator.ArrivalRateTuple;
import tools.descartes.dlim.generator.ModelEvaluator;

public final class ArrivalRateGenerator {
    private ArrivalRateGenerator() {
    }

    public static List<ArrivalRateTuple> generateArrivalRates(ModelEvaluator evaluator, double step) {
        ArrayList<ArrivalRateTuple> arrRates = new ArrayList<ArrivalRateTuple>();
        double i = step / 2.0;
        while (i < evaluator.getTerminatingDuration()) {
            double arrRate = evaluator.getArrivalRateAtTime(i);
            arrRates.add(new ArrivalRateTuple(i, arrRate));
            i += step;
        }
        return arrRates;
    }

    public static void writeArrivalRates(List<ArrivalRateTuple> arrRates, String projectPath, String modelName, String endOfLineCharacter, String fileSuffix) {
        try {
            IPath arrivalRateFolderPath = new Path(projectPath).append("arrivalRates");
            File arrivalRateFolder = arrivalRateFolderPath.toFile();
            if (!arrivalRateFolder.exists()) {
                arrivalRateFolder.mkdir();
            }
            IPath arrivalRateTxtPath = arrivalRateFolderPath.append(String.valueOf(modelName) + "ArrivalRates." + fileSuffix);
            PrintWriter arrRateWriter = new PrintWriter(arrivalRateTxtPath.toString(), "UTF-8");
            for (ArrivalRateTuple tuple : arrRates) {
                double arrRate = tuple.getArrivalRate();
                double time = tuple.getTimeStamp();
                arrRateWriter.println(String.valueOf(time) + "," + arrRate + endOfLineCharacter);
            }
            arrRateWriter.close();
        }
        catch (FileNotFoundException e) {
            Activator.getInstance().log((IStatus)new Status(4, "tools.descartes.dlim.generator", "IO error writing Arrival Rate file.", (Throwable)e));
        }
        catch (UnsupportedEncodingException e) {
            Activator.getInstance().log((IStatus)new Status(4, "tools.descartes.dlim.generator", "IO error writing Arrival Rate file.", (Throwable)e));
        }
    }
}

