/*
 * Decompiled with CFR 0.152.
 */
package tools.descartes.dlim.extractor.utils;

import java.util.List;
import tools.descartes.dlim.extractor.utils.ExtractionDataContainer;
import tools.descartes.dlim.extractor.utils.ISplittingRule;
import tools.descartes.dlim.generator.ArrivalRateTuple;

public class TimeDistanceSplittingHeuristic
implements ISplittingRule {
    private static final double MAX_MEAN_DEVIATION = 0.08;
    private static final int MAX_DEVIATING_MATCHES = 3;
    private static final double MAX_MEAN_PEAK_DIFFERENCE = 0.12;

    @Override
    public boolean warrantSplit(ExtractionDataContainer cleft, ExtractionDataContainer cright) {
        if (cleft.getDuration() / cleft.getPeriod() <= 3.0 || cright.getDuration() / cright.getPeriod() <= 3.0) {
            return false;
        }
        return this.doPeaksDiffer(cleft, cright) || this.areMeanMaxTimesDifferent(cleft, cright);
    }

    private boolean doPeaksDiffer(ExtractionDataContainer cleft, ExtractionDataContainer cright) {
        double leftPeriodCount = cleft.getDuration() / cleft.getPeriod();
        double leftPeaks = (double)cleft.getLocalMaxes().size() / leftPeriodCount;
        double rightPeriodCount = cright.getDuration() / cright.getPeriod();
        double rightPeaks = (double)cright.getLocalMaxes().size() / rightPeriodCount;
        System.out.println("Relative Peak Difference = " + Math.abs(leftPeaks - rightPeaks) / leftPeaks * 100.0 + "%");
        return Math.abs(leftPeaks - rightPeaks) / leftPeaks > 0.12;
    }

    private boolean areMeanMaxTimesDifferent(ExtractionDataContainer cleft, ExtractionDataContainer cright) {
        int deviationcount = 0;
        double period = cleft.getPeriod();
        double[] leftDist = new double[3];
        leftDist[0] = this.getMeanDistanceFromWindowStart(cleft.getLocalMaxes(), 0.0, period);
        double windowStart = this.middlePeriodStart(cleft);
        leftDist[1] = this.getMeanDistanceFromWindowStart(cleft.getLocalMaxes(), windowStart, windowStart + period);
        windowStart = this.lastPeriodStart(cleft);
        leftDist[2] = this.getMeanDistanceFromWindowStart(cleft.getLocalMaxes(), windowStart, windowStart + period);
        double[] rightDist = new double[3];
        rightDist[0] = this.getMeanDistanceFromWindowStart(cright.getLocalMaxes(), 0.0, period);
        windowStart = this.middlePeriodStart(cright);
        rightDist[1] = this.getMeanDistanceFromWindowStart(cright.getLocalMaxes(), windowStart, windowStart + period);
        windowStart = this.lastPeriodStart(cright);
        rightDist[2] = this.getMeanDistanceFromWindowStart(cright.getLocalMaxes(), windowStart, windowStart + period);
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                System.out.println("Deviation = " + Math.abs(leftDist[i] - rightDist[j]) / period);
                if (Math.abs(leftDist[i] - rightDist[j]) / period > 0.08) {
                    ++deviationcount;
                }
                ++j;
            }
            ++i;
        }
        System.out.println("Deviation Counts = " + deviationcount);
        return deviationcount > 3;
    }

    private double getMeanDistanceFromWindowStart(List<ArrivalRateTuple> tuples, double windowStart, double windowEnd) {
        double sum = 0.0;
        int count = 0;
        for (ArrivalRateTuple t : tuples) {
            double ts = t.getTimeStamp();
            if (ts >= windowEnd) break;
            if (!(ts >= windowStart) || !(ts < windowEnd)) continue;
            sum += ts - windowStart;
            ++count;
        }
        return sum / (double)count;
    }

    private double lastPeriodStart(ExtractionDataContainer container) {
        int iterationNum = (int)(container.getDuration() / container.getPeriod()) - 1;
        return container.getPeriod() * (double)iterationNum;
    }

    private double middlePeriodStart(ExtractionDataContainer container) {
        int iterationNum = (int)(container.getDuration() / container.getPeriod() - 1.0) / 2;
        return container.getPeriod() * (double)iterationNum;
    }
}

