/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.dialogs.selection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderDecorator;

public class FilteringItemProvider
extends ItemProviderDecorator
implements ITreeItemContentProvider {
    private Collection<?> filterList;
    private Collection<EReference> additionalChildReferences;

    public FilteringItemProvider(AdapterFactory adapterFactory, Collection<?> filterList, Collection<EReference> additionalChildReferences) {
        super(adapterFactory);
        this.filterList = filterList;
        this.additionalChildReferences = additionalChildReferences;
    }

    public Collection<?> getChildren(Object object) {
        ArrayList<Object> unfilteredResult = null;
        if (object instanceof ResourceSet) {
            ArrayList<Object> result = new ArrayList<Object>();
            ResourceSet rs = (ResourceSet)object;
            for (Resource resource : rs.getResources()) {
                ITreeItemContentProvider provider = (ITreeItemContentProvider)this.adapterFactory.adapt((Object)resource, ITreeItemContentProvider.class);
                result.addAll(provider.getChildren((Object)resource));
            }
            unfilteredResult = result;
        } else {
            unfilteredResult = ((ITreeItemContentProvider)this.getDecoratedItemProvider()).getChildren(object);
        }
        for (EReference additionalReference : this.additionalChildReferences) {
            if (!additionalReference.getContainerClass().isInstance(object)) continue;
            Object object2 = ((EObject)object).eGet((EStructuralFeature)additionalReference);
            if (object2 instanceof Collection) {
                unfilteredResult.addAll((Collection)object2);
                continue;
            }
            unfilteredResult.add(object2);
        }
        ArrayList filteredResult = new ArrayList();
        for (Object e : unfilteredResult) {
            if (e == null) continue;
            for (Class c : (List)this.filterList) {
                if (!c.isAssignableFrom(e.getClass())) continue;
                filteredResult.add(e);
            }
        }
        return filteredResult;
    }

    public Collection<?> getElements(Object object) {
        return this.getChildren(object);
    }

    public boolean hasChildren(Object object) {
        return this.getChildren(object).size() > 0;
    }
}

