/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.errorhandling.dialogs.issues;

import de.uka.ipd.sdq.errorhandling.core.SeverityAndIssue;
import de.uka.ipd.sdq.errorhandling.core.SeverityEnum;
import de.uka.ipd.sdq.errorhandling.dialogs.issues.ErrorhandlingDialogImages;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class IssuesDialog
extends Dialog {
    public static final int IGNORE_BUTTON = 2;
    private List<SeverityAndIssue> issues;
    private Text detailsText;
    private Table table;

    public IssuesDialog(Shell parentShell, List<SeverityAndIssue> issues) {
        super(parentShell);
        this.setShellStyle(1040);
        this.issues = issues;
        Collections.sort(this.issues);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        this.table = new Table(container, 67584);
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IssuesDialog.this.updateDetails();
            }
        });
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.table.setLayoutData((Object)new GridData(4, 4, true, true));
        TableColumn newColumnTableColumn = new TableColumn(this.table, 0);
        newColumnTableColumn.setWidth(81);
        newColumnTableColumn.setText("Severity");
        TableColumn newColumnTableColumn_1 = new TableColumn(this.table, 0);
        newColumnTableColumn_1.setWidth(317);
        newColumnTableColumn_1.setText("Message");
        TableColumn newColumnTableColumn_2 = new TableColumn(this.table, 0);
        newColumnTableColumn_2.setWidth(100);
        newColumnTableColumn_2.setText("Element");
        TableColumn newColumnTableColumn_3 = new TableColumn(this.table, 0);
        newColumnTableColumn_3.setWidth(150);
        newColumnTableColumn_3.setText("Resource");
        this.fillTable(this.table);
        Group detailsGroup = new Group(container, 0);
        GridData gd_detailsGroup = new GridData(4, 0x1000000, true, false);
        gd_detailsGroup.heightHint = 92;
        detailsGroup.setLayoutData((Object)gd_detailsGroup);
        detailsGroup.setText("Details");
        detailsGroup.setLayout((Layout)new GridLayout());
        this.detailsText = new Text((Composite)detailsGroup, 2888);
        this.detailsText.setLayoutData((Object)new GridData(4, 4, true, true));
        return container;
    }

    protected void updateDetails() {
        if (this.table.getSelectionIndex() > -1) {
            SeverityAndIssue sai = this.issues.get(this.table.getSelectionIndex());
            this.detailsText.setText(sai.getDetails());
        }
    }

    private void fillTable(Table table) {
        TableViewer tableViewer = new TableViewer(table);
        tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                viewer.refresh();
            }

            public Object[] getElements(Object inputElement) {
                return IssuesDialog.this.issues.toArray();
            }
        });
        tableViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                SeverityAndIssue sai = (SeverityAndIssue)element;
                switch (columnIndex) {
                    case 0: {
                        if (sai.getError() == SeverityEnum.ERROR) {
                            return ErrorhandlingDialogImages.imageRegistry.get("error");
                        }
                        return ErrorhandlingDialogImages.imageRegistry.get("warning");
                    }
                }
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                SeverityAndIssue sai = (SeverityAndIssue)element;
                switch (columnIndex) {
                    case 0: {
                        if (sai.getError() == SeverityEnum.ERROR) {
                            return "ERROR";
                        }
                        return "WARNING";
                    }
                    case 1: {
                        return sai.getMessage();
                    }
                    case 2: {
                        if (sai.getElement() != null) {
                            return sai.getElement().toString();
                        }
                        return "";
                    }
                    case 3: {
                        return sai.getResourceName();
                    }
                }
                return null;
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        tableViewer.setInput(this.issues);
    }

    private void disableIgnoreButton() {
        this.getButton(2).setEnabled(false);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 2, "Ignore", false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, true);
        for (SeverityAndIssue sai : this.issues) {
            if (sai.getError() != SeverityEnum.ERROR) continue;
            this.disableIgnoreButton();
            break;
        }
    }

    protected Point getInitialSize() {
        return new Point(661, 463);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Issues have been reported");
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 2) {
            this.setReturnCode(2);
            this.close();
            return;
        }
        super.buttonPressed(buttonId);
    }
}

