/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.identifier.uiutils;

import de.uka.ipd.sdq.identifier.Identifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.ChangeCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class AbstractIdentifierRandomizerCommandHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        List<EObject> selectedEObjects = this.getSelectedEObjects(event);
        HashMap<EditingDomain, List> groupedEObjects = new HashMap<EditingDomain, List>();
        for (EObject eObject : selectedEObjects) {
            EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)eObject);
            if (editingDomain == null) {
                throw new ExecutionException("Could not find an editing domain for every element.");
            }
            List eobjectGroup = groupedEObjects.computeIfAbsent(editingDomain, e -> new ArrayList());
            eobjectGroup.add(eObject);
        }
        for (Map.Entry entry : groupedEObjects.entrySet()) {
            this.randomizeIDsForSelectionGroup((EditingDomain)entry.getKey(), (Collection)entry.getValue());
        }
        return null;
    }

    protected void randomizeIDsForSelectionGroup(EditingDomain editingDomain, Collection<EObject> selectedEObjects) {
        this.executeInTransaction(editingDomain, () -> this.randomizeIDsForSelectedEObjects(selectedEObjects));
    }

    protected abstract void randomizeIDsForSelectedEObjects(Collection<EObject> var1);

    protected List<EObject> getSelectedEObjects(ExecutionEvent event) {
        IStructuredSelection selection = HandlerUtil.getCurrentStructuredSelection((ExecutionEvent)event);
        ArrayList<EObject> selectedEObjects = new ArrayList<EObject>();
        for (Object selectedElement : selection) {
            if (!(selectedElement instanceof EObject)) continue;
            selectedEObjects.add((EObject)selectedElement);
        }
        return selectedEObjects;
    }

    protected void executeInTransaction(EditingDomain editingDomain, final Runnable runnable) {
        editingDomain.getCommandStack().execute((Command)new ChangeCommand((Notifier)editingDomain.getResourceSet()){

            protected void doExecute() {
                runnable.run();
            }
        });
    }

    protected void randomizeID(EObject eobject) {
        if (eobject instanceof Identifier) {
            ((Identifier)eobject).setId(EcoreUtil.generateUUID());
        }
    }
}

