/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package de.uka.ipd.sdq.probfunction.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

import de.uka.ipd.sdq.probfunction.util.ProbfunctionAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers. The
 * adapters generated by this factory convert EMF adapter notifications into calls to
 * {@link #fireNotifyChanged fireNotifyChanged}. The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances. <!-- begin-user-doc --> <!--
 * end-user-doc -->
 *
 * @generated
 */
public class ProbfunctionItemProviderAdapterFactory extends ProbfunctionAdapterFactory implements
        ComposeableAdapterFactory, IChangeNotifier, IDisposable {

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    public static final String copyright = "Copyright 2007-2017, Palladiosimulator.org";

    /**
     * This keeps track of the root adapter factory that delegates to this adapter factory. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected ComposedAdapterFactory parentAdapterFactory;

    /**
     * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected IChangeNotifier changeNotifier = new ChangeNotifier();

    /**
     * This keeps track of all the supported types checked by {@link #isFactoryForType
     * isFactoryForType}. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected Collection<Object> supportedTypes = new ArrayList<Object>();

    /**
     * This constructs an instance. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    public ProbfunctionItemProviderAdapterFactory() {
        this.supportedTypes.add(IEditingDomainItemProvider.class);
        this.supportedTypes.add(IStructuredItemContentProvider.class);
        this.supportedTypes.add(ITreeItemContentProvider.class);
        this.supportedTypes.add(IItemLabelProvider.class);
        this.supportedTypes.add(IItemPropertySource.class);
    }

    /**
     * This keeps track of the one adapter used for all {@link de.uka.ipd.sdq.probfunction.BoxedPDF}
     * instances. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected BoxedPDFItemProvider boxedPDFItemProvider;

    /**
     * This creates an adapter for a {@link de.uka.ipd.sdq.probfunction.BoxedPDF}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createBoxedPDFAdapter() {
        if (this.boxedPDFItemProvider == null) {
            this.boxedPDFItemProvider = new BoxedPDFItemProvider(this);
        }

        return this.boxedPDFItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link de.uka.ipd.sdq.probfunction.ContinuousSample} instances. <!-- begin-user-doc --> <!--
     * end-user-doc -->
     *
     * @generated
     */
    protected ContinuousSampleItemProvider continuousSampleItemProvider;

    /**
     * This creates an adapter for a {@link de.uka.ipd.sdq.probfunction.ContinuousSample}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createContinuousSampleAdapter() {
        if (this.continuousSampleItemProvider == null) {
            this.continuousSampleItemProvider = new ContinuousSampleItemProvider(this);
        }

        return this.continuousSampleItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link de.uka.ipd.sdq.probfunction.ProbabilityMassFunction} instances. <!-- begin-user-doc
     * --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected ProbabilityMassFunctionItemProvider probabilityMassFunctionItemProvider;

    /**
     * This creates an adapter for a {@link de.uka.ipd.sdq.probfunction.ProbabilityMassFunction}.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createProbabilityMassFunctionAdapter() {
        if (this.probabilityMassFunctionItemProvider == null) {
            this.probabilityMassFunctionItemProvider = new ProbabilityMassFunctionItemProvider(this);
        }

        return this.probabilityMassFunctionItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link de.uka.ipd.sdq.probfunction.Sample}
     * instances. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected SampleItemProvider sampleItemProvider;

    /**
     * This creates an adapter for a {@link de.uka.ipd.sdq.probfunction.Sample}. <!-- begin-user-doc
     * --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createSampleAdapter() {
        if (this.sampleItemProvider == null) {
            this.sampleItemProvider = new SampleItemProvider(this);
        }

        return this.sampleItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link de.uka.ipd.sdq.probfunction.SamplePDF} instances. <!-- begin-user-doc --> <!--
     * end-user-doc -->
     *
     * @generated
     */
    protected SamplePDFItemProvider samplePDFItemProvider;

    /**
     * This creates an adapter for a {@link de.uka.ipd.sdq.probfunction.SamplePDF}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createSamplePDFAdapter() {
        if (this.samplePDFItemProvider == null) {
            this.samplePDFItemProvider = new SamplePDFItemProvider(this);
        }

        return this.samplePDFItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link de.uka.ipd.sdq.probfunction.Complex}
     * instances. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected ComplexItemProvider complexItemProvider;

    /**
     * This creates an adapter for a {@link de.uka.ipd.sdq.probfunction.Complex}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createComplexAdapter() {
        if (this.complexItemProvider == null) {
            this.complexItemProvider = new ComplexItemProvider(this);
        }

        return this.complexItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link de.uka.ipd.sdq.probfunction.ExponentialDistribution} instances. <!-- begin-user-doc
     * --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected ExponentialDistributionItemProvider exponentialDistributionItemProvider;

    /**
     * This creates an adapter for a {@link de.uka.ipd.sdq.probfunction.ExponentialDistribution}.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createExponentialDistributionAdapter() {
        if (this.exponentialDistributionItemProvider == null) {
            this.exponentialDistributionItemProvider = new ExponentialDistributionItemProvider(this);
        }

        return this.exponentialDistributionItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link de.uka.ipd.sdq.probfunction.NormalDistribution} instances. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     *
     * @generated
     */
    protected NormalDistributionItemProvider normalDistributionItemProvider;

    /**
     * This creates an adapter for a {@link de.uka.ipd.sdq.probfunction.NormalDistribution}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createNormalDistributionAdapter() {
        if (this.normalDistributionItemProvider == null) {
            this.normalDistributionItemProvider = new NormalDistributionItemProvider(this);
        }

        return this.normalDistributionItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link de.uka.ipd.sdq.probfunction.LognormalDistribution} instances. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     *
     * @generated
     */
    protected LognormalDistributionItemProvider lognormalDistributionItemProvider;

    /**
     * This creates an adapter for a {@link de.uka.ipd.sdq.probfunction.LognormalDistribution}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createLognormalDistributionAdapter() {
        if (this.lognormalDistributionItemProvider == null) {
            this.lognormalDistributionItemProvider = new LognormalDistributionItemProvider(this);
        }

        return this.lognormalDistributionItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link de.uka.ipd.sdq.probfunction.GammaDistribution} instances. <!-- begin-user-doc --> <!--
     * end-user-doc -->
     *
     * @generated
     */
    protected GammaDistributionItemProvider gammaDistributionItemProvider;

    /**
     * This creates an adapter for a {@link de.uka.ipd.sdq.probfunction.GammaDistribution}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createGammaDistributionAdapter() {
        if (this.gammaDistributionItemProvider == null) {
            this.gammaDistributionItemProvider = new GammaDistributionItemProvider(this);
        }

        return this.gammaDistributionItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link de.uka.ipd.sdq.probfunction.IntSample} instances. <!-- begin-user-doc --> <!--
     * end-user-doc -->
     *
     * @generated
     */
    protected IntSampleItemProvider intSampleItemProvider;

    /**
     * This creates an adapter for a {@link de.uka.ipd.sdq.probfunction.IntSample}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createIntSampleAdapter() {
        if (this.intSampleItemProvider == null) {
            this.intSampleItemProvider = new IntSampleItemProvider(this);
        }

        return this.intSampleItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link de.uka.ipd.sdq.probfunction.BoolSample} instances. <!-- begin-user-doc --> <!--
     * end-user-doc -->
     *
     * @generated
     */
    protected BoolSampleItemProvider boolSampleItemProvider;

    /**
     * This creates an adapter for a {@link de.uka.ipd.sdq.probfunction.BoolSample}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createBoolSampleAdapter() {
        if (this.boolSampleItemProvider == null) {
            this.boolSampleItemProvider = new BoolSampleItemProvider(this);
        }

        return this.boolSampleItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link de.uka.ipd.sdq.probfunction.DoubleSample} instances. <!-- begin-user-doc --> <!--
     * end-user-doc -->
     *
     * @generated
     */
    protected DoubleSampleItemProvider doubleSampleItemProvider;

    /**
     * This creates an adapter for a {@link de.uka.ipd.sdq.probfunction.DoubleSample}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createDoubleSampleAdapter() {
        if (this.doubleSampleItemProvider == null) {
            this.doubleSampleItemProvider = new DoubleSampleItemProvider(this);
        }

        return this.doubleSampleItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link de.uka.ipd.sdq.probfunction.StringSample} instances. <!-- begin-user-doc --> <!--
     * end-user-doc -->
     *
     * @generated
     */
    protected StringSampleItemProvider stringSampleItemProvider;

    /**
     * This creates an adapter for a {@link de.uka.ipd.sdq.probfunction.StringSample}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createStringSampleAdapter() {
        if (this.stringSampleItemProvider == null) {
            this.stringSampleItemProvider = new StringSampleItemProvider(this);
        }

        return this.stringSampleItemProvider;
    }

    /**
     * This returns the root adapter factory that contains this factory. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public ComposeableAdapterFactory getRootAdapterFactory() {
        return this.parentAdapterFactory == null ? this : this.parentAdapterFactory.getRootAdapterFactory();
    }

    /**
     * This sets the composed adapter factory that contains this factory. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public void setParentAdapterFactory(final ComposedAdapterFactory parentAdapterFactory) {
        this.parentAdapterFactory = parentAdapterFactory;
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public boolean isFactoryForType(final Object type) {
        return this.supportedTypes.contains(type) || super.isFactoryForType(type);
    }

    /**
     * This implementation substitutes the factory itself as the key for the adapter. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter adapt(final Notifier notifier, final Object type) {
        return super.adapt(notifier, this);
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Object adapt(final Object object, final Object type) {
        if (this.isFactoryForType(type)) {
            final Object adapter = super.adapt(object, type);
            if (!(type instanceof Class<?>) || (((Class<?>) type).isInstance(adapter))) {
                return adapter;
            }
        }

        return null;
    }

    /**
     * This adds a listener. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public void addListener(final INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.addListener(notifyChangedListener);
    }

    /**
     * This removes a listener. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public void removeListener(final INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.removeListener(notifyChangedListener);
    }

    /**
     * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public void fireNotifyChanged(final Notification notification) {
        this.changeNotifier.fireNotifyChanged(notification);

        if (this.parentAdapterFactory != null) {
            this.parentAdapterFactory.fireNotifyChanged(notification);
        }
    }

    /**
     * This disposes all of the item providers created by this factory. <!-- begin-user-doc --> <!--
     * end-user-doc -->
     *
     * @generated
     */
    @Override
    public void dispose() {
        if (this.boxedPDFItemProvider != null) {
            this.boxedPDFItemProvider.dispose();
        }
        if (this.continuousSampleItemProvider != null) {
            this.continuousSampleItemProvider.dispose();
        }
        if (this.probabilityMassFunctionItemProvider != null) {
            this.probabilityMassFunctionItemProvider.dispose();
        }
        if (this.sampleItemProvider != null) {
            this.sampleItemProvider.dispose();
        }
        if (this.samplePDFItemProvider != null) {
            this.samplePDFItemProvider.dispose();
        }
        if (this.complexItemProvider != null) {
            this.complexItemProvider.dispose();
        }
        if (this.exponentialDistributionItemProvider != null) {
            this.exponentialDistributionItemProvider.dispose();
        }
        if (this.normalDistributionItemProvider != null) {
            this.normalDistributionItemProvider.dispose();
        }
        if (this.lognormalDistributionItemProvider != null) {
            this.lognormalDistributionItemProvider.dispose();
        }
        if (this.gammaDistributionItemProvider != null) {
            this.gammaDistributionItemProvider.dispose();
        }
        if (this.intSampleItemProvider != null) {
            this.intSampleItemProvider.dispose();
        }
        if (this.boolSampleItemProvider != null) {
            this.boolSampleItemProvider.dispose();
        }
        if (this.doubleSampleItemProvider != null) {
            this.doubleSampleItemProvider.dispose();
        }
        if (this.stringSampleItemProvider != null) {
            this.stringSampleItemProvider.dispose();
        }
    }

}
