/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.probfunction.math.apache.distribution;

import org.apache.commons.math.MathException;
import org.apache.commons.math.distribution.AbstractIntegerDistribution;

public class UniformIntDistributionImpl
extends AbstractIntegerDistribution {
    private static final long serialVersionUID = 4771624459254238355L;
    int a;
    int b;
    int intCount;

    public int getA() {
        return this.a;
    }

    public int getB() {
        return this.b;
    }

    public UniformIntDistributionImpl(int a, int b) throws MathException {
        if (b < a) {
            throw new MathException("Second value has to be greater than first value of interval", new Object[0]);
        }
        this.a = a;
        this.b = b;
        this.intCount = b - a + 1;
    }

    public double cumulativeProbability(int x) throws MathException {
        if (x < this.a) {
            return 0.0;
        }
        if (x > this.b) {
            return 1.0;
        }
        return (double)(x - this.a + 1) / (double)this.intCount;
    }

    protected int getDomainLowerBound(double p) {
        return this.a;
    }

    protected int getDomainUpperBound(double p) {
        return this.b;
    }

    public double probability(int x) {
        if (x < this.a || x > this.b) {
            return 0.0;
        }
        return 1.0 / (double)this.intCount;
    }

    public double getMean() {
        return (double)(this.a + this.b) / 2.0;
    }

    public double getVariance() {
        return -1.0 * (double)this.intCount * (double)this.intCount / 12.0;
    }
}

