/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.statistics.independence;

import de.uka.ipd.sdq.probfunction.math.IChiSquareDistribution;
import de.uka.ipd.sdq.probfunction.math.IContinousPDFFactory;
import de.uka.ipd.sdq.probfunction.math.apache.impl.PDFFactory;
import de.uka.ipd.sdq.statistics.independence.IIndependenceTest;
import java.util.Collection;
import org.apache.log4j.Logger;

public class RunUpTest
implements IIndependenceTest {
    private static final Logger LOGGER = Logger.getLogger(RunUpTest.class);
    private static final int LOWER_SAMPLE_LIMIT = 4000;
    private static final int CHI_SQUARE_DOF = 6;
    private static final double CHI_SQUARE_LOWER_QUANTILE = 0.01;
    private static final double CHI_SQUARE_UPPER_QUANTILE = 0.99;
    private static final double[][] A = new double[][]{{4529.4, 9044.9, 13568.0, 18091.0, 22615.0, 27892.0}, {9044.9, 18097.0, 27139.0, 36187.0, 45234.0, 55789.0}, {13568.0, 27139.0, 40721.0, 54281.0, 67852.0, 83685.0}, {18091.0, 36187.0, 54281.0, 72414.0, 90470.0, 111580.0}, {22615.0, 45234.0, 67852.0, 90470.0, 113262.0, 139476.0}, {27892.0, 55789.0, 83685.0, 111580.0, 139476.0, 172860.0}};
    private static final double[] B = new double[]{0.16666666666666666, 0.20833333333333334, 0.09166666666666666, 0.02638888888888889, 0.005753968253968254, 0.0011904761904761906};
    private IContinousPDFFactory pdfFactory;

    public RunUpTest() {
        this((IContinousPDFFactory)new PDFFactory());
    }

    public RunUpTest(IContinousPDFFactory pdfFactory) {
        assert (pdfFactory != null) : "The passed PDF factory may not be null.";
        this.pdfFactory = pdfFactory;
    }

    @Override
    public boolean testIndependence(Collection<Double> samples) {
        int[] runCounts = this.calculateRunCounts(samples);
        int n = samples.size();
        double sum = 0.0;
        int i = 0;
        while (i < 6) {
            int j = 0;
            while (j < 6) {
                sum += ((double)runCounts[i] - (double)n * B[i]) * ((double)runCounts[j] - (double)n * B[j]) * A[i][j];
                ++j;
            }
            ++i;
        }
        double V = 1.0 / (double)(n - 6) * sum;
        IChiSquareDistribution dist = this.pdfFactory.createChiSquareDistribution(6);
        double upperQuantile = dist.inverseF(0.99);
        double lowerQuantile = dist.inverseF(0.01);
        LOGGER.info((Object)("Run Up Indepence test: F=" + V));
        return V >= lowerQuantile && V <= upperQuantile;
    }

    @Override
    public int getLowerSampleLimit() {
        return 4000;
    }

    private int[] calculateRunCounts(Collection<Double> sequence) {
        int[] runCounts = new int[6];
        int length = 0;
        double highest = Double.MIN_VALUE;
        for (Double d : sequence) {
            if (d > highest) {
                ++length;
            } else {
                if (length > 6) {
                    length = 6;
                }
                int n = length - 1;
                runCounts[n] = runCounts[n] + 1;
                length = 1;
            }
            highest = d;
        }
        return runCounts;
    }
}

