/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.statistics.estimation;

import de.uka.ipd.sdq.probfunction.math.IContinousPDFFactory;
import de.uka.ipd.sdq.probfunction.math.IStudentTDistribution;
import de.uka.ipd.sdq.probfunction.math.apache.impl.PDFFactory;
import de.uka.ipd.sdq.statistics.estimation.ConfidenceInterval;
import de.uka.ipd.sdq.statistics.estimation.IConfidenceEstimator;
import de.uka.ipd.sdq.statistics.estimation.IPointEstimator;
import de.uka.ipd.sdq.statistics.estimation.SampleVarianceEstimator;
import java.util.List;

public class SampleMeanEstimator
implements IPointEstimator,
IConfidenceEstimator {
    private IContinousPDFFactory pdfFactory;

    public SampleMeanEstimator() {
        this((IContinousPDFFactory)new PDFFactory());
    }

    public SampleMeanEstimator(IContinousPDFFactory pdfFactory) {
        assert (pdfFactory != null) : "The passed PDF factory may not be null.";
        this.pdfFactory = pdfFactory;
    }

    @Override
    public ConfidenceInterval estimateConfidence(List<Double> samples, double level) {
        int degreesOfFreedom = samples.size() - 1;
        if (degreesOfFreedom > 0) {
            IStudentTDistribution dist = this.pdfFactory.createStudentTDistribution(degreesOfFreedom);
            double upperQuantile = dist.inverseF(level);
            double stdDev = Math.sqrt(new SampleVarianceEstimator().estimatePoint(samples));
            double mean = this.estimatePoint(samples);
            double lowerBound = mean - upperQuantile * stdDev / Math.sqrt(samples.size());
            double upperBound = mean + upperQuantile * stdDev / Math.sqrt(samples.size());
            return new ConfidenceInterval(mean, lowerBound, upperBound, level);
        }
        return null;
    }

    @Override
    public double estimatePoint(List<Double> samples) {
        double sum = 0.0;
        for (Double sample : samples) {
            sum += sample.doubleValue();
        }
        return sum / (double)samples.size();
    }
}

