/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.stoex.analyser.operations;

import de.uka.ipd.sdq.probfunction.math.IProbabilityDensityFunction;
import de.uka.ipd.sdq.probfunction.math.IProbabilityFunctionFactory;
import de.uka.ipd.sdq.probfunction.math.IProbabilityMassFunction;
import de.uka.ipd.sdq.probfunction.math.ISample;
import de.uka.ipd.sdq.probfunction.math.IUnit;
import de.uka.ipd.sdq.probfunction.math.exception.DifferentDomainsException;
import de.uka.ipd.sdq.probfunction.math.exception.DomainNotNumbersException;
import de.uka.ipd.sdq.probfunction.math.exception.FunctionsInDifferenDomainsException;
import de.uka.ipd.sdq.probfunction.math.exception.IncompatibleUnitsException;
import de.uka.ipd.sdq.probfunction.math.exception.UnknownPDFTypeException;
import de.uka.ipd.sdq.stoex.analyser.operations.ValueBasedComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

public abstract class TermProductOperation {
    public IProbabilityMassFunction compute(IProbabilityMassFunction left, IProbabilityMassFunction right) throws DifferentDomainsException {
        IUnit resultUnit = IProbabilityFunctionFactory.eINSTANCE.createUnit(left.getUnit() + " * " + right.getUnit());
        boolean resultHasOrderedDomain = left.hasOrderedDomain() && right.hasOrderedDomain();
        boolean isInteger = this.isIntegerSample(left) && this.isIntegerSample(right);
        ArrayList<ISample> resultList = new ArrayList<ISample>();
        for (ISample sleft : left.getSamples()) {
            for (ISample sright : right.getSamples()) {
                if (isInteger) {
                    resultList.add(IProbabilityFunctionFactory.eINSTANCE.createSample((Object)new Integer(this.calculateOperationForValues(this.getDoubleValue(sleft), this.getDoubleValue(sright)).intValue()), sleft.getProbability() * sright.getProbability()));
                    continue;
                }
                resultList.add(IProbabilityFunctionFactory.eINSTANCE.createSample((Object)new Double(this.calculateOperationForValues(this.getDoubleValue(sleft), this.getDoubleValue(sright))), sleft.getProbability() * sright.getProbability()));
            }
        }
        Collections.sort(resultList, new ValueBasedComparator());
        Iterator iterator = resultList.iterator();
        if (iterator.hasNext()) {
            ISample previousSample = (ISample)iterator.next();
            while (iterator.hasNext()) {
                ISample iSample = (ISample)iterator.next();
                if (iSample.getValue().equals(previousSample.getValue())) {
                    iterator.remove();
                    previousSample.setProbability(previousSample.getProbability() + iSample.getProbability());
                    continue;
                }
                previousSample = iSample;
            }
        }
        return IProbabilityFunctionFactory.eINSTANCE.createProbabilityMassFunction(resultList, resultUnit, resultHasOrderedDomain);
    }

    private boolean isIntegerSample(IProbabilityMassFunction function) {
        boolean isInteger = true;
        for (ISample sample : function.getSamples()) {
            if (sample.getValue() instanceof Integer) continue;
            isInteger = false;
            break;
        }
        return isInteger;
    }

    private Double getDoubleValue(ISample sample) {
        if (sample.getValue() instanceof Number) {
            return ((Number)sample.getValue()).doubleValue();
        }
        return Double.NaN;
    }

    public abstract int compute(int var1, int var2);

    public abstract double compute(double var1, double var3);

    public abstract IProbabilityMassFunction compute(IProbabilityMassFunction var1, double var2) throws DomainNotNumbersException;

    public IProbabilityDensityFunction compute(IProbabilityDensityFunction leftPDF, IProbabilityDensityFunction rightPDF) throws FunctionsInDifferenDomainsException, UnknownPDFTypeException, IncompatibleUnitsException {
        throw new UnsupportedOperationException("StoEx does not support calculation with two PDFs, like multiplying two PDFs. Check whether you actually mean to do this. The left PDF to calculate with is " + leftPDF.toString() + ", the right is " + rightPDF.toString());
    }

    protected abstract Double calculateOperationForValues(Double var1, Double var2);

    public abstract IProbabilityDensityFunction compute(IProbabilityDensityFunction var1, double var2) throws DomainNotNumbersException;
}

