/**
 * Copyright 2007-2009, SDQ, IPD, U Karlsruhe
 */
package de.uka.ipd.sdq.units;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.Enumerator;

/**
 * <!-- begin-user-doc --> A representation of the literals of the enumeration ' <em><b>Unit
 * Names</b></em>', and utility methods for working with them. <!-- end-user-doc -->
 * 
 * @see de.uka.ipd.sdq.units.UnitsPackage#getUnitNames()
 * @model
 * @generated
 */
public enum UnitNames implements Enumerator {
    /**
     * The '<em><b>UNITLESS</b></em>' literal object. <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @see #UNITLESS_VALUE
     * @generated
     * @ordered
     */
    UNITLESS(0, "UNITLESS", ""),

    /**
     * The '<em><b>BYTE</b></em>' literal object. <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @see #BYTE_VALUE
     * @generated
     * @ordered
     */
    BYTE(1, "BYTE", "B"),

    /**
     * The '<em><b>SECOND</b></em>' literal object. <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @see #SECOND_VALUE
     * @generated
     * @ordered
     */
    SECOND(2, "SECOND", "s"),
    /**
     * The '<em><b>METER</b></em>' literal object. <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @see #METER_VALUE
     * @generated
     * @ordered
     */
    METER(3, "METER", "m");

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    public static final String copyright = "Copyright 2007-2017, Palladiosimulator.org";

    /**
     * The '<em><b>UNITLESS</b></em>' literal value. <!-- begin-user-doc -->
     * <p>
     * If the meaning of '<em><b>UNITLESS</b></em>' literal object isn't clear, there really should
     * be more of a description here...
     * </p>
     * <!-- end-user-doc -->
     * 
     * @see #UNITLESS
     * @model literal=""
     * @generated
     * @ordered
     */
    public static final int UNITLESS_VALUE = 0;

    /**
     * The '<em><b>BYTE</b></em>' literal value. <!-- begin-user-doc -->
     * <p>
     * If the meaning of '<em><b>BYTE</b></em>' literal object isn't clear, there really should be
     * more of a description here...
     * </p>
     * <!-- end-user-doc -->
     * 
     * @see #BYTE
     * @model literal="B"
     * @generated
     * @ordered
     */
    public static final int BYTE_VALUE = 1;

    /**
     * The '<em><b>SECOND</b></em>' literal value. <!-- begin-user-doc -->
     * <p>
     * If the meaning of '<em><b>SECOND</b></em>' literal object isn't clear, there really should be
     * more of a description here...
     * </p>
     * <!-- end-user-doc -->
     * 
     * @see #SECOND
     * @model literal="s"
     * @generated
     * @ordered
     */
    public static final int SECOND_VALUE = 2;

    /**
     * The '<em><b>METER</b></em>' literal value. <!-- begin-user-doc -->
     * <p>
     * If the meaning of '<em><b>METER</b></em>' literal object isn't clear, there really should be
     * more of a description here...
     * </p>
     * <!-- end-user-doc -->
     * 
     * @see #METER
     * @model literal="m"
     * @generated
     * @ordered
     */
    public static final int METER_VALUE = 3;

    /**
     * An array of all the '<em><b>Unit Names</b></em>' enumerators. <!-- begin-user-doc --> <!--
     * end-user-doc -->
     * 
     * @generated
     */
    private static final UnitNames[] VALUES_ARRAY = new UnitNames[] {
            UNITLESS,
            BYTE,
            SECOND,
            METER,
    };

    /**
     * A public read-only list of all the '<em><b>Unit Names</b></em>' enumerators. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    public static final List<UnitNames> VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

    /**
     * Returns the '<em><b>Unit Names</b></em>' literal with the specified literal value. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    public static UnitNames get(final String literal) {
        for (final UnitNames result : VALUES_ARRAY) {
            if (result.toString().equals(literal)) {
                return result;
            }
        }
        return null;
    }

    /**
     * Returns the '<em><b>Unit Names</b></em>' literal with the specified name. <!-- begin-user-doc
     * --> <!-- end-user-doc -->
     * 
     * @param name
     *            the name.
     * @return the matching enumerator or <code>null</code>.
     * @generated
     */
    public static UnitNames getByName(final String name) {
        for (final UnitNames result : VALUES_ARRAY) {
            if (result.getName().equals(name)) {
                return result;
            }
        }
        return null;
    }

    /**
     * Returns the '<em><b>Unit Names</b></em>' literal with the specified integer value. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    public static UnitNames get(final int value) {
        switch (value) {
        case UNITLESS_VALUE:
            return UNITLESS;
        case BYTE_VALUE:
            return BYTE;
        case SECOND_VALUE:
            return SECOND;
        case METER_VALUE:
            return METER;
        }
        return null;
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    private final int value;

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    private final String name;

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    private final String literal;

    /**
     * Only this class can construct instances. <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    private UnitNames(final int value, final String name, final String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public int getValue() {
        return this.value;
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public String getName() {
        return this.name;
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public String getLiteral() {
        return this.literal;
    }

    /**
     * Returns the literal value of the enumerator, which is its string representation. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public String toString() {
        return this.literal;
    }

} // UnitNames
