/*
 * generated by Xtext 2.30.0
 */
package org.palladiosimulator.commons.stoex.serializer;

import com.google.inject.Inject;
import de.uka.ipd.sdq.probfunction.BoolSample;
import de.uka.ipd.sdq.probfunction.BoxedPDF;
import de.uka.ipd.sdq.probfunction.ContinuousSample;
import de.uka.ipd.sdq.probfunction.DoubleSample;
import de.uka.ipd.sdq.probfunction.IntSample;
import de.uka.ipd.sdq.probfunction.ProbabilityMassFunction;
import de.uka.ipd.sdq.probfunction.ProbfunctionPackage;
import de.uka.ipd.sdq.probfunction.StringSample;
import de.uka.ipd.sdq.stoex.BoolLiteral;
import de.uka.ipd.sdq.stoex.BooleanOperatorExpression;
import de.uka.ipd.sdq.stoex.CompareExpression;
import de.uka.ipd.sdq.stoex.DoubleLiteral;
import de.uka.ipd.sdq.stoex.FunctionLiteral;
import de.uka.ipd.sdq.stoex.IfElseExpression;
import de.uka.ipd.sdq.stoex.IntLiteral;
import de.uka.ipd.sdq.stoex.NamespaceReference;
import de.uka.ipd.sdq.stoex.NegativeExpression;
import de.uka.ipd.sdq.stoex.NotExpression;
import de.uka.ipd.sdq.stoex.Parenthesis;
import de.uka.ipd.sdq.stoex.PowerExpression;
import de.uka.ipd.sdq.stoex.ProbabilityFunctionLiteral;
import de.uka.ipd.sdq.stoex.ProductExpression;
import de.uka.ipd.sdq.stoex.StoexPackage;
import de.uka.ipd.sdq.stoex.StringLiteral;
import de.uka.ipd.sdq.stoex.TermExpression;
import de.uka.ipd.sdq.stoex.Variable;
import de.uka.ipd.sdq.stoex.VariableReference;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Parameter;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.serializer.ISerializationContext;
import org.eclipse.xtext.serializer.acceptor.SequenceFeeder;
import org.eclipse.xtext.serializer.sequencer.AbstractDelegatingSemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.ITransientValueService.ValueTransient;
import org.palladiosimulator.commons.stoex.services.StoexGrammarAccess;

@SuppressWarnings("all")
public class StoexSemanticSequencer extends AbstractDelegatingSemanticSequencer {

	@Inject
	private StoexGrammarAccess grammarAccess;
	
	@Override
	public void sequence(ISerializationContext context, EObject semanticObject) {
		EPackage epackage = semanticObject.eClass().getEPackage();
		ParserRule rule = context.getParserRule();
		Action action = context.getAssignedAction();
		Set<Parameter> parameters = context.getEnabledBooleanParameters();
		if (epackage == ProbfunctionPackage.eINSTANCE)
			switch (semanticObject.eClass().getClassifierID()) {
			case ProbfunctionPackage.BOOL_SAMPLE:
				sequence_boolsample(context, (BoolSample) semanticObject); 
				return; 
			case ProbfunctionPackage.BOXED_PDF:
				sequence_BoxedPDF(context, (BoxedPDF) semanticObject); 
				return; 
			case ProbfunctionPackage.CONTINUOUS_SAMPLE:
				sequence_real_pdf_sample(context, (ContinuousSample) semanticObject); 
				return; 
			case ProbfunctionPackage.DOUBLE_SAMPLE:
				sequence_numeric_real_sample(context, (DoubleSample) semanticObject); 
				return; 
			case ProbfunctionPackage.INT_SAMPLE:
				sequence_numeric_int_sample(context, (IntSample) semanticObject); 
				return; 
			case ProbfunctionPackage.PROBABILITY_MASS_FUNCTION:
				sequence_ProbabilityMassFunction(context, (ProbabilityMassFunction) semanticObject); 
				return; 
			case ProbfunctionPackage.STRING_SAMPLE:
				sequence_stringsample(context, (StringSample) semanticObject); 
				return; 
			}
		else if (epackage == StoexPackage.eINSTANCE)
			switch (semanticObject.eClass().getClassifierID()) {
			case StoexPackage.BOOL_LITERAL:
				sequence_BoolLiteral(context, (BoolLiteral) semanticObject); 
				return; 
			case StoexPackage.BOOLEAN_OPERATOR_EXPRESSION:
				if (rule == grammarAccess.getBooleanExpressionRule()
						|| action == grammarAccess.getBooleanExpressionAccess().getBooleanOperatorExpressionLeftAction_1_0()) {
					sequence_BooleanExpression_boolOrExpr(context, (BooleanOperatorExpression) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getExpressionRule()
						|| rule == grammarAccess.getIfelseExprRule()
						|| action == grammarAccess.getIfelseExprAccess().getIfElseExpressionConditionExpressionAction_1_0()
						|| rule == grammarAccess.getBoolAndExprRule()
						|| action == grammarAccess.getBoolAndExprAccess().getBooleanOperatorExpressionLeftAction_1_0()) {
					sequence_boolAndExpr_boolOrExpr(context, (BooleanOperatorExpression) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getBoolOrExprRule()
						|| action == grammarAccess.getBoolOrExprAccess().getBooleanOperatorExpressionLeftAction_1_0()) {
					sequence_boolOrExpr(context, (BooleanOperatorExpression) semanticObject); 
					return; 
				}
				else break;
			case StoexPackage.COMPARE_EXPRESSION:
				sequence_compareExpr(context, (CompareExpression) semanticObject); 
				return; 
			case StoexPackage.DOUBLE_LITERAL:
				sequence_DoubleLiteral(context, (DoubleLiteral) semanticObject); 
				return; 
			case StoexPackage.FUNCTION_LITERAL:
				sequence_FunctionLiteral(context, (FunctionLiteral) semanticObject); 
				return; 
			case StoexPackage.IF_ELSE_EXPRESSION:
				sequence_ifelseExpr(context, (IfElseExpression) semanticObject); 
				return; 
			case StoexPackage.INT_LITERAL:
				sequence_IntLiteral(context, (IntLiteral) semanticObject); 
				return; 
			case StoexPackage.NAMESPACE_REFERENCE:
				sequence_NamespaceReference(context, (NamespaceReference) semanticObject); 
				return; 
			case StoexPackage.NEGATIVE_EXPRESSION:
				sequence_NegativeExpression(context, (NegativeExpression) semanticObject); 
				return; 
			case StoexPackage.NOT_EXPRESSION:
				sequence_NotExpression(context, (NotExpression) semanticObject); 
				return; 
			case StoexPackage.PARENTHESIS:
				sequence_Parenthesis(context, (Parenthesis) semanticObject); 
				return; 
			case StoexPackage.POWER_EXPRESSION:
				sequence_powExpr(context, (PowerExpression) semanticObject); 
				return; 
			case StoexPackage.PROBABILITY_FUNCTION_LITERAL:
				sequence_ProbabilityFunctionLiteral(context, (ProbabilityFunctionLiteral) semanticObject); 
				return; 
			case StoexPackage.PRODUCT_EXPRESSION:
				sequence_prodExpr(context, (ProductExpression) semanticObject); 
				return; 
			case StoexPackage.STRING_LITERAL:
				sequence_StringLiteral(context, (StringLiteral) semanticObject); 
				return; 
			case StoexPackage.TERM_EXPRESSION:
				sequence_sumExpr(context, (TermExpression) semanticObject); 
				return; 
			case StoexPackage.VARIABLE:
				sequence_Variable(context, (Variable) semanticObject); 
				return; 
			case StoexPackage.VARIABLE_REFERENCE:
				sequence_VariableReference(context, (VariableReference) semanticObject); 
				return; 
			}
		if (errorAcceptor != null)
			errorAcceptor.accept(diagnosticProvider.createInvalidContextOrTypeDiagnostic(semanticObject, context));
	}
	
	/**
	 * <pre>
	 * Contexts:
	 *     expression returns BoolLiteral
	 *     ifelseExpr returns BoolLiteral
	 *     ifelseExpr.IfElseExpression_1_0 returns BoolLiteral
	 *     BooleanExpression returns BoolLiteral
	 *     BooleanExpression.BooleanOperatorExpression_1_0 returns BoolLiteral
	 *     boolAndExpr returns BoolLiteral
	 *     boolAndExpr.BooleanOperatorExpression_1_0 returns BoolLiteral
	 *     boolOrExpr returns BoolLiteral
	 *     boolOrExpr.BooleanOperatorExpression_1_0 returns BoolLiteral
	 *     compareExpr returns BoolLiteral
	 *     compareExpr.CompareExpression_1_0 returns BoolLiteral
	 *     sumExpr returns BoolLiteral
	 *     sumExpr.TermExpression_1_0 returns BoolLiteral
	 *     prodExpr returns BoolLiteral
	 *     prodExpr.ProductExpression_1_0 returns BoolLiteral
	 *     powExpr returns BoolLiteral
	 *     powExpr.PowerExpression_1_0 returns BoolLiteral
	 *     unaryExpr returns BoolLiteral
	 *     atom returns BoolLiteral
	 *     BoolLiteral returns BoolLiteral
	 *
	 * Constraint:
	 *     value=BOOLEAN_KEYWORDS
	 * </pre>
	 */
	protected void sequence_BoolLiteral(ISerializationContext context, BoolLiteral semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient((EObject) semanticObject, StoexPackage.Literals.BOOL_LITERAL__VALUE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing((EObject) semanticObject, StoexPackage.Literals.BOOL_LITERAL__VALUE));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, (EObject) semanticObject);
		feeder.accept(grammarAccess.getBoolLiteralAccess().getValueBOOLEAN_KEYWORDSTerminalRuleCall_0(), semanticObject.isValue());
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     BooleanExpression returns BooleanOperatorExpression
	 *     BooleanExpression.BooleanOperatorExpression_1_0 returns BooleanOperatorExpression
	 *
	 * Constraint:
	 *     (
	 *         (left=BooleanExpression_BooleanOperatorExpression_1_0 operation=BooleanOperations right=boolOrExpr) | 
	 *         (left=boolOrExpr_BooleanOperatorExpression_1_0 operation=oroperations right=compareExpr)
	 *     )
	 * </pre>
	 */
	protected void sequence_BooleanExpression_boolOrExpr(ISerializationContext context, BooleanOperatorExpression semanticObject) {
		genericSequencer.createSequence(context, (EObject) semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     definition returns BoxedPDF
	 *     ProbabilityDensityFunction returns BoxedPDF
	 *     BoxedPDF returns BoxedPDF
	 *
	 * Constraint:
	 *     samples+=real_pdf_sample+
	 * </pre>
	 */
	protected void sequence_BoxedPDF(ISerializationContext context, BoxedPDF semanticObject) {
		genericSequencer.createSequence(context, (EObject) semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     expression returns DoubleLiteral
	 *     ifelseExpr returns DoubleLiteral
	 *     ifelseExpr.IfElseExpression_1_0 returns DoubleLiteral
	 *     BooleanExpression returns DoubleLiteral
	 *     BooleanExpression.BooleanOperatorExpression_1_0 returns DoubleLiteral
	 *     boolAndExpr returns DoubleLiteral
	 *     boolAndExpr.BooleanOperatorExpression_1_0 returns DoubleLiteral
	 *     boolOrExpr returns DoubleLiteral
	 *     boolOrExpr.BooleanOperatorExpression_1_0 returns DoubleLiteral
	 *     compareExpr returns DoubleLiteral
	 *     compareExpr.CompareExpression_1_0 returns DoubleLiteral
	 *     sumExpr returns DoubleLiteral
	 *     sumExpr.TermExpression_1_0 returns DoubleLiteral
	 *     prodExpr returns DoubleLiteral
	 *     prodExpr.ProductExpression_1_0 returns DoubleLiteral
	 *     powExpr returns DoubleLiteral
	 *     powExpr.PowerExpression_1_0 returns DoubleLiteral
	 *     unaryExpr returns DoubleLiteral
	 *     atom returns DoubleLiteral
	 *     DoubleLiteral returns DoubleLiteral
	 *
	 * Constraint:
	 *     value=DOUBLE
	 * </pre>
	 */
	protected void sequence_DoubleLiteral(ISerializationContext context, DoubleLiteral semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient((EObject) semanticObject, StoexPackage.Literals.DOUBLE_LITERAL__VALUE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing((EObject) semanticObject, StoexPackage.Literals.DOUBLE_LITERAL__VALUE));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, (EObject) semanticObject);
		feeder.accept(grammarAccess.getDoubleLiteralAccess().getValueDOUBLETerminalRuleCall_0(), semanticObject.getValue());
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     expression returns FunctionLiteral
	 *     ifelseExpr returns FunctionLiteral
	 *     ifelseExpr.IfElseExpression_1_0 returns FunctionLiteral
	 *     BooleanExpression returns FunctionLiteral
	 *     BooleanExpression.BooleanOperatorExpression_1_0 returns FunctionLiteral
	 *     boolAndExpr returns FunctionLiteral
	 *     boolAndExpr.BooleanOperatorExpression_1_0 returns FunctionLiteral
	 *     boolOrExpr returns FunctionLiteral
	 *     boolOrExpr.BooleanOperatorExpression_1_0 returns FunctionLiteral
	 *     compareExpr returns FunctionLiteral
	 *     compareExpr.CompareExpression_1_0 returns FunctionLiteral
	 *     sumExpr returns FunctionLiteral
	 *     sumExpr.TermExpression_1_0 returns FunctionLiteral
	 *     prodExpr returns FunctionLiteral
	 *     prodExpr.ProductExpression_1_0 returns FunctionLiteral
	 *     powExpr returns FunctionLiteral
	 *     powExpr.PowerExpression_1_0 returns FunctionLiteral
	 *     unaryExpr returns FunctionLiteral
	 *     atom returns FunctionLiteral
	 *     FunctionLiteral returns FunctionLiteral
	 *
	 * Constraint:
	 *     (id=ID (parameters_FunctionLiteral+=boolAndExpr parameters_FunctionLiteral+=boolAndExpr*)?)
	 * </pre>
	 */
	protected void sequence_FunctionLiteral(ISerializationContext context, FunctionLiteral semanticObject) {
		genericSequencer.createSequence(context, (EObject) semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     expression returns IntLiteral
	 *     ifelseExpr returns IntLiteral
	 *     ifelseExpr.IfElseExpression_1_0 returns IntLiteral
	 *     BooleanExpression returns IntLiteral
	 *     BooleanExpression.BooleanOperatorExpression_1_0 returns IntLiteral
	 *     boolAndExpr returns IntLiteral
	 *     boolAndExpr.BooleanOperatorExpression_1_0 returns IntLiteral
	 *     boolOrExpr returns IntLiteral
	 *     boolOrExpr.BooleanOperatorExpression_1_0 returns IntLiteral
	 *     compareExpr returns IntLiteral
	 *     compareExpr.CompareExpression_1_0 returns IntLiteral
	 *     sumExpr returns IntLiteral
	 *     sumExpr.TermExpression_1_0 returns IntLiteral
	 *     prodExpr returns IntLiteral
	 *     prodExpr.ProductExpression_1_0 returns IntLiteral
	 *     powExpr returns IntLiteral
	 *     powExpr.PowerExpression_1_0 returns IntLiteral
	 *     unaryExpr returns IntLiteral
	 *     atom returns IntLiteral
	 *     IntLiteral returns IntLiteral
	 *
	 * Constraint:
	 *     value=DECINT
	 * </pre>
	 */
	protected void sequence_IntLiteral(ISerializationContext context, IntLiteral semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient((EObject) semanticObject, StoexPackage.Literals.INT_LITERAL__VALUE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing((EObject) semanticObject, StoexPackage.Literals.INT_LITERAL__VALUE));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, (EObject) semanticObject);
		feeder.accept(grammarAccess.getIntLiteralAccess().getValueDECINTTerminalRuleCall_0(), semanticObject.getValue());
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     AbstractNamedReference returns NamespaceReference
	 *     NamespaceReference returns NamespaceReference
	 *
	 * Constraint:
	 *     (referenceName=ID innerReference_NamespaceReference=AbstractNamedReference)
	 * </pre>
	 */
	protected void sequence_NamespaceReference(ISerializationContext context, NamespaceReference semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient((EObject) semanticObject, StoexPackage.Literals.ABSTRACT_NAMED_REFERENCE__REFERENCE_NAME) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing((EObject) semanticObject, StoexPackage.Literals.ABSTRACT_NAMED_REFERENCE__REFERENCE_NAME));
			if (transientValues.isValueTransient((EObject) semanticObject, StoexPackage.Literals.NAMESPACE_REFERENCE__INNER_REFERENCE_NAMESPACE_REFERENCE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing((EObject) semanticObject, StoexPackage.Literals.NAMESPACE_REFERENCE__INNER_REFERENCE_NAMESPACE_REFERENCE));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, (EObject) semanticObject);
		feeder.accept(grammarAccess.getNamespaceReferenceAccess().getReferenceNameIDTerminalRuleCall_1_0(), semanticObject.getReferenceName());
		feeder.accept(grammarAccess.getNamespaceReferenceAccess().getInnerReference_NamespaceReferenceAbstractNamedReferenceParserRuleCall_3_0(), semanticObject.getInnerReference_NamespaceReference());
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     expression returns NegativeExpression
	 *     ifelseExpr returns NegativeExpression
	 *     ifelseExpr.IfElseExpression_1_0 returns NegativeExpression
	 *     BooleanExpression returns NegativeExpression
	 *     BooleanExpression.BooleanOperatorExpression_1_0 returns NegativeExpression
	 *     boolAndExpr returns NegativeExpression
	 *     boolAndExpr.BooleanOperatorExpression_1_0 returns NegativeExpression
	 *     boolOrExpr returns NegativeExpression
	 *     boolOrExpr.BooleanOperatorExpression_1_0 returns NegativeExpression
	 *     compareExpr returns NegativeExpression
	 *     compareExpr.CompareExpression_1_0 returns NegativeExpression
	 *     sumExpr returns NegativeExpression
	 *     sumExpr.TermExpression_1_0 returns NegativeExpression
	 *     prodExpr returns NegativeExpression
	 *     prodExpr.ProductExpression_1_0 returns NegativeExpression
	 *     powExpr returns NegativeExpression
	 *     powExpr.PowerExpression_1_0 returns NegativeExpression
	 *     unaryExpr returns NegativeExpression
	 *     NegativeExpression returns NegativeExpression
	 *
	 * Constraint:
	 *     inner=unaryExpr
	 * </pre>
	 */
	protected void sequence_NegativeExpression(ISerializationContext context, NegativeExpression semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient((EObject) semanticObject, StoexPackage.Literals.NEGATIVE_EXPRESSION__INNER) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing((EObject) semanticObject, StoexPackage.Literals.NEGATIVE_EXPRESSION__INNER));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, (EObject) semanticObject);
		feeder.accept(grammarAccess.getNegativeExpressionAccess().getInnerUnaryExprParserRuleCall_1_0(), semanticObject.getInner());
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     expression returns NotExpression
	 *     ifelseExpr returns NotExpression
	 *     ifelseExpr.IfElseExpression_1_0 returns NotExpression
	 *     BooleanExpression returns NotExpression
	 *     BooleanExpression.BooleanOperatorExpression_1_0 returns NotExpression
	 *     boolAndExpr returns NotExpression
	 *     boolAndExpr.BooleanOperatorExpression_1_0 returns NotExpression
	 *     boolOrExpr returns NotExpression
	 *     boolOrExpr.BooleanOperatorExpression_1_0 returns NotExpression
	 *     compareExpr returns NotExpression
	 *     compareExpr.CompareExpression_1_0 returns NotExpression
	 *     sumExpr returns NotExpression
	 *     sumExpr.TermExpression_1_0 returns NotExpression
	 *     prodExpr returns NotExpression
	 *     prodExpr.ProductExpression_1_0 returns NotExpression
	 *     powExpr returns NotExpression
	 *     powExpr.PowerExpression_1_0 returns NotExpression
	 *     unaryExpr returns NotExpression
	 *     NotExpression returns NotExpression
	 *
	 * Constraint:
	 *     inner=unaryExpr
	 * </pre>
	 */
	protected void sequence_NotExpression(ISerializationContext context, NotExpression semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient((EObject) semanticObject, StoexPackage.Literals.NOT_EXPRESSION__INNER) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing((EObject) semanticObject, StoexPackage.Literals.NOT_EXPRESSION__INNER));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, (EObject) semanticObject);
		feeder.accept(grammarAccess.getNotExpressionAccess().getInnerUnaryExprParserRuleCall_1_0(), semanticObject.getInner());
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     expression returns Parenthesis
	 *     ifelseExpr returns Parenthesis
	 *     ifelseExpr.IfElseExpression_1_0 returns Parenthesis
	 *     BooleanExpression returns Parenthesis
	 *     BooleanExpression.BooleanOperatorExpression_1_0 returns Parenthesis
	 *     boolAndExpr returns Parenthesis
	 *     boolAndExpr.BooleanOperatorExpression_1_0 returns Parenthesis
	 *     boolOrExpr returns Parenthesis
	 *     boolOrExpr.BooleanOperatorExpression_1_0 returns Parenthesis
	 *     compareExpr returns Parenthesis
	 *     compareExpr.CompareExpression_1_0 returns Parenthesis
	 *     sumExpr returns Parenthesis
	 *     sumExpr.TermExpression_1_0 returns Parenthesis
	 *     prodExpr returns Parenthesis
	 *     prodExpr.ProductExpression_1_0 returns Parenthesis
	 *     powExpr returns Parenthesis
	 *     powExpr.PowerExpression_1_0 returns Parenthesis
	 *     unaryExpr returns Parenthesis
	 *     atom returns Parenthesis
	 *     Parenthesis returns Parenthesis
	 *
	 * Constraint:
	 *     innerExpression=ifelseExpr
	 * </pre>
	 */
	protected void sequence_Parenthesis(ISerializationContext context, Parenthesis semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient((EObject) semanticObject, StoexPackage.Literals.PARENTHESIS__INNER_EXPRESSION) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing((EObject) semanticObject, StoexPackage.Literals.PARENTHESIS__INNER_EXPRESSION));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, (EObject) semanticObject);
		feeder.accept(grammarAccess.getParenthesisAccess().getInnerExpressionIfelseExprParserRuleCall_1_0(), semanticObject.getInnerExpression());
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     expression returns ProbabilityFunctionLiteral
	 *     ifelseExpr returns ProbabilityFunctionLiteral
	 *     ifelseExpr.IfElseExpression_1_0 returns ProbabilityFunctionLiteral
	 *     BooleanExpression returns ProbabilityFunctionLiteral
	 *     BooleanExpression.BooleanOperatorExpression_1_0 returns ProbabilityFunctionLiteral
	 *     boolAndExpr returns ProbabilityFunctionLiteral
	 *     boolAndExpr.BooleanOperatorExpression_1_0 returns ProbabilityFunctionLiteral
	 *     boolOrExpr returns ProbabilityFunctionLiteral
	 *     boolOrExpr.BooleanOperatorExpression_1_0 returns ProbabilityFunctionLiteral
	 *     compareExpr returns ProbabilityFunctionLiteral
	 *     compareExpr.CompareExpression_1_0 returns ProbabilityFunctionLiteral
	 *     sumExpr returns ProbabilityFunctionLiteral
	 *     sumExpr.TermExpression_1_0 returns ProbabilityFunctionLiteral
	 *     prodExpr returns ProbabilityFunctionLiteral
	 *     prodExpr.ProductExpression_1_0 returns ProbabilityFunctionLiteral
	 *     powExpr returns ProbabilityFunctionLiteral
	 *     powExpr.PowerExpression_1_0 returns ProbabilityFunctionLiteral
	 *     unaryExpr returns ProbabilityFunctionLiteral
	 *     atom returns ProbabilityFunctionLiteral
	 *     ProbabilityFunctionLiteral returns ProbabilityFunctionLiteral
	 *
	 * Constraint:
	 *     function_ProbabilityFunctionLiteral=definition
	 * </pre>
	 */
	protected void sequence_ProbabilityFunctionLiteral(ISerializationContext context, ProbabilityFunctionLiteral semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient((EObject) semanticObject, StoexPackage.Literals.PROBABILITY_FUNCTION_LITERAL__FUNCTION_PROBABILITY_FUNCTION_LITERAL) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing((EObject) semanticObject, StoexPackage.Literals.PROBABILITY_FUNCTION_LITERAL__FUNCTION_PROBABILITY_FUNCTION_LITERAL));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, (EObject) semanticObject);
		feeder.accept(grammarAccess.getProbabilityFunctionLiteralAccess().getFunction_ProbabilityFunctionLiteralDefinitionParserRuleCall_0(), semanticObject.getFunction_ProbabilityFunctionLiteral());
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     definition returns ProbabilityMassFunction
	 *     ProbabilityMassFunction returns ProbabilityMassFunction
	 *
	 * Constraint:
	 *     (
	 *         samples+=numeric_int_sample+ | 
	 *         samples+=numeric_real_sample+ | 
	 *         (orderedDomain?='ordered'? samples+=stringsample+) | 
	 *         (orderedDomain?='ordered'? samples+=boolsample+)
	 *     )
	 * </pre>
	 */
	protected void sequence_ProbabilityMassFunction(ISerializationContext context, ProbabilityMassFunction semanticObject) {
		genericSequencer.createSequence(context, (EObject) semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     expression returns StringLiteral
	 *     ifelseExpr returns StringLiteral
	 *     ifelseExpr.IfElseExpression_1_0 returns StringLiteral
	 *     BooleanExpression returns StringLiteral
	 *     BooleanExpression.BooleanOperatorExpression_1_0 returns StringLiteral
	 *     boolAndExpr returns StringLiteral
	 *     boolAndExpr.BooleanOperatorExpression_1_0 returns StringLiteral
	 *     boolOrExpr returns StringLiteral
	 *     boolOrExpr.BooleanOperatorExpression_1_0 returns StringLiteral
	 *     compareExpr returns StringLiteral
	 *     compareExpr.CompareExpression_1_0 returns StringLiteral
	 *     sumExpr returns StringLiteral
	 *     sumExpr.TermExpression_1_0 returns StringLiteral
	 *     prodExpr returns StringLiteral
	 *     prodExpr.ProductExpression_1_0 returns StringLiteral
	 *     powExpr returns StringLiteral
	 *     powExpr.PowerExpression_1_0 returns StringLiteral
	 *     unaryExpr returns StringLiteral
	 *     atom returns StringLiteral
	 *     StringLiteral returns StringLiteral
	 *
	 * Constraint:
	 *     value=STRING
	 * </pre>
	 */
	protected void sequence_StringLiteral(ISerializationContext context, StringLiteral semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient((EObject) semanticObject, StoexPackage.Literals.STRING_LITERAL__VALUE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing((EObject) semanticObject, StoexPackage.Literals.STRING_LITERAL__VALUE));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, (EObject) semanticObject);
		feeder.accept(grammarAccess.getStringLiteralAccess().getValueSTRINGTerminalRuleCall_0(), semanticObject.getValue());
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     AbstractNamedReference returns VariableReference
	 *     VariableReference returns VariableReference
	 *
	 * Constraint:
	 *     referenceName=ID
	 * </pre>
	 */
	protected void sequence_VariableReference(ISerializationContext context, VariableReference semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient((EObject) semanticObject, StoexPackage.Literals.ABSTRACT_NAMED_REFERENCE__REFERENCE_NAME) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing((EObject) semanticObject, StoexPackage.Literals.ABSTRACT_NAMED_REFERENCE__REFERENCE_NAME));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, (EObject) semanticObject);
		feeder.accept(grammarAccess.getVariableReferenceAccess().getReferenceNameIDTerminalRuleCall_1_0(), semanticObject.getReferenceName());
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     expression returns Variable
	 *     ifelseExpr returns Variable
	 *     ifelseExpr.IfElseExpression_1_0 returns Variable
	 *     BooleanExpression returns Variable
	 *     BooleanExpression.BooleanOperatorExpression_1_0 returns Variable
	 *     boolAndExpr returns Variable
	 *     boolAndExpr.BooleanOperatorExpression_1_0 returns Variable
	 *     boolOrExpr returns Variable
	 *     boolOrExpr.BooleanOperatorExpression_1_0 returns Variable
	 *     compareExpr returns Variable
	 *     compareExpr.CompareExpression_1_0 returns Variable
	 *     sumExpr returns Variable
	 *     sumExpr.TermExpression_1_0 returns Variable
	 *     prodExpr returns Variable
	 *     prodExpr.ProductExpression_1_0 returns Variable
	 *     powExpr returns Variable
	 *     powExpr.PowerExpression_1_0 returns Variable
	 *     unaryExpr returns Variable
	 *     atom returns Variable
	 *     Variable returns Variable
	 *
	 * Constraint:
	 *     id_Variable=AbstractNamedReference
	 * </pre>
	 */
	protected void sequence_Variable(ISerializationContext context, Variable semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient((EObject) semanticObject, StoexPackage.Literals.VARIABLE__ID_VARIABLE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing((EObject) semanticObject, StoexPackage.Literals.VARIABLE__ID_VARIABLE));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, (EObject) semanticObject);
		feeder.accept(grammarAccess.getVariableAccess().getId_VariableAbstractNamedReferenceParserRuleCall_0(), semanticObject.getId_Variable());
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     expression returns BooleanOperatorExpression
	 *     ifelseExpr returns BooleanOperatorExpression
	 *     ifelseExpr.IfElseExpression_1_0 returns BooleanOperatorExpression
	 *     boolAndExpr returns BooleanOperatorExpression
	 *     boolAndExpr.BooleanOperatorExpression_1_0 returns BooleanOperatorExpression
	 *
	 * Constraint:
	 *     (
	 *         (left=boolAndExpr_BooleanOperatorExpression_1_0 operation=andoperation right=boolOrExpr) | 
	 *         (left=boolOrExpr_BooleanOperatorExpression_1_0 operation=oroperations right=compareExpr)
	 *     )
	 * </pre>
	 */
	protected void sequence_boolAndExpr_boolOrExpr(ISerializationContext context, BooleanOperatorExpression semanticObject) {
		genericSequencer.createSequence(context, (EObject) semanticObject);
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     boolOrExpr returns BooleanOperatorExpression
	 *     boolOrExpr.BooleanOperatorExpression_1_0 returns BooleanOperatorExpression
	 *
	 * Constraint:
	 *     (left=boolOrExpr_BooleanOperatorExpression_1_0 operation=oroperations right=compareExpr)
	 * </pre>
	 */
	protected void sequence_boolOrExpr(ISerializationContext context, BooleanOperatorExpression semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient((EObject) semanticObject, StoexPackage.Literals.BOOLEAN_OPERATOR_EXPRESSION__LEFT) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing((EObject) semanticObject, StoexPackage.Literals.BOOLEAN_OPERATOR_EXPRESSION__LEFT));
			if (transientValues.isValueTransient((EObject) semanticObject, StoexPackage.Literals.BOOLEAN_OPERATOR_EXPRESSION__OPERATION) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing((EObject) semanticObject, StoexPackage.Literals.BOOLEAN_OPERATOR_EXPRESSION__OPERATION));
			if (transientValues.isValueTransient((EObject) semanticObject, StoexPackage.Literals.BOOLEAN_OPERATOR_EXPRESSION__RIGHT) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing((EObject) semanticObject, StoexPackage.Literals.BOOLEAN_OPERATOR_EXPRESSION__RIGHT));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, (EObject) semanticObject);
		feeder.accept(grammarAccess.getBoolOrExprAccess().getBooleanOperatorExpressionLeftAction_1_0(), semanticObject.getLeft());
		feeder.accept(grammarAccess.getBoolOrExprAccess().getOperationOroperationsEnumRuleCall_1_1_0(), semanticObject.getOperation());
		feeder.accept(grammarAccess.getBoolOrExprAccess().getRightCompareExprParserRuleCall_1_2_0(), semanticObject.getRight());
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     boolsample returns BoolSample
	 *
	 * Constraint:
	 *     (value=BOOLEAN_KEYWORDS probability=NUMBER)
	 * </pre>
	 */
	protected void sequence_boolsample(ISerializationContext context, BoolSample semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient((EObject) semanticObject, ProbfunctionPackage.Literals.SAMPLE__VALUE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing((EObject) semanticObject, ProbfunctionPackage.Literals.SAMPLE__VALUE));
			if (transientValues.isValueTransient((EObject) semanticObject, ProbfunctionPackage.Literals.SAMPLE__PROBABILITY) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing((EObject) semanticObject, ProbfunctionPackage.Literals.SAMPLE__PROBABILITY));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, (EObject) semanticObject);
		feeder.accept(grammarAccess.getBoolsampleAccess().getValueBOOLEAN_KEYWORDSTerminalRuleCall_1_0(), semanticObject.getValue());
		feeder.accept(grammarAccess.getBoolsampleAccess().getProbabilityNUMBERParserRuleCall_3_0(), semanticObject.getProbability());
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     expression returns CompareExpression
	 *     ifelseExpr returns CompareExpression
	 *     ifelseExpr.IfElseExpression_1_0 returns CompareExpression
	 *     BooleanExpression returns CompareExpression
	 *     BooleanExpression.BooleanOperatorExpression_1_0 returns CompareExpression
	 *     boolAndExpr returns CompareExpression
	 *     boolAndExpr.BooleanOperatorExpression_1_0 returns CompareExpression
	 *     boolOrExpr returns CompareExpression
	 *     boolOrExpr.BooleanOperatorExpression_1_0 returns CompareExpression
	 *     compareExpr returns CompareExpression
	 *
	 * Constraint:
	 *     (left=compareExpr_CompareExpression_1_0 operation=CompareOperations right=sumExpr)
	 * </pre>
	 */
	protected void sequence_compareExpr(ISerializationContext context, CompareExpression semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient((EObject) semanticObject, StoexPackage.Literals.COMPARE_EXPRESSION__LEFT) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing((EObject) semanticObject, StoexPackage.Literals.COMPARE_EXPRESSION__LEFT));
			if (transientValues.isValueTransient((EObject) semanticObject, StoexPackage.Literals.COMPARE_EXPRESSION__OPERATION) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing((EObject) semanticObject, StoexPackage.Literals.COMPARE_EXPRESSION__OPERATION));
			if (transientValues.isValueTransient((EObject) semanticObject, StoexPackage.Literals.COMPARE_EXPRESSION__RIGHT) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing((EObject) semanticObject, StoexPackage.Literals.COMPARE_EXPRESSION__RIGHT));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, (EObject) semanticObject);
		feeder.accept(grammarAccess.getCompareExprAccess().getCompareExpressionLeftAction_1_0(), semanticObject.getLeft());
		feeder.accept(grammarAccess.getCompareExprAccess().getOperationCompareOperationsEnumRuleCall_1_1_0(), semanticObject.getOperation());
		feeder.accept(grammarAccess.getCompareExprAccess().getRightSumExprParserRuleCall_1_2_0(), semanticObject.getRight());
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     expression returns IfElseExpression
	 *     ifelseExpr returns IfElseExpression
	 *
	 * Constraint:
	 *     (conditionExpression=ifelseExpr_IfElseExpression_1_0 ifExpression=boolAndExpr elseExpression=boolAndExpr)
	 * </pre>
	 */
	protected void sequence_ifelseExpr(ISerializationContext context, IfElseExpression semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient((EObject) semanticObject, StoexPackage.Literals.IF_ELSE_EXPRESSION__CONDITION_EXPRESSION) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing((EObject) semanticObject, StoexPackage.Literals.IF_ELSE_EXPRESSION__CONDITION_EXPRESSION));
			if (transientValues.isValueTransient((EObject) semanticObject, StoexPackage.Literals.IF_ELSE_EXPRESSION__IF_EXPRESSION) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing((EObject) semanticObject, StoexPackage.Literals.IF_ELSE_EXPRESSION__IF_EXPRESSION));
			if (transientValues.isValueTransient((EObject) semanticObject, StoexPackage.Literals.IF_ELSE_EXPRESSION__ELSE_EXPRESSION) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing((EObject) semanticObject, StoexPackage.Literals.IF_ELSE_EXPRESSION__ELSE_EXPRESSION));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, (EObject) semanticObject);
		feeder.accept(grammarAccess.getIfelseExprAccess().getIfElseExpressionConditionExpressionAction_1_0(), semanticObject.getConditionExpression());
		feeder.accept(grammarAccess.getIfelseExprAccess().getIfExpressionBoolAndExprParserRuleCall_1_2_0(), semanticObject.getIfExpression());
		feeder.accept(grammarAccess.getIfelseExprAccess().getElseExpressionBoolAndExprParserRuleCall_1_4_0(), semanticObject.getElseExpression());
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     numeric_int_sample returns IntSample
	 *
	 * Constraint:
	 *     (value=SIGNED_INT probability=NUMBER)
	 * </pre>
	 */
	protected void sequence_numeric_int_sample(ISerializationContext context, IntSample semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient((EObject) semanticObject, ProbfunctionPackage.Literals.SAMPLE__VALUE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing((EObject) semanticObject, ProbfunctionPackage.Literals.SAMPLE__VALUE));
			if (transientValues.isValueTransient((EObject) semanticObject, ProbfunctionPackage.Literals.SAMPLE__PROBABILITY) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing((EObject) semanticObject, ProbfunctionPackage.Literals.SAMPLE__PROBABILITY));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, (EObject) semanticObject);
		feeder.accept(grammarAccess.getNumeric_int_sampleAccess().getValueSIGNED_INTParserRuleCall_1_0(), semanticObject.getValue());
		feeder.accept(grammarAccess.getNumeric_int_sampleAccess().getProbabilityNUMBERParserRuleCall_3_0(), semanticObject.getProbability());
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     numeric_real_sample returns DoubleSample
	 *
	 * Constraint:
	 *     (value=SIGNED_NUMBER probability=NUMBER)
	 * </pre>
	 */
	protected void sequence_numeric_real_sample(ISerializationContext context, DoubleSample semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient((EObject) semanticObject, ProbfunctionPackage.Literals.SAMPLE__VALUE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing((EObject) semanticObject, ProbfunctionPackage.Literals.SAMPLE__VALUE));
			if (transientValues.isValueTransient((EObject) semanticObject, ProbfunctionPackage.Literals.SAMPLE__PROBABILITY) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing((EObject) semanticObject, ProbfunctionPackage.Literals.SAMPLE__PROBABILITY));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, (EObject) semanticObject);
		feeder.accept(grammarAccess.getNumeric_real_sampleAccess().getValueSIGNED_NUMBERParserRuleCall_1_0(), semanticObject.getValue());
		feeder.accept(grammarAccess.getNumeric_real_sampleAccess().getProbabilityNUMBERParserRuleCall_3_0(), semanticObject.getProbability());
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     expression returns PowerExpression
	 *     ifelseExpr returns PowerExpression
	 *     ifelseExpr.IfElseExpression_1_0 returns PowerExpression
	 *     BooleanExpression returns PowerExpression
	 *     BooleanExpression.BooleanOperatorExpression_1_0 returns PowerExpression
	 *     boolAndExpr returns PowerExpression
	 *     boolAndExpr.BooleanOperatorExpression_1_0 returns PowerExpression
	 *     boolOrExpr returns PowerExpression
	 *     boolOrExpr.BooleanOperatorExpression_1_0 returns PowerExpression
	 *     compareExpr returns PowerExpression
	 *     compareExpr.CompareExpression_1_0 returns PowerExpression
	 *     sumExpr returns PowerExpression
	 *     sumExpr.TermExpression_1_0 returns PowerExpression
	 *     prodExpr returns PowerExpression
	 *     prodExpr.ProductExpression_1_0 returns PowerExpression
	 *     powExpr returns PowerExpression
	 *
	 * Constraint:
	 *     (base=powExpr_PowerExpression_1_0 exponent=unaryExpr)
	 * </pre>
	 */
	protected void sequence_powExpr(ISerializationContext context, PowerExpression semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient((EObject) semanticObject, StoexPackage.Literals.POWER_EXPRESSION__BASE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing((EObject) semanticObject, StoexPackage.Literals.POWER_EXPRESSION__BASE));
			if (transientValues.isValueTransient((EObject) semanticObject, StoexPackage.Literals.POWER_EXPRESSION__EXPONENT) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing((EObject) semanticObject, StoexPackage.Literals.POWER_EXPRESSION__EXPONENT));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, (EObject) semanticObject);
		feeder.accept(grammarAccess.getPowExprAccess().getPowerExpressionBaseAction_1_0(), semanticObject.getBase());
		feeder.accept(grammarAccess.getPowExprAccess().getExponentUnaryExprParserRuleCall_1_2_0(), semanticObject.getExponent());
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     expression returns ProductExpression
	 *     ifelseExpr returns ProductExpression
	 *     ifelseExpr.IfElseExpression_1_0 returns ProductExpression
	 *     BooleanExpression returns ProductExpression
	 *     BooleanExpression.BooleanOperatorExpression_1_0 returns ProductExpression
	 *     boolAndExpr returns ProductExpression
	 *     boolAndExpr.BooleanOperatorExpression_1_0 returns ProductExpression
	 *     boolOrExpr returns ProductExpression
	 *     boolOrExpr.BooleanOperatorExpression_1_0 returns ProductExpression
	 *     compareExpr returns ProductExpression
	 *     compareExpr.CompareExpression_1_0 returns ProductExpression
	 *     sumExpr returns ProductExpression
	 *     sumExpr.TermExpression_1_0 returns ProductExpression
	 *     prodExpr returns ProductExpression
	 *     prodExpr.ProductExpression_1_0 returns ProductExpression
	 *
	 * Constraint:
	 *     (left=prodExpr_ProductExpression_1_0 operation=ProductOperations right=powExpr)
	 * </pre>
	 */
	protected void sequence_prodExpr(ISerializationContext context, ProductExpression semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient((EObject) semanticObject, StoexPackage.Literals.PRODUCT_EXPRESSION__LEFT) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing((EObject) semanticObject, StoexPackage.Literals.PRODUCT_EXPRESSION__LEFT));
			if (transientValues.isValueTransient((EObject) semanticObject, StoexPackage.Literals.PRODUCT_EXPRESSION__OPERATION) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing((EObject) semanticObject, StoexPackage.Literals.PRODUCT_EXPRESSION__OPERATION));
			if (transientValues.isValueTransient((EObject) semanticObject, StoexPackage.Literals.PRODUCT_EXPRESSION__RIGHT) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing((EObject) semanticObject, StoexPackage.Literals.PRODUCT_EXPRESSION__RIGHT));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, (EObject) semanticObject);
		feeder.accept(grammarAccess.getProdExprAccess().getProductExpressionLeftAction_1_0(), semanticObject.getLeft());
		feeder.accept(grammarAccess.getProdExprAccess().getOperationProductOperationsEnumRuleCall_1_1_0(), semanticObject.getOperation());
		feeder.accept(grammarAccess.getProdExprAccess().getRightPowExprParserRuleCall_1_2_0(), semanticObject.getRight());
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     real_pdf_sample returns ContinuousSample
	 *
	 * Constraint:
	 *     (value=SIGNED_NUMBER probability=NUMBER)
	 * </pre>
	 */
	protected void sequence_real_pdf_sample(ISerializationContext context, ContinuousSample semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient((EObject) semanticObject, ProbfunctionPackage.Literals.CONTINUOUS_SAMPLE__VALUE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing((EObject) semanticObject, ProbfunctionPackage.Literals.CONTINUOUS_SAMPLE__VALUE));
			if (transientValues.isValueTransient((EObject) semanticObject, ProbfunctionPackage.Literals.CONTINUOUS_SAMPLE__PROBABILITY) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing((EObject) semanticObject, ProbfunctionPackage.Literals.CONTINUOUS_SAMPLE__PROBABILITY));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, (EObject) semanticObject);
		feeder.accept(grammarAccess.getReal_pdf_sampleAccess().getValueSIGNED_NUMBERParserRuleCall_1_0(), semanticObject.getValue());
		feeder.accept(grammarAccess.getReal_pdf_sampleAccess().getProbabilityNUMBERParserRuleCall_3_0(), semanticObject.getProbability());
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     stringsample returns StringSample
	 *
	 * Constraint:
	 *     (value=STRING probability=NUMBER)
	 * </pre>
	 */
	protected void sequence_stringsample(ISerializationContext context, StringSample semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient((EObject) semanticObject, ProbfunctionPackage.Literals.SAMPLE__VALUE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing((EObject) semanticObject, ProbfunctionPackage.Literals.SAMPLE__VALUE));
			if (transientValues.isValueTransient((EObject) semanticObject, ProbfunctionPackage.Literals.SAMPLE__PROBABILITY) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing((EObject) semanticObject, ProbfunctionPackage.Literals.SAMPLE__PROBABILITY));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, (EObject) semanticObject);
		feeder.accept(grammarAccess.getStringsampleAccess().getValueSTRINGTerminalRuleCall_1_0(), semanticObject.getValue());
		feeder.accept(grammarAccess.getStringsampleAccess().getProbabilityNUMBERParserRuleCall_3_0(), semanticObject.getProbability());
		feeder.finish();
	}
	
	
	/**
	 * <pre>
	 * Contexts:
	 *     expression returns TermExpression
	 *     ifelseExpr returns TermExpression
	 *     ifelseExpr.IfElseExpression_1_0 returns TermExpression
	 *     BooleanExpression returns TermExpression
	 *     BooleanExpression.BooleanOperatorExpression_1_0 returns TermExpression
	 *     boolAndExpr returns TermExpression
	 *     boolAndExpr.BooleanOperatorExpression_1_0 returns TermExpression
	 *     boolOrExpr returns TermExpression
	 *     boolOrExpr.BooleanOperatorExpression_1_0 returns TermExpression
	 *     compareExpr returns TermExpression
	 *     compareExpr.CompareExpression_1_0 returns TermExpression
	 *     sumExpr returns TermExpression
	 *     sumExpr.TermExpression_1_0 returns TermExpression
	 *
	 * Constraint:
	 *     (left=sumExpr_TermExpression_1_0 operation=TermOperations right=prodExpr)
	 * </pre>
	 */
	protected void sequence_sumExpr(ISerializationContext context, TermExpression semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient((EObject) semanticObject, StoexPackage.Literals.TERM_EXPRESSION__LEFT) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing((EObject) semanticObject, StoexPackage.Literals.TERM_EXPRESSION__LEFT));
			if (transientValues.isValueTransient((EObject) semanticObject, StoexPackage.Literals.TERM_EXPRESSION__OPERATION) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing((EObject) semanticObject, StoexPackage.Literals.TERM_EXPRESSION__OPERATION));
			if (transientValues.isValueTransient((EObject) semanticObject, StoexPackage.Literals.TERM_EXPRESSION__RIGHT) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing((EObject) semanticObject, StoexPackage.Literals.TERM_EXPRESSION__RIGHT));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, (EObject) semanticObject);
		feeder.accept(grammarAccess.getSumExprAccess().getTermExpressionLeftAction_1_0(), semanticObject.getLeft());
		feeder.accept(grammarAccess.getSumExprAccess().getOperationTermOperationsEnumRuleCall_1_1_0(), semanticObject.getOperation());
		feeder.accept(grammarAccess.getSumExprAccess().getRightProdExprParserRuleCall_1_2_0(), semanticObject.getRight());
		feeder.finish();
	}
	
	
}
