/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.commons.stoex.api.impl.generic;

import de.uka.ipd.sdq.stoex.Expression;
import java.io.NotSerializableException;
import java.util.Optional;
import java.util.UUID;
import javax.inject.Provider;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.serializer.ISerializer;
import org.palladiosimulator.commons.stoex.api.impl.generic.GenericStoExSerialiser;

public abstract class GenericStoExSerialiserImpl
implements GenericStoExSerialiser {
    private final ISerializer serialiser;

    public GenericStoExSerialiserImpl(Provider<ISerializer> serialiserProvider) {
        this.serialiser = (ISerializer)serialiserProvider.get();
    }

    @Override
    public String serialise(Expression expression) throws NotSerializableException {
        return this.serialiseWithoutTypeCheck((EObject)expression);
    }

    protected String serialiseWithoutTypeCheck(EObject stoexElement) throws NotSerializableException {
        EObject tmpStoexElement = this.createStoexElementCopy(stoexElement);
        try {
            String string = this.serialiser.serialize(tmpStoexElement);
            return string;
        }
        catch (RuntimeException e) {
            throw new NotSerializableException(e.getMessage());
        }
        finally {
            this.removeStoexElementCopy(tmpStoexElement);
        }
    }

    protected <T extends EObject> T createStoexElementCopy(T eobject) {
        ResourceSet rs = Optional.ofNullable(eobject.eResource()).map(Resource::getResourceSet).orElseGet(ResourceSetImpl::new);
        URI uri = Optional.ofNullable(eobject.eResource()).map(Resource::getURI).orElseGet(() -> URI.createPlatformResourceURI((String)"/tmp/tmp.xmi", (boolean)false)).trimSegments(1).appendSegment(String.valueOf(UUID.randomUUID().toString()) + ".stoex");
        Resource r = rs.createResource(uri);
        EObject copy = EcoreUtil.copy(eobject);
        r.getContents().add((Object)copy);
        return (T)copy;
    }

    protected <T extends EObject> void removeStoexElementCopy(T copy) {
        Resource r = copy.eResource();
        r.unload();
        r.getResourceSet().getResources().remove((Object)r);
    }
}

