/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.commons.stoex.validation;

import com.google.inject.Inject;
import de.uka.ipd.sdq.errorhandling.core.IIssue;
import de.uka.ipd.sdq.probfunction.ProbfunctionPackage;
import de.uka.ipd.sdq.stoex.Expression;
import de.uka.ipd.sdq.stoex.StoexPackage;
import de.uka.ipd.sdq.stoex.analyser.exceptions.ExpectedTypeMismatchIssue;
import de.uka.ipd.sdq.stoex.analyser.visitors.ExpressionInferTypeVisitor;
import de.uka.ipd.sdq.stoex.analyser.visitors.NonProbabilisticExpressionInferTypeVisitor;
import de.uka.ipd.sdq.stoex.analyser.visitors.TypeCheckVisitor;
import de.uka.ipd.sdq.stoex.analyser.visitors.TypeEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.xtext.validation.Check;
import org.palladiosimulator.commons.stoex.services.StoexContext;
import org.palladiosimulator.commons.stoex.services.StoexContextProvider;
import org.palladiosimulator.commons.stoex.validation.AbstractStoexValidator;

public class StoexValidator
extends AbstractStoexValidator {
    @Inject
    private StoexContextProvider contextProvider;

    @Override
    protected List<EPackage> getEPackages() {
        HashSet<EPackage> epackages = new HashSet<EPackage>(super.getEPackages());
        epackages.add((EPackage)StoexPackage.eINSTANCE);
        epackages.add((EPackage)ProbfunctionPackage.eINSTANCE);
        epackages.remove(null);
        return new ArrayList<EPackage>(epackages);
    }

    @Check
    public void checkTypes(Expression exp) {
        NonProbabilisticExpressionInferTypeVisitor typeVisitor = new NonProbabilisticExpressionInferTypeVisitor();
        typeVisitor.doSwitch((EObject)exp);
        TypeCheckVisitor typeChecker = new TypeCheckVisitor(typeVisitor);
        typeChecker.doSwitch((EObject)exp);
        TreeIterator iterator = exp.eAllContents();
        while (iterator.hasNext()) {
            EObject treeNode = (EObject)iterator.next();
            typeChecker.doSwitch(treeNode);
        }
        Collection<IIssue> issueList = this.getIssues(typeChecker);
        for (IIssue ex : issueList) {
            if (!(ex instanceof ExpectedTypeMismatchIssue)) continue;
            this.warning(ex.getMessage(), (EObject)exp, ((ExpectedTypeMismatchIssue)ex).getFeature());
        }
        Optional.ofNullable(exp).map(EObject::eResource).map(this.contextProvider::getContext).flatMap(StoexContext::getExpectedType).ifPresent(expectedType -> {
            Collection<? extends IIssue> typeIssues = this.assertType((EObject)exp, (ExpressionInferTypeVisitor)typeVisitor, (TypeEnum)expectedType);
            for (IIssue iIssue : typeIssues) {
                this.warning(iIssue.getMessage(), (EObject)exp, null);
            }
        });
    }

    protected Collection<IIssue> getIssues(TypeCheckVisitor visitor) {
        return visitor.getIssues();
    }

    protected Collection<? extends IIssue> assertType(EObject result, ExpressionInferTypeVisitor typeVisitor, TypeEnum expectedType) {
        if (!TypeCheckVisitor.typesCompatible((TypeEnum)expectedType, (TypeEnum)typeVisitor.getType((Expression)result))) {
            return Collections.singletonList(new ExpectedTypeMismatchIssue(expectedType, typeVisitor.getType((Expression)result)));
        }
        return Collections.emptyList();
    }
}

