/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.commons.emfutils;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

public final class EMFLoadHelper {
    private EMFLoadHelper() {
    }

    public static EObject loadAndResolveEObject(String resourceURI) {
        return EMFLoadHelper.loadAndResolveEObject((ResourceSet)new ResourceSetImpl(), resourceURI);
    }

    public static EObject loadAndResolveEObject(ResourceSet resourceSet, String resourceURI) {
        return EMFLoadHelper.loadAndResolveEObject(resourceSet, URI.createURI((String)resourceURI));
    }

    public static EObject loadAndResolveEObject(ResourceSet resourceSet, URI modelURI) {
        if (modelURI.fragment() == null) {
            throw new IllegalArgumentException("The resource URI has to include the concrete fragment that references the EObject;otherwise an EObject cannot be uniquely identified in a given resource");
        }
        Resource resource = resourceSet.getResource(modelURI.trimFragment(), true);
        if (resource == null) {
            throw new IllegalArgumentException("Could not load resource with URI " + modelURI);
        }
        EObject eObject = resource.getEObject(modelURI.fragment());
        if (eObject == null) {
            throw new IllegalArgumentException("Could not get eObject with URI " + modelURI);
        }
        return eObject;
    }

    public static String getResourceURI(EObject eObject) {
        Resource resource = eObject.eResource();
        if (resource == null) {
            return "";
        }
        URI uri = resource.getURI();
        URI fullUri = uri.appendFragment(EMFLoadHelper.getResourceFragment(eObject));
        return fullUri.toString();
    }

    public static String getResourceFragment(EObject eObject) {
        return eObject.eResource().getURIFragment(eObject);
    }
}

