/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.probfunction.math;

import de.uka.ipd.sdq.probfunction.ProbabilityMassFunction;
import de.uka.ipd.sdq.probfunction.math.IProbabilityFunctionFactory;
import de.uka.ipd.sdq.probfunction.math.IProbabilityMassFunction;
import de.uka.ipd.sdq.probfunction.math.ISample;
import de.uka.ipd.sdq.probfunction.print.ProbFunctionPrettyPrint;
import java.util.List;
import org.eclipse.emf.ecore.EObject;

public class ManagedPMF {
    private IProbabilityFunctionFactory pfFactory = IProbabilityFunctionFactory.eINSTANCE;
    private IProbabilityMassFunction pmfTimeDomain;
    private ProbabilityMassFunction modelPmf;
    private String pmfAsString;

    private ManagedPMF() {
        this.reset();
    }

    public ManagedPMF(IProbabilityMassFunction pmf) {
        this();
        this.pmfTimeDomain = pmf;
    }

    public ManagedPMF(ProbabilityMassFunction modelPMF) {
        this();
        this.modelPmf = modelPMF;
    }

    private void reset() {
        this.pmfTimeDomain = null;
        this.modelPmf = null;
        this.pmfAsString = null;
    }

    public IProbabilityMassFunction getPmfTimeDomain() {
        if (this.pmfTimeDomain == null) {
            this.pmfTimeDomain = this.pfFactory.transformToPMF(this.modelPmf);
        }
        return this.pmfTimeDomain;
    }

    public ProbabilityMassFunction getModelPmf() {
        if (this.modelPmf == null) {
            this.modelPmf = this.pfFactory.transformToModelPMF(this.pmfTimeDomain);
        }
        return this.modelPmf;
    }

    public String toString() {
        if (this.pmfAsString == null) {
            ProbabilityMassFunction pmf = this.getModelPmf();
            ProbFunctionPrettyPrint pp = new ProbFunctionPrettyPrint();
            this.pmfAsString = (String)pp.doSwitch((EObject)pmf);
        }
        return this.pmfAsString;
    }

    public Object getMaxValue() {
        IProbabilityMassFunction pmf = this.getPmfTimeDomain();
        if (pmf.hasOrderedDomain()) {
            Object max = null;
            for (ISample sample : pmf.getSamples()) {
                Object obj = sample.getValue();
                if (max != null && ((Comparable)max).compareTo(obj) >= 0) continue;
                max = obj;
            }
            return max;
        }
        return null;
    }

    public Long getExpectedValue() {
        IProbabilityMassFunction pmf = this.getPmfTimeDomain();
        List<ISample> sampleList = pmf.getSamples();
        double result = 0.0;
        for (ISample sample : sampleList) {
            Integer value = (Integer)sample.getValue();
            result += value.doubleValue() * sample.getProbability();
        }
        return new Long(Math.round(result));
    }

    public Double getExpectedValueDouble() {
        IProbabilityMassFunction pmf = this.getPmfTimeDomain();
        List<ISample> sampleList = pmf.getSamples();
        double result = 0.0;
        for (ISample sample : sampleList) {
            Number value = (Number)sample.getValue();
            result += value.doubleValue() * sample.getProbability();
        }
        return result;
    }
}

