/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.stoex.analyser.operations;

import de.uka.ipd.sdq.probfunction.math.IProbabilityFunctionFactory;
import de.uka.ipd.sdq.probfunction.math.IProbabilityMassFunction;
import de.uka.ipd.sdq.probfunction.math.ISample;
import de.uka.ipd.sdq.probfunction.math.IUnit;
import java.util.ArrayList;

public abstract class LogicalOperation {
    private static final Object FALSE_STRING = "false";
    private static final Object TRUE_STRING = "true";

    public IProbabilityMassFunction evaluate(Object left, Object right) {
        if (left instanceof String) {
            if (((String)left).toLowerCase().equals(TRUE_STRING)) {
                left = new Boolean(true);
            } else if (((String)left).toLowerCase().equals(FALSE_STRING)) {
                left = new Boolean(false);
            }
        }
        if (right instanceof String) {
            if (((String)right).toLowerCase().equals(TRUE_STRING)) {
                right = new Boolean(true);
            } else if (((String)right).toLowerCase().equals(FALSE_STRING)) {
                right = new Boolean(false);
            }
        }
        if (left instanceof IProbabilityMassFunction && right instanceof IProbabilityMassFunction) {
            return this.getEvaluatedPMF((IProbabilityMassFunction)left, (IProbabilityMassFunction)right);
        }
        if (left instanceof Boolean && right instanceof IProbabilityMassFunction) {
            return this.getEvaluatedPMF((Boolean)left, (IProbabilityMassFunction)right);
        }
        if (left instanceof IProbabilityMassFunction && right instanceof Boolean) {
            return this.getEvaluatedPMF((IProbabilityMassFunction)left, (Boolean)right);
        }
        if (left instanceof Boolean && right instanceof Boolean) {
            return this.getEvaluatedPMF((Boolean)left, (Boolean)right);
        }
        throw new UnsupportedOperationException();
    }

    protected double findBooleanProbability(IProbabilityMassFunction left, boolean value) {
        for (ISample leftSamplingPoint : left.getSamples()) {
            if (!(leftSamplingPoint.getValue() instanceof String)) {
                throw new UnsupportedOperationException();
            }
            if (!((String)leftSamplingPoint.getValue()).toUpperCase().equals(Boolean.toString(value).toUpperCase())) continue;
            return leftSamplingPoint.getProbability();
        }
        throw new UnsupportedOperationException();
    }

    protected IProbabilityMassFunction getBoolPMF(boolean value) {
        return value ? this.getBoolPMF(1.0) : this.getBoolPMF(0.0);
    }

    protected IProbabilityMassFunction getBoolPMF(double trueProb) {
        IProbabilityFunctionFactory probFac = IProbabilityFunctionFactory.eINSTANCE;
        IUnit unit = probFac.createUnit("bool");
        ArrayList<ISample> sampleList = new ArrayList<ISample>();
        sampleList.add(probFac.createSample(TRUE_STRING, trueProb));
        sampleList.add(probFac.createSample(FALSE_STRING, 1.0 - trueProb));
        IProbabilityMassFunction boolPMF = probFac.createProbabilityMassFunction(sampleList, unit, true);
        return boolPMF;
    }

    protected IProbabilityMassFunction getEvaluatedPMF(Boolean left, Boolean right) {
        return this.getBoolPMF(new Boolean(left != false && right != false));
    }

    protected IProbabilityMassFunction getEvaluatedPMF(Boolean left, IProbabilityMassFunction right) {
        return this.getEvaluatedPMF(this.getBoolPMF(left), right);
    }

    protected IProbabilityMassFunction getEvaluatedPMF(IProbabilityMassFunction left, Boolean right) {
        return this.getEvaluatedPMF(left, this.getBoolPMF(right));
    }

    protected abstract IProbabilityMassFunction getEvaluatedPMF(IProbabilityMassFunction var1, IProbabilityMassFunction var2);
}

