/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.probfunction.math.apache.impl;

import de.uka.ipd.sdq.probfunction.math.ILognormalDistribution;
import de.uka.ipd.sdq.probfunction.math.IProbabilityDensityFunction;
import de.uka.ipd.sdq.probfunction.math.IRandomGenerator;
import de.uka.ipd.sdq.probfunction.math.apache.distribution.LognormalDistributionFromMomentsImpl;
import de.uka.ipd.sdq.probfunction.math.apache.distribution.LognormalDistributionImpl;
import de.uka.ipd.sdq.probfunction.math.apache.impl.AbstractContinousPDF;
import de.uka.ipd.sdq.probfunction.math.exception.DomainNotNumbersException;
import de.uka.ipd.sdq.probfunction.math.exception.FunctionNotInFrequencyDomainException;
import de.uka.ipd.sdq.probfunction.math.exception.FunctionNotInTimeDomainException;
import de.uka.ipd.sdq.probfunction.math.exception.FunctionsInDifferenDomainsException;
import de.uka.ipd.sdq.probfunction.math.exception.IncompatibleUnitsException;
import de.uka.ipd.sdq.probfunction.math.exception.InvalidSampleValueException;
import de.uka.ipd.sdq.probfunction.math.exception.NegativeDistanceException;
import de.uka.ipd.sdq.probfunction.math.exception.ProbabilityFunctionException;
import de.uka.ipd.sdq.probfunction.math.exception.ProbabilitySumNotOneException;
import de.uka.ipd.sdq.probfunction.math.exception.UnitNameNotSetException;
import de.uka.ipd.sdq.probfunction.math.exception.UnitNotSetException;
import de.uka.ipd.sdq.probfunction.math.exception.UnknownPDFTypeException;
import de.uka.ipd.sdq.probfunction.math.exception.UnorderedDomainException;
import org.apache.commons.math.MathException;

public class LognormalDistribution
extends AbstractContinousPDF
implements ILognormalDistribution {
    public LognormalDistribution(double mu, double sigma, IRandomGenerator rng) {
        super(rng);
        this.internalFunction = new LognormalDistributionImpl(mu, sigma);
    }

    protected LognormalDistribution(IRandomGenerator rng) {
        super(rng);
    }

    private LognormalDistribution(LognormalDistributionImpl internal, IRandomGenerator rng) {
        super(rng);
        this.internalFunction = internal;
    }

    @Override
    public double cdf(double x) {
        if (x == 0.0) {
            return 0.0;
        }
        return super.cdf(x);
    }

    @Override
    public double density(double x) {
        if (x == 0.0) {
            return 0.0;
        }
        return super.density(x);
    }

    @Override
    public double inverseF(double u) {
        if (u == 0.0) {
            return 0.0;
        }
        return super.inverseF(u);
    }

    @Override
    public IProbabilityDensityFunction add(IProbabilityDensityFunction pdf) throws FunctionsInDifferenDomainsException, UnknownPDFTypeException, IncompatibleUnitsException {
        throw new UnsupportedOperationException();
    }

    @Override
    public IProbabilityDensityFunction div(IProbabilityDensityFunction pdf) throws FunctionsInDifferenDomainsException, UnknownPDFTypeException, IncompatibleUnitsException {
        throw new UnsupportedOperationException();
    }

    @Override
    public IProbabilityDensityFunction getCumulativeFunction() throws FunctionNotInTimeDomainException {
        throw new UnsupportedOperationException();
    }

    @Override
    public IProbabilityDensityFunction getFourierTransform() throws FunctionNotInTimeDomainException {
        throw new UnsupportedOperationException();
    }

    @Override
    public IProbabilityDensityFunction getInverseFourierTransform() throws FunctionNotInFrequencyDomainException {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getLowerDomainBorder() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double greaterThan(IProbabilityDensityFunction pdf) throws ProbabilityFunctionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public double lessThan(IProbabilityDensityFunction pdf) throws ProbabilityFunctionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public IProbabilityDensityFunction mult(IProbabilityDensityFunction pdf) throws FunctionsInDifferenDomainsException, UnknownPDFTypeException, IncompatibleUnitsException {
        throw new UnsupportedOperationException();
    }

    @Override
    public double probabilisticEquals(IProbabilityDensityFunction pdf) throws ProbabilityFunctionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public IProbabilityDensityFunction scale(double scalar) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IProbabilityDensityFunction sub(IProbabilityDensityFunction pdf) throws FunctionsInDifferenDomainsException, UnknownPDFTypeException, IncompatibleUnitsException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void checkConstrains() throws NegativeDistanceException, ProbabilitySumNotOneException, FunctionNotInTimeDomainException, UnitNotSetException, UnitNameNotSetException, InvalidSampleValueException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getMedian() throws UnorderedDomainException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getPercentile(int p) throws IndexOutOfBoundsException, UnorderedDomainException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasOrderedDomain() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getMu() {
        return ((LognormalDistributionImpl)this.internalFunction).getMean();
    }

    @Override
    public double getSigma() {
        return ((LognormalDistributionImpl)this.internalFunction).getStandardDeviation();
    }

    @Override
    public IProbabilityDensityFunction shiftDomain(double scalar) throws DomainNotNumbersException {
        double newMean = this.getArithmeticMeanValue() + scalar;
        double newVariance = this.getVariance();
        try {
            return new LognormalDistribution(new LognormalDistributionFromMomentsImpl(newMean, newVariance), this.sampleDrawer);
        }
        catch (MathException e) {
            throw new ProbabilityFunctionException(e.getLocalizedMessage());
        }
    }

    @Override
    public IProbabilityDensityFunction stretchDomain(double scalar) {
        double newMean = this.getArithmeticMeanValue() * scalar;
        double newVariance = this.getVariance() * scalar * scalar;
        try {
            return new LognormalDistribution(new LognormalDistributionFromMomentsImpl(newMean, newVariance), this.sampleDrawer);
        }
        catch (MathException e) {
            throw new ProbabilityFunctionException(e.getLocalizedMessage());
        }
    }

    @Override
    public double getStandardDeviation() {
        return Math.sqrt(this.getVariance());
    }

    @Override
    public double getXinf() {
        return 0.0;
    }

    @Override
    public double getXsup() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public double getArithmeticMeanValue() throws DomainNotNumbersException, FunctionNotInTimeDomainException {
        double sigma = this.getSigma();
        double sigma2 = sigma * sigma;
        double mu = this.getMu();
        return Math.exp(mu + sigma2 / 2.0);
    }

    @Override
    public double getVariance() {
        double sigma = this.getSigma();
        double sigma2 = sigma * sigma;
        double mu = this.getMu();
        return Math.exp(sigma2 + 2.0 * mu) * Math.expm1(sigma2);
    }
}

