/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.statistics;

import java.util.List;

public class MCRWarmUpFilter {
    private int minIndex = 0;

    public List<Double> filter(List<Double> samples) {
        if (samples.size() <= 150) {
            System.out.println("MCRWarmUpFilter Warning: Too few samples to get a meaningful result.");
        }
        int truncatedSamplesSize = samples.size();
        double truncatedSamplesSum = 0.0;
        for (Double d : samples) {
            truncatedSamplesSum += d.doubleValue();
        }
        double minValue = Double.MAX_VALUE;
        int i = 0;
        while (i < samples.size() - 1) {
            int remaining = samples.size() - i;
            double factor = 1.0 / Math.pow(remaining, 3.0);
            double truncatedSampleMean = truncatedSamplesSum / (double)truncatedSamplesSize;
            double sum = 0.0;
            int j = i + 1;
            while (j < samples.size()) {
                sum += Math.pow(samples.get(j) - truncatedSampleMean, 2.0);
                ++j;
            }
            double d = factor * sum;
            if (d < minValue) {
                this.minIndex = i;
                minValue = d;
            }
            --truncatedSamplesSize;
            truncatedSamplesSum -= samples.get(0).doubleValue();
            ++i;
        }
        if (this.minIndex > samples.size() / 3) {
            System.out.println("MCRWarmUpFilter Warning: Truncation point is in the last two thirds of the samples, so the confidence in this result is low.");
        }
        return samples.subList(this.minIndex, samples.size() - 1);
    }

    public int getTruncationIndex() {
        return this.minIndex;
    }
}

