/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.statistics.estimation;

public class ConfidenceInterval {
    private double lowerBound;
    private double upperBound;
    private double mean;
    private double level;

    public ConfidenceInterval(double mean, double lowerBound, double upperBound, double level) {
        this.mean = mean;
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.level = level;
    }

    public ConfidenceInterval(double mean, double halfWidth, double level) {
        this(mean, mean - mean * halfWidth, mean + mean * halfWidth, level);
    }

    public double getLowerBound() {
        return this.lowerBound;
    }

    public void setLowerBound(double lowerBound) {
        this.lowerBound = lowerBound;
    }

    public double getUpperBound() {
        return this.upperBound;
    }

    public void setUpperBound(double upperBound) {
        this.upperBound = upperBound;
    }

    public double getMean() {
        return this.mean;
    }

    public void setMean(double mean) {
        this.mean = mean;
    }

    public double getLevel() {
        return this.level;
    }

    public boolean contains(ConfidenceInterval ci) {
        return ci != null && this.lowerBound <= ci.getLowerBound() && this.upperBound >= ci.getUpperBound();
    }
}

