/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.stoex.analyser.visitors;

import de.uka.ipd.sdq.probfunction.ProbabilityDensityFunction;
import de.uka.ipd.sdq.probfunction.ProbabilityFunction;
import de.uka.ipd.sdq.probfunction.ProbabilityMassFunction;
import de.uka.ipd.sdq.probfunction.Sample;
import de.uka.ipd.sdq.stoex.BoolLiteral;
import de.uka.ipd.sdq.stoex.BooleanOperatorExpression;
import de.uka.ipd.sdq.stoex.CompareExpression;
import de.uka.ipd.sdq.stoex.DoubleLiteral;
import de.uka.ipd.sdq.stoex.Expression;
import de.uka.ipd.sdq.stoex.FunctionLiteral;
import de.uka.ipd.sdq.stoex.IfElseExpression;
import de.uka.ipd.sdq.stoex.IntLiteral;
import de.uka.ipd.sdq.stoex.NegativeExpression;
import de.uka.ipd.sdq.stoex.NotExpression;
import de.uka.ipd.sdq.stoex.Parenthesis;
import de.uka.ipd.sdq.stoex.PowerExpression;
import de.uka.ipd.sdq.stoex.ProbabilityFunctionLiteral;
import de.uka.ipd.sdq.stoex.ProductExpression;
import de.uka.ipd.sdq.stoex.ProductOperations;
import de.uka.ipd.sdq.stoex.StringLiteral;
import de.uka.ipd.sdq.stoex.TermExpression;
import de.uka.ipd.sdq.stoex.TermOperations;
import de.uka.ipd.sdq.stoex.Variable;
import de.uka.ipd.sdq.stoex.analyser.probfunction.ProbfunctionHelper;
import de.uka.ipd.sdq.stoex.analyser.visitors.ITypeInference;
import de.uka.ipd.sdq.stoex.analyser.visitors.TypeEnum;
import de.uka.ipd.sdq.stoex.util.StoexSwitch;
import java.util.HashMap;
import java.util.Optional;
import java.util.ServiceLoader;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;

public class ExpressionInferTypeVisitor
extends StoexSwitch<Object> {
    private static final Logger LOGGER = Logger.getLogger((String)ExpressionInferTypeVisitor.class.getName());
    private static final String EXTENSION_POINT_ID = "de.uka.ipd.sdq.stoex.analyser.StoExTypeInference";
    private HashMap<Expression, TypeEnum> typeAnnotation = new HashMap();
    private final Optional<ITypeInference> typeInference = this.findTypeInferenceExtension();

    protected Optional<ITypeInference> findTypeInferenceExtension() {
        if (Platform.isRunning()) {
            try {
                IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
                int n = iConfigurationElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement Element = iConfigurationElementArray[n2];
                    Object extension = Element.createExecutableExtension("class");
                    if (extension instanceof ITypeInference) {
                        return Optional.of((ITypeInference)extension);
                    }
                    ++n2;
                }
            }
            catch (CoreException | InvalidRegistryObjectException e) {
                LOGGER.debug((Object)"The extension for the Stoex analyzer could not be loaded.", e);
            }
        }
        return ServiceLoader.load(ITypeInference.class).findFirst();
    }

    public Object caseCompareExpression(CompareExpression expr) {
        this.doSwitch((EObject)expr.getLeft());
        this.doSwitch((EObject)expr.getRight());
        this.typeAnnotation.put((Expression)expr, TypeEnum.BOOL_PMF);
        return expr;
    }

    public Object caseProductExpression(ProductExpression expr) {
        TypeEnum leftType = this.getTypeOfChild((Expression)expr.getLeft());
        TypeEnum rightType = this.getTypeOfChild((Expression)expr.getRight());
        ProductOperations op = expr.getOperation();
        if (op.getName().equals("MULT") || op.getName().equals("DIV")) {
            this.inferIntAndDouble((Expression)expr, leftType, rightType);
        } else if (op.getName().equals("MOD")) {
            this.typeAnnotation.put((Expression)expr, TypeEnum.INT_PMF);
        } else {
            throw new UnsupportedOperationException();
        }
        return expr;
    }

    public Object casePowerExpression(PowerExpression expr) {
        this.doSwitch((EObject)expr.getBase());
        this.doSwitch((EObject)expr.getExponent());
        TypeEnum baseType = this.getType((Expression)expr.getBase());
        TypeEnum exponentType = this.getType((Expression)expr.getExponent());
        if (this.isNumeric(baseType) && this.isNumeric(exponentType)) {
            this.typeAnnotation.put((Expression)expr, TypeEnum.DOUBLE);
        } else {
            this.typeAnnotation.put((Expression)expr, TypeEnum.ANY);
        }
        return expr;
    }

    public Object caseNegativeExpression(NegativeExpression object) {
        this.doSwitch((EObject)object.getInner());
        this.typeAnnotation.put((Expression)object, this.typeAnnotation.get(object.getInner()));
        return object;
    }

    public Object caseBooleanOperatorExpression(BooleanOperatorExpression object) {
        this.doSwitch((EObject)object.getLeft());
        this.doSwitch((EObject)object.getRight());
        this.typeAnnotation.put((Expression)object, TypeEnum.BOOL);
        return object;
    }

    public Object caseNotExpression(NotExpression object) {
        this.doSwitch((EObject)object.getInner());
        this.typeAnnotation.put((Expression)object, TypeEnum.BOOL);
        return object;
    }

    public Object caseTermExpression(TermExpression expr) {
        TypeEnum leftType = this.getTypeOfChild((Expression)expr.getLeft());
        TypeEnum rightType = this.getTypeOfChild((Expression)expr.getRight());
        TermOperations op = expr.getOperation();
        if (!op.getName().equals("ADD") && !op.getName().equals("SUB")) {
            throw new UnsupportedOperationException();
        }
        this.inferIntAndDouble((Expression)expr, leftType, rightType);
        LOGGER.debug((Object)expr.getOperation().toString());
        return expr;
    }

    public Object caseProbabilityFunctionLiteral(ProbabilityFunctionLiteral pfl) {
        ProbabilityFunction pf = pfl.getFunction_ProbabilityFunctionLiteral();
        if (pf instanceof ProbabilityMassFunction) {
            ProbabilityMassFunction pmf = (ProbabilityMassFunction)pf;
            Sample firstSample = (Sample)pmf.getSamples().get(0);
            Object value = firstSample.getValue();
            if (value instanceof Integer) {
                this.typeAnnotation.put((Expression)pfl, TypeEnum.INT_PMF);
            } else if (value instanceof Double) {
                this.typeAnnotation.put((Expression)pfl, TypeEnum.DOUBLE_PMF);
            } else if (value instanceof String) {
                this.typeAnnotation.put((Expression)pfl, TypeEnum.ENUM_PMF);
            } else if (value instanceof Boolean) {
                this.typeAnnotation.put((Expression)pfl, TypeEnum.BOOL_PMF);
            } else {
                LOGGER.error((Object)"Could not determine type of PMF!");
            }
        } else if (pf instanceof ProbabilityDensityFunction) {
            this.typeAnnotation.put((Expression)pfl, TypeEnum.DOUBLE_PDF);
        } else {
            LOGGER.error((Object)"Could not determine type of ProbabilityFunctionLiteral!");
        }
        return pfl;
    }

    public Object caseIntLiteral(IntLiteral il) {
        this.typeAnnotation.put((Expression)il, TypeEnum.INT);
        return il;
    }

    public Object caseDoubleLiteral(DoubleLiteral dl) {
        this.typeAnnotation.put((Expression)dl, TypeEnum.DOUBLE);
        return dl;
    }

    public Object caseVariable(Variable var) {
        TypeEnum type;
        TypeEnum typeEnum = type = this.typeInference.isPresent() ? this.typeInference.get().getType(var) : TypeEnum.ANY_PMF;
        if (type == null) {
            return var;
        }
        if (type == TypeEnum.ANY_PMF) {
            this.typeAnnotation.put((Expression)var, TypeEnum.ANY_PMF);
        } else if (type == TypeEnum.INT_PMF) {
            this.typeAnnotation.put((Expression)var, TypeEnum.INT_PMF);
        }
        return var;
    }

    public Object caseBoolLiteral(BoolLiteral bl) {
        this.typeAnnotation.put((Expression)bl, TypeEnum.BOOL);
        return bl;
    }

    public Object caseParenthesis(Parenthesis parenthesis) {
        TypeEnum type = this.getTypeOfChild(parenthesis.getInnerExpression());
        this.typeAnnotation.put((Expression)parenthesis, type);
        return parenthesis;
    }

    private void inferIntAndDouble(Expression expr, TypeEnum leftType, TypeEnum rightType) {
        if (leftType == null || rightType == null) {
            return;
        }
        if (leftType == TypeEnum.INT && rightType == TypeEnum.INT) {
            this.typeAnnotation.put(expr, TypeEnum.INT);
        } else if (this.isIntPMF(leftType) && this.isIntPMF(rightType)) {
            this.typeAnnotation.put(expr, TypeEnum.INT_PMF);
        } else if (this.isNumeric(leftType) && this.isNumeric(rightType)) {
            this.typeAnnotation.put(expr, TypeEnum.DOUBLE);
        } else if (this.isDoubleIntPMF(leftType) && this.isDoubleIntPMF(rightType)) {
            this.typeAnnotation.put(expr, TypeEnum.DOUBLE_PMF);
        } else if (this.isDoubleIntAnyPMF(leftType) && this.isDoubleIntAnyPMF(rightType)) {
            this.typeAnnotation.put(expr, TypeEnum.ANY_PMF);
        } else if (this.isDoubleIntPDF(leftType) && this.isDoubleIntPDF(rightType)) {
            this.typeAnnotation.put(expr, TypeEnum.DOUBLE_PDF);
        } else {
            LOGGER.error((Object)("Type inference of " + leftType.name() + " and " + rightType.name() + " failed. Incompatible types for operation. Will try to continue."));
        }
    }

    private TypeEnum getTypeOfChild(Expression expr) {
        Expression childExpr = (Expression)this.doSwitch((EObject)expr);
        TypeEnum type = this.typeAnnotation.get(childExpr);
        return type;
    }

    private boolean isIntPMF(TypeEnum type) {
        return type == TypeEnum.INT || type == TypeEnum.INT_PMF;
    }

    protected boolean isNumeric(TypeEnum type) {
        return type == TypeEnum.INT || type == TypeEnum.DOUBLE;
    }

    private boolean isDoubleIntPMF(TypeEnum type) {
        return type == TypeEnum.DOUBLE || type == TypeEnum.INT || type == TypeEnum.INT_PMF || type == TypeEnum.DOUBLE_PMF;
    }

    private boolean isDoubleIntAnyPMF(TypeEnum type) {
        return type == TypeEnum.DOUBLE || type == TypeEnum.INT || type == TypeEnum.ANY || type == TypeEnum.INT_PMF || type == TypeEnum.DOUBLE_PMF || type == TypeEnum.ANY_PMF;
    }

    private boolean isDoubleIntPDF(TypeEnum type) {
        return type == TypeEnum.DOUBLE || type == TypeEnum.INT || type == TypeEnum.INT_PMF || type == TypeEnum.DOUBLE_PMF || type == TypeEnum.DOUBLE_PDF;
    }

    public HashMap<Expression, TypeEnum> getTypeAnnotation() {
        return this.typeAnnotation;
    }

    public void setTypeAnnotation(HashMap<Expression, TypeEnum> typeAnnotation) {
        this.typeAnnotation = typeAnnotation;
    }

    public TypeEnum getType(Expression e) {
        if (!this.typeAnnotation.containsKey(e)) {
            this.doSwitch((EObject)e);
        }
        return this.typeAnnotation.get(e);
    }

    public Object caseFunctionLiteral(FunctionLiteral object) {
        for (Expression e : object.getParameters_FunctionLiteral()) {
            this.doSwitch((EObject)e);
        }
        if (object.getId().equals(ProbfunctionHelper.UNIDOUBLE)) {
            this.typeAnnotation.put((Expression)object, TypeEnum.DOUBLE_PDF);
        } else if (ProbfunctionHelper.isFunctionWithTwoParameterID(object.getId())) {
            this.typeAnnotation.put((Expression)object, TypeEnum.DOUBLE_PDF);
        } else if (object.getId().equals(ProbfunctionHelper.EXP)) {
            this.typeAnnotation.put((Expression)object, TypeEnum.DOUBLE_PDF);
        } else if (object.getId().equals(ProbfunctionHelper.POIS)) {
            this.typeAnnotation.put((Expression)object, TypeEnum.INT_PMF);
        } else if (object.getId().equals(ProbfunctionHelper.UNIINT)) {
            this.typeAnnotation.put((Expression)object, TypeEnum.INT_PMF);
        } else if (object.getId().equals("Trunc")) {
            this.typeAnnotation.put((Expression)object, TypeEnum.INT_PMF);
        } else if (object.getId().equals("Round")) {
            this.typeAnnotation.put((Expression)object, TypeEnum.INT_PMF);
        } else if (object.getId().equals("Ceil")) {
            this.typeAnnotation.put((Expression)object, TypeEnum.INT_PMF);
        } else if (object.getId().equals("Log")) {
            this.typeAnnotation.put((Expression)object, TypeEnum.INT_PMF);
        } else if (object.getId().equals("Sqrt")) {
            this.typeAnnotation.put((Expression)object, TypeEnum.INT_PMF);
        } else if (object.getId().equals("Min")) {
            if (object.getParameters_FunctionLiteral().size() > 0) {
                this.typeAnnotation.put((Expression)object, this.typeAnnotation.get(object.getParameters_FunctionLiteral().get(0)));
            } else {
                this.typeAnnotation.put((Expression)object, TypeEnum.ANY);
            }
        } else if (object.getId().equals("Max")) {
            if (object.getParameters_FunctionLiteral().size() > 0) {
                this.typeAnnotation.put((Expression)object, this.typeAnnotation.get(object.getParameters_FunctionLiteral().get(0)));
            } else {
                this.typeAnnotation.put((Expression)object, TypeEnum.ANY);
            }
        } else if (object.getId().equals("MinDeviation")) {
            if (object.getParameters_FunctionLiteral().size() > 0) {
                this.typeAnnotation.put((Expression)object, this.typeAnnotation.get(object.getParameters_FunctionLiteral().get(0)));
            } else {
                this.typeAnnotation.put((Expression)object, TypeEnum.ANY);
            }
        } else if (object.getId().equals("MaxDeviation")) {
            if (object.getParameters_FunctionLiteral().size() > 0) {
                this.typeAnnotation.put((Expression)object, this.typeAnnotation.get(object.getParameters_FunctionLiteral().get(0)));
            } else {
                this.typeAnnotation.put((Expression)object, TypeEnum.ANY);
            }
        } else if (object.getId().equals(ProbfunctionHelper.BINOM)) {
            this.typeAnnotation.put((Expression)object, TypeEnum.INT_PMF);
        } else {
            throw new UnsupportedOperationException(String.valueOf(((Object)((Object)this)).getClass().getName()) + ": Function " + object.getId() + " not supported!");
        }
        return object;
    }

    public Object caseIfElseExpression(IfElseExpression object) {
        this.doSwitch((EObject)object.getConditionExpression());
        this.doSwitch((EObject)object.getElseExpression());
        this.doSwitch((EObject)object.getIfExpression());
        this.typeAnnotation.put((Expression)object, TypeEnum.ANY);
        return object;
    }

    public Object caseStringLiteral(StringLiteral object) {
        this.typeAnnotation.put((Expression)object, TypeEnum.ENUM);
        return object;
    }
}

