/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.pcm.usagemodel.util;

import de.uka.ipd.sdq.identifier.Identifier;
import de.uka.ipd.sdq.identifier.util.IdentifierValidator;
import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.palladiosimulator.pcm.usagemodel.AbstractUserAction;
import org.palladiosimulator.pcm.usagemodel.Branch;
import org.palladiosimulator.pcm.usagemodel.BranchTransition;
import org.palladiosimulator.pcm.usagemodel.ClosedWorkload;
import org.palladiosimulator.pcm.usagemodel.Delay;
import org.palladiosimulator.pcm.usagemodel.EntryLevelSystemCall;
import org.palladiosimulator.pcm.usagemodel.Loop;
import org.palladiosimulator.pcm.usagemodel.OpenWorkload;
import org.palladiosimulator.pcm.usagemodel.ScenarioBehaviour;
import org.palladiosimulator.pcm.usagemodel.Start;
import org.palladiosimulator.pcm.usagemodel.Stop;
import org.palladiosimulator.pcm.usagemodel.UsageModel;
import org.palladiosimulator.pcm.usagemodel.UsageScenario;
import org.palladiosimulator.pcm.usagemodel.UsagemodelPackage;
import org.palladiosimulator.pcm.usagemodel.UserData;
import org.palladiosimulator.pcm.usagemodel.Workload;

public class UsagemodelValidator
extends EObjectValidator {
    public static final String copyright = "Copyright 2005-2017 by palladiosimulator.org";
    public static final UsagemodelValidator INSTANCE = new UsagemodelValidator();
    public static final String DIAGNOSTIC_SOURCE = "org.palladiosimulator.pcm.usagemodel";
    public static final int SCENARIO_BEHAVIOUR__ROUTE_FROM_START_TO_STOP_ACTION = 1;
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 1;
    protected static final int DIAGNOSTIC_CODE_COUNT = 1;
    protected IdentifierValidator identifierValidator = IdentifierValidator.INSTANCE;
    protected static final String ENTRY_LEVEL_SYSTEM_CALL__ENTRY_LEVEL_SYSTEM_CALL_MUST_REFERENCE_PROVIDED_ROLE_OF_ASYSTEM__EEXPRESSION = "self.providedRole_EntryLevelSystemCall.providingEntity_ProvidedRole.oclIsTypeOf(pcm::system::System)";
    protected static final String ENTRY_LEVEL_SYSTEM_CALL__ENTRY_LEVEL_SYSTEM_CALL_SIGNATURE_MUST_MATCH_ITS_PROVIDED_ROLE__EEXPRESSION = "self.providedRole_EntryLevelSystemCall.providedInterface__OperationProvidedRole.signatures__OperationInterface->includes(self.operationSignature__EntryLevelSystemCall)";
    protected static final String SCENARIO_BEHAVIOUR__EACHUSERACTIONEXCEPT_STARTAND_STOPMUSTHAVEAPREDECESSORANDSUCCESSOR__EEXPRESSION = "not self.actions_ScenarioBehaviour->select(s|not s.oclIsTypeOf(Start) and not s.oclIsTypeOf(Stop))->exists(a|a.oclAsType(AbstractUserAction).predecessor.oclIsUndefined()) and not self.actions_ScenarioBehaviour->select(s|not s.oclIsTypeOf(Start) and not s.oclIsTypeOf(Stop))->exists(a|a.oclAsType(AbstractUserAction).successor.oclIsUndefined())";
    protected static final String SCENARIO_BEHAVIOUR__EXACTLYONESTART__EEXPRESSION = "self.actions_ScenarioBehaviour->select(s|s.oclIsTypeOf(Start))->size() = 1";
    protected static final String SCENARIO_BEHAVIOUR__EXACTLYONESTOP__EEXPRESSION = "self.actions_ScenarioBehaviour->select(s|s.oclIsTypeOf(Stop))->size() = 1";
    protected static final String BRANCH__ALL_BRANCH_PROBABILITIES_MUST_SUM_UP_TO1__EEXPRESSION = "self->collect(branchTransitions_Branch.branchProbability)->sum() > 0.999 and self->collect(branchTransitions_Branch.branchProbability)->sum() <1.001";
    protected static final String STOP__STOP_HAS_NO_SUCCESSOR__EEXPRESSION = "self.successor.oclIsUndefined()";
    protected static final String START__START_HAS_NO_PREDECESSOR__EEXPRESSION = "self.predecessor.oclIsUndefined()";
    protected static final String OPEN_WORKLOAD__INTER_ARRIVAL_TIME_IN_OPEN_WORKLOAD_NEEDS_TO_BE_SPECIFIED__EEXPRESSION = "not self.interArrivalTime_OpenWorkload.oclIsUndefined() and self.interArrivalTime_OpenWorkload.specification <> ''";
    protected static final String CLOSED_WORKLOAD__POPULATION_IN_CLOSED_WORKLOAD_NEEDS_TO_BE_GREATER_ZERO__EEXPRESSION = "not self.population.oclIsUndefined() and self.population > 0";
    protected static final String CLOSED_WORKLOAD__THINK_TIME_IN_CLOSED_WORKLOAD_NEEDS_TO_BE_SPECIFIED__EEXPRESSION = "not self.thinkTime_ClosedWorkload.oclIsUndefined() and self.thinkTime_ClosedWorkload.specification <> ''";

    protected EPackage getEPackage() {
        return UsagemodelPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateWorkload((Workload)value, diagnostics, context);
            }
            case 1: {
                return this.validateUsageScenario((UsageScenario)value, diagnostics, context);
            }
            case 2: {
                return this.validateUserData((UserData)value, diagnostics, context);
            }
            case 3: {
                return this.validateUsageModel((UsageModel)value, diagnostics, context);
            }
            case 4: {
                return this.validateEntryLevelSystemCall((EntryLevelSystemCall)value, diagnostics, context);
            }
            case 5: {
                return this.validateAbstractUserAction((AbstractUserAction)value, diagnostics, context);
            }
            case 6: {
                return this.validateScenarioBehaviour((ScenarioBehaviour)value, diagnostics, context);
            }
            case 7: {
                return this.validateBranchTransition((BranchTransition)value, diagnostics, context);
            }
            case 8: {
                return this.validateBranch((Branch)value, diagnostics, context);
            }
            case 9: {
                return this.validateLoop((Loop)value, diagnostics, context);
            }
            case 10: {
                return this.validateStop((Stop)value, diagnostics, context);
            }
            case 11: {
                return this.validateStart((Start)value, diagnostics, context);
            }
            case 12: {
                return this.validateOpenWorkload((OpenWorkload)value, diagnostics, context);
            }
            case 13: {
                return this.validateDelay((Delay)value, diagnostics, context);
            }
            case 14: {
                return this.validateClosedWorkload((ClosedWorkload)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateWorkload(Workload workload, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(workload, diagnostics, context);
    }

    public boolean validateUsageScenario(UsageScenario usageScenario, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(usageScenario, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(usageScenario, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(usageScenario, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(usageScenario, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(usageScenario, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(usageScenario, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(usageScenario, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(usageScenario, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(usageScenario, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_identifierIsUnique((Identifier)usageScenario, diagnostics, context);
        }
        return result;
    }

    public boolean validateUserData(UserData userData, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(userData, diagnostics, context);
    }

    public boolean validateUsageModel(UsageModel usageModel, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(usageModel, diagnostics, context);
    }

    public boolean validateEntryLevelSystemCall(EntryLevelSystemCall entryLevelSystemCall, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(entryLevelSystemCall, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(entryLevelSystemCall, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(entryLevelSystemCall, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(entryLevelSystemCall, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(entryLevelSystemCall, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(entryLevelSystemCall, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(entryLevelSystemCall, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(entryLevelSystemCall, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(entryLevelSystemCall, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_identifierIsUnique((Identifier)entryLevelSystemCall, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateEntryLevelSystemCall_entryLevelSystemCallMustReferenceProvidedRoleOfASystem(entryLevelSystemCall, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateEntryLevelSystemCall_entryLevelSystemCallSignatureMustMatchItsProvidedRole(entryLevelSystemCall, diagnostics, context);
        }
        return result;
    }

    public boolean validateEntryLevelSystemCall_entryLevelSystemCallMustReferenceProvidedRoleOfASystem(EntryLevelSystemCall entryLevelSystemCall, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(UsagemodelPackage.Literals.ENTRY_LEVEL_SYSTEM_CALL, entryLevelSystemCall, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL/LPG", "entryLevelSystemCallMustReferenceProvidedRoleOfASystem", ENTRY_LEVEL_SYSTEM_CALL__ENTRY_LEVEL_SYSTEM_CALL_MUST_REFERENCE_PROVIDED_ROLE_OF_ASYSTEM__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateEntryLevelSystemCall_entryLevelSystemCallSignatureMustMatchItsProvidedRole(EntryLevelSystemCall entryLevelSystemCall, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(UsagemodelPackage.Literals.ENTRY_LEVEL_SYSTEM_CALL, entryLevelSystemCall, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL/LPG", "entryLevelSystemCallSignatureMustMatchItsProvidedRole", ENTRY_LEVEL_SYSTEM_CALL__ENTRY_LEVEL_SYSTEM_CALL_SIGNATURE_MUST_MATCH_ITS_PROVIDED_ROLE__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateAbstractUserAction(AbstractUserAction abstractUserAction, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(abstractUserAction, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(abstractUserAction, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(abstractUserAction, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(abstractUserAction, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(abstractUserAction, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(abstractUserAction, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(abstractUserAction, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(abstractUserAction, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(abstractUserAction, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_identifierIsUnique((Identifier)abstractUserAction, diagnostics, context);
        }
        return result;
    }

    public boolean validateScenarioBehaviour(ScenarioBehaviour scenarioBehaviour, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(scenarioBehaviour, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(scenarioBehaviour, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(scenarioBehaviour, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(scenarioBehaviour, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(scenarioBehaviour, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(scenarioBehaviour, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(scenarioBehaviour, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(scenarioBehaviour, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(scenarioBehaviour, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_identifierIsUnique((Identifier)scenarioBehaviour, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateScenarioBehaviour_eachuseractionexceptStartandStopmusthaveapredecessorandsuccessor(scenarioBehaviour, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateScenarioBehaviour_exactlyonestart(scenarioBehaviour, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateScenarioBehaviour_exactlyonestop(scenarioBehaviour, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateScenarioBehaviour_routeFromStartToStopAction(scenarioBehaviour, diagnostics, context);
        }
        return result;
    }

    public boolean validateScenarioBehaviour_eachuseractionexceptStartandStopmusthaveapredecessorandsuccessor(ScenarioBehaviour scenarioBehaviour, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(UsagemodelPackage.Literals.SCENARIO_BEHAVIOUR, scenarioBehaviour, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL/LPG", "eachuseractionexceptStartandStopmusthaveapredecessorandsuccessor", SCENARIO_BEHAVIOUR__EACHUSERACTIONEXCEPT_STARTAND_STOPMUSTHAVEAPREDECESSORANDSUCCESSOR__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateScenarioBehaviour_exactlyonestart(ScenarioBehaviour scenarioBehaviour, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(UsagemodelPackage.Literals.SCENARIO_BEHAVIOUR, scenarioBehaviour, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL/LPG", "exactlyonestart", SCENARIO_BEHAVIOUR__EXACTLYONESTART__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateScenarioBehaviour_exactlyonestop(ScenarioBehaviour scenarioBehaviour, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(UsagemodelPackage.Literals.SCENARIO_BEHAVIOUR, scenarioBehaviour, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL/LPG", "exactlyonestop", SCENARIO_BEHAVIOUR__EXACTLYONESTOP__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateScenarioBehaviour_routeFromStartToStopAction(ScenarioBehaviour scenarioBehaviour, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return scenarioBehaviour.routeFromStartToStopAction(diagnostics, context);
    }

    public boolean validateBranchTransition(BranchTransition branchTransition, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(branchTransition, diagnostics, context);
    }

    public boolean validateBranch(Branch branch, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(branch, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(branch, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(branch, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(branch, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(branch, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(branch, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(branch, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(branch, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(branch, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_identifierIsUnique((Identifier)branch, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateBranch_allBranchProbabilitiesMustSumUpTo1(branch, diagnostics, context);
        }
        return result;
    }

    public boolean validateBranch_allBranchProbabilitiesMustSumUpTo1(Branch branch, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(UsagemodelPackage.Literals.BRANCH, branch, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL/LPG", "allBranchProbabilitiesMustSumUpTo1", BRANCH__ALL_BRANCH_PROBABILITIES_MUST_SUM_UP_TO1__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateLoop(Loop loop, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(loop, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(loop, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(loop, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(loop, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(loop, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(loop, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(loop, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(loop, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(loop, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_identifierIsUnique((Identifier)loop, diagnostics, context);
        }
        return result;
    }

    public boolean validateStop(Stop stop, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(stop, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(stop, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(stop, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(stop, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(stop, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(stop, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(stop, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(stop, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(stop, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_identifierIsUnique((Identifier)stop, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateStop_stopHasNoSuccessor(stop, diagnostics, context);
        }
        return result;
    }

    public boolean validateStop_stopHasNoSuccessor(Stop stop, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(UsagemodelPackage.Literals.STOP, stop, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL/LPG", "stopHasNoSuccessor", STOP__STOP_HAS_NO_SUCCESSOR__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateStart(Start start, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(start, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(start, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(start, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(start, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(start, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(start, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(start, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(start, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(start, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_identifierIsUnique((Identifier)start, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateStart_startHasNoPredecessor(start, diagnostics, context);
        }
        return result;
    }

    public boolean validateStart_startHasNoPredecessor(Start start, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(UsagemodelPackage.Literals.START, start, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL/LPG", "startHasNoPredecessor", START__START_HAS_NO_PREDECESSOR__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateOpenWorkload(OpenWorkload openWorkload, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(openWorkload, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(openWorkload, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(openWorkload, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(openWorkload, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(openWorkload, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(openWorkload, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(openWorkload, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(openWorkload, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(openWorkload, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateOpenWorkload_interArrivalTimeInOpenWorkloadNeedsToBeSpecified(openWorkload, diagnostics, context);
        }
        return result;
    }

    public boolean validateOpenWorkload_interArrivalTimeInOpenWorkloadNeedsToBeSpecified(OpenWorkload openWorkload, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(UsagemodelPackage.Literals.OPEN_WORKLOAD, openWorkload, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL/LPG", "interArrivalTimeInOpenWorkloadNeedsToBeSpecified", OPEN_WORKLOAD__INTER_ARRIVAL_TIME_IN_OPEN_WORKLOAD_NEEDS_TO_BE_SPECIFIED__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateDelay(Delay delay, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(delay, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(delay, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(delay, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(delay, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(delay, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(delay, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(delay, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(delay, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(delay, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_identifierIsUnique((Identifier)delay, diagnostics, context);
        }
        return result;
    }

    public boolean validateClosedWorkload(ClosedWorkload closedWorkload, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(closedWorkload, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(closedWorkload, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(closedWorkload, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(closedWorkload, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(closedWorkload, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(closedWorkload, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(closedWorkload, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(closedWorkload, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(closedWorkload, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateClosedWorkload_populationInClosedWorkloadNeedsToBeGreaterZero(closedWorkload, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateClosedWorkload_thinkTimeInClosedWorkloadNeedsToBeSpecified(closedWorkload, diagnostics, context);
        }
        return result;
    }

    public boolean validateClosedWorkload_populationInClosedWorkloadNeedsToBeGreaterZero(ClosedWorkload closedWorkload, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(UsagemodelPackage.Literals.CLOSED_WORKLOAD, closedWorkload, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL/LPG", "populationInClosedWorkloadNeedsToBeGreaterZero", CLOSED_WORKLOAD__POPULATION_IN_CLOSED_WORKLOAD_NEEDS_TO_BE_GREATER_ZERO__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateClosedWorkload_thinkTimeInClosedWorkloadNeedsToBeSpecified(ClosedWorkload closedWorkload, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(UsagemodelPackage.Literals.CLOSED_WORKLOAD, closedWorkload, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL/LPG", "thinkTimeInClosedWorkloadNeedsToBeSpecified", CLOSED_WORKLOAD__THINK_TIME_IN_CLOSED_WORKLOAD_NEEDS_TO_BE_SPECIFIED__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public ResourceLocator getResourceLocator() {
        return super.getResourceLocator();
    }
}

