/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.pcm.core.composition.util;

import de.uka.ipd.sdq.identifier.Identifier;
import de.uka.ipd.sdq.identifier.util.IdentifierValidator;
import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.palladiosimulator.pcm.core.composition.AssemblyConnector;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.core.composition.AssemblyEventConnector;
import org.palladiosimulator.pcm.core.composition.AssemblyInfrastructureConnector;
import org.palladiosimulator.pcm.core.composition.ComposedStructure;
import org.palladiosimulator.pcm.core.composition.CompositionPackage;
import org.palladiosimulator.pcm.core.composition.Connector;
import org.palladiosimulator.pcm.core.composition.DelegationConnector;
import org.palladiosimulator.pcm.core.composition.EventChannel;
import org.palladiosimulator.pcm.core.composition.EventChannelSinkConnector;
import org.palladiosimulator.pcm.core.composition.EventChannelSourceConnector;
import org.palladiosimulator.pcm.core.composition.ProvidedDelegationConnector;
import org.palladiosimulator.pcm.core.composition.ProvidedInfrastructureDelegationConnector;
import org.palladiosimulator.pcm.core.composition.RequiredDelegationConnector;
import org.palladiosimulator.pcm.core.composition.RequiredInfrastructureDelegationConnector;
import org.palladiosimulator.pcm.core.composition.RequiredResourceDelegationConnector;
import org.palladiosimulator.pcm.core.composition.ResourceRequiredDelegationConnector;
import org.palladiosimulator.pcm.core.composition.SinkDelegationConnector;
import org.palladiosimulator.pcm.core.composition.SourceDelegationConnector;

public class CompositionValidator
extends EObjectValidator {
    public static final String copyright = "Copyright 2005-2017 by palladiosimulator.org";
    public static final CompositionValidator INSTANCE = new CompositionValidator();
    public static final String DIAGNOSTIC_SOURCE = "org.palladiosimulator.pcm.core.composition";
    public static final int COMPOSED_STRUCTURE__VALIDATE_SAME_SUBSYSTEM_MUST_NOT_BE_INSTANTIATED_MORE_THAN_ONCE = 1;
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 1;
    protected static final int DIAGNOSTIC_CODE_COUNT = 1;
    protected IdentifierValidator identifierValidator = IdentifierValidator.INSTANCE;
    protected static final String COMPOSED_STRUCTURE__MULTIPLE_CONNECTORS_CONSTRAINT__EEXPRESSION = "self.connectors__ComposedStructure->select(conn | conn.oclIsTypeOf(pcm::core::composition::ProvidedDelegationConnector)).oclAsType(pcm::core::composition::ProvidedDelegationConnector)->forAll( c1, c2 | c1 <> c2 implies c1.outerProvidedRole_ProvidedDelegationConnector <> c2.outerProvidedRole_ProvidedDelegationConnector)\r\n";
    protected static final String COMPOSED_STRUCTURE__MULTIPLE_CONNECTORS_CONSTRAINT_FOR_ASSEMBLY_CONNECTORS__EEXPRESSION = "self.connectors__ComposedStructure->select(conn | conn.oclIsTypeOf(pcm::core::composition::AssemblyConnector)).oclAsType(AssemblyConnector)->forAll( c1, c2 | ( (c1 <> c2) and ( c1.requiringAssemblyContext_AssemblyConnector = c2.requiringAssemblyContext_AssemblyConnector ) ) implies c1.requiredRole_AssemblyConnector <> c2.requiredRole_AssemblyConnector )\r\n";
    protected static final String PROVIDED_DELEGATION_CONNECTOR__COMPONENT_OF_ASSEMBLY_CONTEXT_AND_INNER_ROLE_PROVIDING_COMPONENT_NEED_TO_BE_THE_SAME__EEXPRESSION = "self.innerProvidedRole_ProvidedDelegationConnector.providingEntity_ProvidedRole = self.assemblyContext_ProvidedDelegationConnector.encapsulatedComponent__AssemblyContext";
    protected static final String PROVIDED_DELEGATION_CONNECTOR__PROVIDED_DELEGATION_CONNECTORANDTHECONNECTED_COMPONENTMUSTBEPARTOFTHESAMECOMPOSITESTRUCTURE__EEXPRESSION = "self.parentStructure__Connector = self.assemblyContext_ProvidedDelegationConnector.parentStructure__AssemblyContext";
    protected static final String REQUIRED_DELEGATION_CONNECTOR__COMPONENT_OF_ASSEMBLY_CONTEXT_AND_INNER_ROLE_REQUIRING_COMPONENT_NEED_TO_BE_THE_SAME__EEXPRESSION = "self.innerRequiredRole_RequiredDelegationConnector.requiringEntity_RequiredRole = self.assemblyContext_RequiredDelegationConnector.encapsulatedComponent__AssemblyContext";
    protected static final String REQUIRED_DELEGATION_CONNECTOR__REQUIRING_ENTITY_OF_OUTER_REQUIRED_ROLE_MUST_BE_THE_SAME_AS_THE_PARENT_OF_THE_REQUIRED_DELEGATION_CONNECTOR__EEXPRESSION = "self.outerRequiredRole_RequiredDelegationConnector.requiringEntity_RequiredRole=self.parentStructure__Connector";
    protected static final String REQUIRED_DELEGATION_CONNECTOR__REQUIRED_DELEGATION_CONNECTORANDTHECONNECTED_COMPONENTMUSTBEPARTOFTHESAMECOMPOSITESTRUCTURE__EEXPRESSION = "self.parentStructure__Connector = self.assemblyContext_RequiredDelegationConnector.parentStructure__AssemblyContext";
    protected static final String ASSEMBLY_CONNECTOR__ASSEMBLY_CONNECTORS_REFERENCED_PROVIDED_ROLES_AND_CHILD_CONTEXT_MUST_MATCH__EEXPRESSION = "self.providingAssemblyContext_AssemblyConnector.encapsulatedComponent__AssemblyContext.providedRoles_InterfaceProvidingEntity->includes(self.providedRole_AssemblyConnector)\r\n\r\n";
    protected static final String ASSEMBLY_CONNECTOR__ASSEMBLY_CONNECTORS_REFERENCED_REQUIRED_ROLE_AND_CHILD_CONTEXT_MUST_MATCH__EEXPRESSION = "self.requiringAssemblyContext_AssemblyConnector.encapsulatedComponent__AssemblyContext.requiredRoles_InterfaceRequiringEntity->includes(self.requiredRole_AssemblyConnector)\r\n\r\n";
    protected static final String ASSEMBLY_CONNECTOR__ASSEMBLY_CONNECTORS_REFERENCED_INTERFACES_MUST_MATCH__EEXPRESSION = "self.providedRole_AssemblyConnector.providedInterface__OperationProvidedRole = self.requiredRole_AssemblyConnector.requiredInterface__OperationRequiredRole";
    protected static final String ASSEMBLY_INFRASTRUCTURE_CONNECTOR__REFERENCED_INFRASTRUCTURE_REQUIRED_ROLE_NOT_REQUIRED_BY_ASSEMBLY_CONTEXT__EEXPRESSION = "self.requiringAssemblyContext__AssemblyInfrastructureConnector.encapsulatedComponent__AssemblyContext.requiredRoles_InterfaceRequiringEntity->includes(self.requiredRole__AssemblyInfrastructureConnector)";
    protected static final String ASSEMBLY_INFRASTRUCTURE_CONNECTOR__INFRASTRUCTURE_INTERFACES_NOT_COMPATIBLE__EEXPRESSION = "\tself.providedRole__AssemblyInfrastructureConnector.providedInterface__InfrastructureProvidedRole = self.requiredRole__AssemblyInfrastructureConnector.requiredInterface__InfrastructureRequiredRole  or self.providedRole__AssemblyInfrastructureConnector.providedInterface__InfrastructureProvidedRole.parentInterfaces__Interface->includes(self.requiredRole__AssemblyInfrastructureConnector.requiredInterface__InfrastructureRequiredRole)";
    protected static final String ASSEMBLY_INFRASTRUCTURE_CONNECTOR__REFERENCED_INFRASTRUCTURE_PROVIDED_ROLE_NOT_PROVIDED_BY_ASSEMBLY_CONTEXT__EEXPRESSION = "self.providingAssemblyContext__AssemblyInfrastructureConnector.encapsulatedComponent__AssemblyContext.providedRoles_InterfaceProvidingEntity->includes(self.providedRole__AssemblyInfrastructureConnector)\n";

    protected EPackage getEPackage() {
        return CompositionPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateDelegationConnector((DelegationConnector)value, diagnostics, context);
            }
            case 1: {
                return this.validateConnector((Connector)value, diagnostics, context);
            }
            case 2: {
                return this.validateComposedStructure((ComposedStructure)value, diagnostics, context);
            }
            case 3: {
                return this.validateResourceRequiredDelegationConnector((ResourceRequiredDelegationConnector)value, diagnostics, context);
            }
            case 4: {
                return this.validateEventChannel((EventChannel)value, diagnostics, context);
            }
            case 5: {
                return this.validateEventChannelSourceConnector((EventChannelSourceConnector)value, diagnostics, context);
            }
            case 6: {
                return this.validateEventChannelSinkConnector((EventChannelSinkConnector)value, diagnostics, context);
            }
            case 7: {
                return this.validateProvidedDelegationConnector((ProvidedDelegationConnector)value, diagnostics, context);
            }
            case 8: {
                return this.validateRequiredDelegationConnector((RequiredDelegationConnector)value, diagnostics, context);
            }
            case 9: {
                return this.validateAssemblyConnector((AssemblyConnector)value, diagnostics, context);
            }
            case 10: {
                return this.validateAssemblyEventConnector((AssemblyEventConnector)value, diagnostics, context);
            }
            case 11: {
                return this.validateSourceDelegationConnector((SourceDelegationConnector)value, diagnostics, context);
            }
            case 12: {
                return this.validateSinkDelegationConnector((SinkDelegationConnector)value, diagnostics, context);
            }
            case 13: {
                return this.validateAssemblyInfrastructureConnector((AssemblyInfrastructureConnector)value, diagnostics, context);
            }
            case 14: {
                return this.validateProvidedInfrastructureDelegationConnector((ProvidedInfrastructureDelegationConnector)value, diagnostics, context);
            }
            case 15: {
                return this.validateRequiredInfrastructureDelegationConnector((RequiredInfrastructureDelegationConnector)value, diagnostics, context);
            }
            case 16: {
                return this.validateRequiredResourceDelegationConnector((RequiredResourceDelegationConnector)value, diagnostics, context);
            }
            case 17: {
                return this.validateAssemblyContext((AssemblyContext)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateDelegationConnector(DelegationConnector delegationConnector, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(delegationConnector, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(delegationConnector, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(delegationConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(delegationConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(delegationConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(delegationConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(delegationConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(delegationConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(delegationConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_identifierIsUnique((Identifier)delegationConnector, diagnostics, context);
        }
        return result;
    }

    public boolean validateConnector(Connector connector, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(connector, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(connector, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(connector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(connector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(connector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(connector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(connector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(connector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(connector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_identifierIsUnique((Identifier)connector, diagnostics, context);
        }
        return result;
    }

    public boolean validateComposedStructure(ComposedStructure composedStructure, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(composedStructure, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(composedStructure, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(composedStructure, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(composedStructure, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(composedStructure, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(composedStructure, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(composedStructure, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(composedStructure, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(composedStructure, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_identifierIsUnique((Identifier)composedStructure, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateComposedStructure_multipleConnectorsConstraint(composedStructure, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateComposedStructure_multipleConnectorsConstraintForAssemblyConnectors(composedStructure, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateComposedStructure_validateSameSubsystemMustNotBeInstantiatedMoreThanOnce(composedStructure, diagnostics, context);
        }
        return result;
    }

    public boolean validateComposedStructure_multipleConnectorsConstraint(ComposedStructure composedStructure, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(CompositionPackage.Literals.COMPOSED_STRUCTURE, composedStructure, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL/LPG", "multipleConnectorsConstraint", COMPOSED_STRUCTURE__MULTIPLE_CONNECTORS_CONSTRAINT__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateComposedStructure_multipleConnectorsConstraintForAssemblyConnectors(ComposedStructure composedStructure, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(CompositionPackage.Literals.COMPOSED_STRUCTURE, composedStructure, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL/LPG", "multipleConnectorsConstraintForAssemblyConnectors", COMPOSED_STRUCTURE__MULTIPLE_CONNECTORS_CONSTRAINT_FOR_ASSEMBLY_CONNECTORS__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateComposedStructure_validateSameSubsystemMustNotBeInstantiatedMoreThanOnce(ComposedStructure composedStructure, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return composedStructure.validateSameSubsystemMustNotBeInstantiatedMoreThanOnce(diagnostics, context);
    }

    public boolean validateResourceRequiredDelegationConnector(ResourceRequiredDelegationConnector resourceRequiredDelegationConnector, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(resourceRequiredDelegationConnector, diagnostics, context);
    }

    public boolean validateEventChannel(EventChannel eventChannel, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(eventChannel, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(eventChannel, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(eventChannel, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(eventChannel, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(eventChannel, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(eventChannel, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(eventChannel, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(eventChannel, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(eventChannel, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_identifierIsUnique((Identifier)eventChannel, diagnostics, context);
        }
        return result;
    }

    public boolean validateEventChannelSourceConnector(EventChannelSourceConnector eventChannelSourceConnector, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(eventChannelSourceConnector, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(eventChannelSourceConnector, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(eventChannelSourceConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(eventChannelSourceConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(eventChannelSourceConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(eventChannelSourceConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(eventChannelSourceConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(eventChannelSourceConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(eventChannelSourceConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_identifierIsUnique((Identifier)eventChannelSourceConnector, diagnostics, context);
        }
        return result;
    }

    public boolean validateEventChannelSinkConnector(EventChannelSinkConnector eventChannelSinkConnector, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(eventChannelSinkConnector, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(eventChannelSinkConnector, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(eventChannelSinkConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(eventChannelSinkConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(eventChannelSinkConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(eventChannelSinkConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(eventChannelSinkConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(eventChannelSinkConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(eventChannelSinkConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_identifierIsUnique((Identifier)eventChannelSinkConnector, diagnostics, context);
        }
        return result;
    }

    public boolean validateProvidedDelegationConnector(ProvidedDelegationConnector providedDelegationConnector, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(providedDelegationConnector, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(providedDelegationConnector, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(providedDelegationConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(providedDelegationConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(providedDelegationConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(providedDelegationConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(providedDelegationConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(providedDelegationConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(providedDelegationConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_identifierIsUnique((Identifier)providedDelegationConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateProvidedDelegationConnector_componentOfAssemblyContextAndInnerRoleProvidingComponentNeedToBeTheSame(providedDelegationConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateProvidedDelegationConnector_providedDelegationConnectorandtheconnectedComponentmustbepartofthesamecompositestructure(providedDelegationConnector, diagnostics, context);
        }
        return result;
    }

    public boolean validateProvidedDelegationConnector_componentOfAssemblyContextAndInnerRoleProvidingComponentNeedToBeTheSame(ProvidedDelegationConnector providedDelegationConnector, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(CompositionPackage.Literals.PROVIDED_DELEGATION_CONNECTOR, providedDelegationConnector, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL/LPG", "componentOfAssemblyContextAndInnerRoleProvidingComponentNeedToBeTheSame", PROVIDED_DELEGATION_CONNECTOR__COMPONENT_OF_ASSEMBLY_CONTEXT_AND_INNER_ROLE_PROVIDING_COMPONENT_NEED_TO_BE_THE_SAME__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateProvidedDelegationConnector_providedDelegationConnectorandtheconnectedComponentmustbepartofthesamecompositestructure(ProvidedDelegationConnector providedDelegationConnector, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(CompositionPackage.Literals.PROVIDED_DELEGATION_CONNECTOR, providedDelegationConnector, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL/LPG", "providedDelegationConnectorandtheconnectedComponentmustbepartofthesamecompositestructure", PROVIDED_DELEGATION_CONNECTOR__PROVIDED_DELEGATION_CONNECTORANDTHECONNECTED_COMPONENTMUSTBEPARTOFTHESAMECOMPOSITESTRUCTURE__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateRequiredDelegationConnector(RequiredDelegationConnector requiredDelegationConnector, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(requiredDelegationConnector, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(requiredDelegationConnector, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(requiredDelegationConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(requiredDelegationConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(requiredDelegationConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(requiredDelegationConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(requiredDelegationConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(requiredDelegationConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(requiredDelegationConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_identifierIsUnique((Identifier)requiredDelegationConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateRequiredDelegationConnector_componentOfAssemblyContextAndInnerRoleRequiringComponentNeedToBeTheSame(requiredDelegationConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateRequiredDelegationConnector_requiringEntityOfOuterRequiredRoleMustBeTheSameAsTheParentOfTheRequiredDelegationConnector(requiredDelegationConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateRequiredDelegationConnector_requiredDelegationConnectorandtheconnectedComponentmustbepartofthesamecompositestructure(requiredDelegationConnector, diagnostics, context);
        }
        return result;
    }

    public boolean validateRequiredDelegationConnector_componentOfAssemblyContextAndInnerRoleRequiringComponentNeedToBeTheSame(RequiredDelegationConnector requiredDelegationConnector, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(CompositionPackage.Literals.REQUIRED_DELEGATION_CONNECTOR, requiredDelegationConnector, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL/LPG", "componentOfAssemblyContextAndInnerRoleRequiringComponentNeedToBeTheSame", REQUIRED_DELEGATION_CONNECTOR__COMPONENT_OF_ASSEMBLY_CONTEXT_AND_INNER_ROLE_REQUIRING_COMPONENT_NEED_TO_BE_THE_SAME__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateRequiredDelegationConnector_requiringEntityOfOuterRequiredRoleMustBeTheSameAsTheParentOfTheRequiredDelegationConnector(RequiredDelegationConnector requiredDelegationConnector, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(CompositionPackage.Literals.REQUIRED_DELEGATION_CONNECTOR, requiredDelegationConnector, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL/LPG", "requiringEntityOfOuterRequiredRoleMustBeTheSameAsTheParentOfTheRequiredDelegationConnector", REQUIRED_DELEGATION_CONNECTOR__REQUIRING_ENTITY_OF_OUTER_REQUIRED_ROLE_MUST_BE_THE_SAME_AS_THE_PARENT_OF_THE_REQUIRED_DELEGATION_CONNECTOR__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateRequiredDelegationConnector_requiredDelegationConnectorandtheconnectedComponentmustbepartofthesamecompositestructure(RequiredDelegationConnector requiredDelegationConnector, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(CompositionPackage.Literals.REQUIRED_DELEGATION_CONNECTOR, requiredDelegationConnector, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL/LPG", "requiredDelegationConnectorandtheconnectedComponentmustbepartofthesamecompositestructure", REQUIRED_DELEGATION_CONNECTOR__REQUIRED_DELEGATION_CONNECTORANDTHECONNECTED_COMPONENTMUSTBEPARTOFTHESAMECOMPOSITESTRUCTURE__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateAssemblyConnector(AssemblyConnector assemblyConnector, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(assemblyConnector, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(assemblyConnector, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(assemblyConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(assemblyConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(assemblyConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(assemblyConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(assemblyConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(assemblyConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(assemblyConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_identifierIsUnique((Identifier)assemblyConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateAssemblyConnector_assemblyConnectorsReferencedProvidedRolesAndChildContextMustMatch(assemblyConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateAssemblyConnector_assemblyConnectorsReferencedRequiredRoleAndChildContextMustMatch(assemblyConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateAssemblyConnector_assemblyConnectorsReferencedInterfacesMustMatch(assemblyConnector, diagnostics, context);
        }
        return result;
    }

    public boolean validateAssemblyConnector_assemblyConnectorsReferencedProvidedRolesAndChildContextMustMatch(AssemblyConnector assemblyConnector, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(CompositionPackage.Literals.ASSEMBLY_CONNECTOR, assemblyConnector, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL/LPG", "assemblyConnectorsReferencedProvidedRolesAndChildContextMustMatch", ASSEMBLY_CONNECTOR__ASSEMBLY_CONNECTORS_REFERENCED_PROVIDED_ROLES_AND_CHILD_CONTEXT_MUST_MATCH__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateAssemblyConnector_assemblyConnectorsReferencedRequiredRoleAndChildContextMustMatch(AssemblyConnector assemblyConnector, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(CompositionPackage.Literals.ASSEMBLY_CONNECTOR, assemblyConnector, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL/LPG", "assemblyConnectorsReferencedRequiredRoleAndChildContextMustMatch", ASSEMBLY_CONNECTOR__ASSEMBLY_CONNECTORS_REFERENCED_REQUIRED_ROLE_AND_CHILD_CONTEXT_MUST_MATCH__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateAssemblyConnector_assemblyConnectorsReferencedInterfacesMustMatch(AssemblyConnector assemblyConnector, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(CompositionPackage.Literals.ASSEMBLY_CONNECTOR, assemblyConnector, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL/LPG", "assemblyConnectorsReferencedInterfacesMustMatch", ASSEMBLY_CONNECTOR__ASSEMBLY_CONNECTORS_REFERENCED_INTERFACES_MUST_MATCH__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateAssemblyEventConnector(AssemblyEventConnector assemblyEventConnector, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(assemblyEventConnector, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(assemblyEventConnector, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(assemblyEventConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(assemblyEventConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(assemblyEventConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(assemblyEventConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(assemblyEventConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(assemblyEventConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(assemblyEventConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_identifierIsUnique((Identifier)assemblyEventConnector, diagnostics, context);
        }
        return result;
    }

    public boolean validateSourceDelegationConnector(SourceDelegationConnector sourceDelegationConnector, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(sourceDelegationConnector, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(sourceDelegationConnector, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(sourceDelegationConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(sourceDelegationConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(sourceDelegationConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(sourceDelegationConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(sourceDelegationConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(sourceDelegationConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(sourceDelegationConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_identifierIsUnique((Identifier)sourceDelegationConnector, diagnostics, context);
        }
        return result;
    }

    public boolean validateSinkDelegationConnector(SinkDelegationConnector sinkDelegationConnector, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(sinkDelegationConnector, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(sinkDelegationConnector, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(sinkDelegationConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(sinkDelegationConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(sinkDelegationConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(sinkDelegationConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(sinkDelegationConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(sinkDelegationConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(sinkDelegationConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_identifierIsUnique((Identifier)sinkDelegationConnector, diagnostics, context);
        }
        return result;
    }

    public boolean validateAssemblyInfrastructureConnector(AssemblyInfrastructureConnector assemblyInfrastructureConnector, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(assemblyInfrastructureConnector, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(assemblyInfrastructureConnector, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(assemblyInfrastructureConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(assemblyInfrastructureConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(assemblyInfrastructureConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(assemblyInfrastructureConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(assemblyInfrastructureConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(assemblyInfrastructureConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(assemblyInfrastructureConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_identifierIsUnique((Identifier)assemblyInfrastructureConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateAssemblyInfrastructureConnector_referencedInfrastructureRequiredRoleNotRequiredByAssemblyContext(assemblyInfrastructureConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateAssemblyInfrastructureConnector_InfrastructureInterfacesNotCompatible(assemblyInfrastructureConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateAssemblyInfrastructureConnector_referencedInfrastructureProvidedRoleNotProvidedByAssemblyContext(assemblyInfrastructureConnector, diagnostics, context);
        }
        return result;
    }

    public boolean validateAssemblyInfrastructureConnector_referencedInfrastructureRequiredRoleNotRequiredByAssemblyContext(AssemblyInfrastructureConnector assemblyInfrastructureConnector, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(CompositionPackage.Literals.ASSEMBLY_INFRASTRUCTURE_CONNECTOR, assemblyInfrastructureConnector, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL/LPG", "referencedInfrastructureRequiredRoleNotRequiredByAssemblyContext", ASSEMBLY_INFRASTRUCTURE_CONNECTOR__REFERENCED_INFRASTRUCTURE_REQUIRED_ROLE_NOT_REQUIRED_BY_ASSEMBLY_CONTEXT__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateAssemblyInfrastructureConnector_InfrastructureInterfacesNotCompatible(AssemblyInfrastructureConnector assemblyInfrastructureConnector, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(CompositionPackage.Literals.ASSEMBLY_INFRASTRUCTURE_CONNECTOR, assemblyInfrastructureConnector, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL/LPG", "InfrastructureInterfacesNotCompatible", ASSEMBLY_INFRASTRUCTURE_CONNECTOR__INFRASTRUCTURE_INTERFACES_NOT_COMPATIBLE__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateAssemblyInfrastructureConnector_referencedInfrastructureProvidedRoleNotProvidedByAssemblyContext(AssemblyInfrastructureConnector assemblyInfrastructureConnector, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(CompositionPackage.Literals.ASSEMBLY_INFRASTRUCTURE_CONNECTOR, assemblyInfrastructureConnector, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL/LPG", "referencedInfrastructureProvidedRoleNotProvidedByAssemblyContext", ASSEMBLY_INFRASTRUCTURE_CONNECTOR__REFERENCED_INFRASTRUCTURE_PROVIDED_ROLE_NOT_PROVIDED_BY_ASSEMBLY_CONTEXT__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateProvidedInfrastructureDelegationConnector(ProvidedInfrastructureDelegationConnector providedInfrastructureDelegationConnector, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(providedInfrastructureDelegationConnector, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(providedInfrastructureDelegationConnector, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(providedInfrastructureDelegationConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(providedInfrastructureDelegationConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(providedInfrastructureDelegationConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(providedInfrastructureDelegationConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(providedInfrastructureDelegationConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(providedInfrastructureDelegationConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(providedInfrastructureDelegationConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_identifierIsUnique((Identifier)providedInfrastructureDelegationConnector, diagnostics, context);
        }
        return result;
    }

    public boolean validateRequiredInfrastructureDelegationConnector(RequiredInfrastructureDelegationConnector requiredInfrastructureDelegationConnector, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(requiredInfrastructureDelegationConnector, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(requiredInfrastructureDelegationConnector, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(requiredInfrastructureDelegationConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(requiredInfrastructureDelegationConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(requiredInfrastructureDelegationConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(requiredInfrastructureDelegationConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(requiredInfrastructureDelegationConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(requiredInfrastructureDelegationConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(requiredInfrastructureDelegationConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_identifierIsUnique((Identifier)requiredInfrastructureDelegationConnector, diagnostics, context);
        }
        return result;
    }

    public boolean validateRequiredResourceDelegationConnector(RequiredResourceDelegationConnector requiredResourceDelegationConnector, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(requiredResourceDelegationConnector, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(requiredResourceDelegationConnector, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(requiredResourceDelegationConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(requiredResourceDelegationConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(requiredResourceDelegationConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(requiredResourceDelegationConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(requiredResourceDelegationConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(requiredResourceDelegationConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(requiredResourceDelegationConnector, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_identifierIsUnique((Identifier)requiredResourceDelegationConnector, diagnostics, context);
        }
        return result;
    }

    public boolean validateAssemblyContext(AssemblyContext assemblyContext, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(assemblyContext, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(assemblyContext, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(assemblyContext, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(assemblyContext, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(assemblyContext, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(assemblyContext, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(assemblyContext, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(assemblyContext, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(assemblyContext, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.identifierValidator.validateIdentifier_identifierIsUnique((Identifier)assemblyContext, diagnostics, context);
        }
        return result;
    }

    public ResourceLocator getResourceLocator() {
        return super.getResourceLocator();
    }
}

