/*
 * Decompiled with CFR 0.152.
 */
package LqnCore;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum AxisType implements Enumerator
{
    LINEAR(0, "linear", "linear"),
    LOG(1, "log", "log");

    public static final int LINEAR_VALUE = 0;
    public static final int LOG_VALUE = 1;
    private static final AxisType[] VALUES_ARRAY;
    public static final List<AxisType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new AxisType[]{LINEAR, LOG};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static AxisType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AxisType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AxisType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AxisType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AxisType get(int value) {
        switch (value) {
            case 0: {
                return LINEAR;
            }
            case 1: {
                return LOG;
            }
        }
        return null;
    }

    private AxisType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

