/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.cip.completions;

import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.common.util.URI;

public class RegisteredCompletion {
    protected final String id;
    protected final String name;
    protected final String image;
    protected final String description;
    protected final String featuremodel;
    protected String metamodel;
    protected final String qvtscript;
    protected final ArrayList<String> categories;

    public RegisteredCompletion(String id, String name, String image, String description, String featuremodel, String metamodel, String qvtscript, ArrayList<String> categories) {
        this.id = id;
        this.name = name;
        this.image = image;
        this.description = description;
        this.featuremodel = featuremodel;
        this.metamodel = metamodel;
        this.qvtscript = qvtscript;
        this.categories = categories;
    }

    public static RegisteredCompletion parseCompletion(IConfigurationElement element, String contributor) {
        String featuremodel = null;
        String metamodel = null;
        String qvtscript = null;
        String image = null;
        String id = element.getAttribute("id");
        String name = element.getAttribute("name");
        image = element.getAttribute("image");
        if (image != null) {
            image = URI.createPlatformPluginURI((String)("/" + contributor + "/" + image), (boolean)false).toString();
        }
        if ((featuremodel = element.getAttribute("featuremodel")) != null) {
            featuremodel = URI.createPlatformPluginURI((String)("/" + contributor + "/" + featuremodel), (boolean)false).toString();
        }
        if ((metamodel = element.getAttribute("metamodel")) != null) {
            metamodel = URI.createPlatformPluginURI((String)("/" + contributor + "/" + metamodel), (boolean)false).toString();
        }
        if ((qvtscript = element.getAttribute("qvtscript")) != null) {
            qvtscript = URI.createPlatformPluginURI((String)("/" + contributor + "/" + qvtscript), (boolean)false).toString();
        }
        IConfigurationElement[] description_node = element.getChildren("Description");
        String description = description_node[0].getValue();
        IConfigurationElement[] categorie_node = element.getChildren("Category");
        ArrayList<String> categories = new ArrayList<String>();
        int i = 0;
        while (i < categorie_node.length) {
            IConfigurationElement category = categorie_node[i];
            categories.add(category.getAttribute("name"));
            ++i;
        }
        if (id == null || name == null || description == null || !(featuremodel == null ^ qvtscript == null) || categories.size() < 1) {
            return null;
        }
        RegisteredCompletion rc = new RegisteredCompletion(id, name, image, description, featuremodel, metamodel, qvtscript, categories);
        return rc;
    }

    public String getImage() {
        return this.image;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getFeaturemodel() {
        return this.featuremodel;
    }

    public String getMetamodel() {
        return this.metamodel;
    }

    public String getQvtscript() {
        return this.qvtscript;
    }

    public ArrayList<String> getCategories() {
        return this.categories;
    }

    public boolean containsCategory(String category) {
        for (String search_category : this.categories) {
            if (!search_category.equals(category)) continue;
            return true;
        }
        return false;
    }
}

