/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.cip.completions;

import de.uka.ipd.sdq.cip.ConstantsContainer;
import de.uka.ipd.sdq.cip.completions.RegisteredCompletion;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class RegisteredCompletions {
    private static Collection<RegisteredCompletion> cachedCompletions;

    public static RegisteredCompletion findCompletion(String ID) {
        if (cachedCompletions == null) {
            RegisteredCompletions.getCompletions();
        }
        for (RegisteredCompletion completion : cachedCompletions) {
            if (!completion.getId().equals(ID)) continue;
            return completion;
        }
        return null;
    }

    public static Collection<RegisteredCompletion> getCompletions() {
        if (cachedCompletions != null) {
            return cachedCompletions;
        }
        ArrayList<RegisteredCompletion> found = new ArrayList<RegisteredCompletion>();
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        try {
            IConfigurationElement[] elements = reg.getConfigurationElementsFor("de.uka.ipd.sdq.cip", "Completion");
            int i = 0;
            while (i < elements.length) {
                RegisteredCompletion rc;
                IConfigurationElement element = elements[i];
                if (element.getName().equals(ConstantsContainer.NODE_COMPLETION) && (rc = RegisteredCompletion.parseCompletion(element, element.getContributor().getName())) != null) {
                    found.add(rc);
                }
                ++i;
            }
            cachedCompletions = found;
        }
        catch (InvalidRegistryObjectException invalidRegistryObjectException) {
            // empty catch block
        }
        return cachedCompletions;
    }

    public static IBaseLabelProvider getLabelProvider() {
        return new RegisteredCompletionLabelProvider();
    }

    private static class RegisteredCompletionLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private RegisteredCompletionLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            RegisteredCompletion rc = (RegisteredCompletion)element;
            switch (columnIndex) {
                case 0: {
                    return rc.getName();
                }
                case 1: {
                    return rc.getId();
                }
            }
            return "unkown " + columnIndex;
        }
    }
}

