/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.cip.configuration;

import de.uka.ipd.sdq.cip.configuration.Transformation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class CompletionConfiguration {
    protected List<Transformation> transformations;
    protected String inputPartitionName;
    protected String projectID;
    protected boolean isDebug;

    public CompletionConfiguration(Map<String, Object> configuration) {
        try {
            this.isDebug = (Boolean)configuration.get("completion.qvt.verbose.logging");
            Collection transformationStrings = (Collection)configuration.get("completion.config");
            this.transformations = new ArrayList<Transformation>();
            for (String configString : transformationStrings) {
                Transformation transformation = Transformation.fromDataString(configString);
                if (!transformation.isEnabled().booleanValue()) continue;
                this.transformations.add(transformation);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public List<Transformation> getTransformations() {
        return this.transformations;
    }

    public String getInputPartitionName() {
        return this.inputPartitionName;
    }

    public void setInputPartitionName(String inputPartitionName) {
        this.inputPartitionName = inputPartitionName;
    }

    public boolean getDebug() {
        return this.isDebug;
    }

    public String getProjectID() {
        return this.projectID;
    }

    public void setProjectID(String projectID) {
        this.projectID = projectID;
    }
}

