/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.cip.configuration;

import de.uka.ipd.sdq.cip.completions.RegisteredCompletion;
import de.uka.ipd.sdq.cip.completions.RegisteredCompletions;
import de.uka.ipd.sdq.cip.configuration.TransformationType;
import java.util.HashMap;
import java.util.Map;

public class Transformation {
    Map<String, String> keyValueMap = new HashMap<String, String>();

    public String toDataString() {
        String data = "";
        for (String key : this.keyValueMap.keySet()) {
            data = String.valueOf(data) + key + "=" + this.keyValueMap.get(key) + ";";
        }
        data = data.replaceFirst(";$", "");
        return data;
    }

    public void readFromDataString(String data) {
        String[] dataStrings = data.split(";", -1);
        int i = 0;
        while (i < dataStrings.length) {
            String[] keyValueData = dataStrings[i].split("=");
            this.keyValueMap.put(keyValueData[0], keyValueData[1]);
            ++i;
        }
    }

    public static Transformation fromDataString(String data) {
        Transformation transformation = new Transformation();
        transformation.readFromDataString(data);
        return transformation;
    }

    public Boolean isEnabled() {
        return Boolean.parseBoolean(this.keyValueMap.get("enabled"));
    }

    public void setEnabled(Boolean enabled) {
        this.keyValueMap.put("enabled", enabled.toString());
    }

    public TransformationType getType() {
        return TransformationType.fromString(this.keyValueMap.get("type"));
    }

    public void setType(TransformationType type) {
        this.keyValueMap.put("type", type.toString());
    }

    public TransformationQVTType getQVTType() {
        if (this.getType() == TransformationType.REGISTERED) {
            RegisteredCompletion completion = this.getCompletion();
            if (completion == null) {
                return TransformationQVTType.NONE;
            }
            if (completion.containsCategory("QVTO")) {
                return TransformationQVTType.QVTO;
            }
        }
        return TransformationQVTType.fromString(this.keyValueMap.get("qvtrType"));
    }

    public void setQVTType(TransformationQVTType qvtType) {
        this.keyValueMap.put("qvtrType", qvtType.toString());
    }

    public RegisteredCompletion getCompletion() {
        String ID = this.keyValueMap.get("id");
        if (ID == null) {
            return null;
        }
        return RegisteredCompletions.findCompletion(ID);
    }

    public void setCompletion(String ID) {
        this.keyValueMap.put("id", ID);
    }

    public void setFeatureFileURI(String featureFileURI) {
        this.keyValueMap.put("featureFileURI", featureFileURI);
    }

    public String getFeatureFileURI() {
        return this.keyValueMap.get("featureFileURI");
    }

    public void setConfigFileURI(String configFileURI) {
        this.keyValueMap.put("configFileURI", configFileURI);
    }

    public String getConfigFileURI() {
        return this.keyValueMap.get("configFileURI");
    }

    public void setMetamodelFileURI(String metamodelFileURI) {
        this.keyValueMap.put("metamodelFileURI", metamodelFileURI);
    }

    public String getMetamodelFileURI() {
        if (this.getType() == TransformationType.REGISTERED) {
            RegisteredCompletion completion = this.getCompletion();
            return completion.getMetamodel();
        }
        return this.keyValueMap.get("metamodelFileURI");
    }

    public void setQVTFileURI(String qvtFileURI) {
        this.keyValueMap.put("qvtFileURI", qvtFileURI);
    }

    public String getQVTFileURI() {
        if (this.getType() == TransformationType.REGISTERED) {
            RegisteredCompletion completion = this.getCompletion();
            return completion.getQvtscript();
        }
        return this.keyValueMap.get("qvtFileURI");
    }

    public void setOptionalModelFileURI(String optionalModelFileURI) {
        this.keyValueMap.put("optionalModelFileURI", optionalModelFileURI);
    }

    public String getOptionalModelFileURI() {
        return this.keyValueMap.get("optionalModelFileURI");
    }

    public static enum TransformationQVTType {
        NONE,
        QVTR,
        QVTO;


        public String toString() {
            if (this == QVTR) {
                return "QVTR";
            }
            if (this == QVTO) {
                return "QVTO";
            }
            return "QVTR";
        }

        public static TransformationQVTType fromString(String value) {
            if (value == null) {
                return QVTR;
            }
            if (value.equalsIgnoreCase("QVTR")) {
                return QVTR;
            }
            if (value.equalsIgnoreCase("QVTO")) {
                return QVTO;
            }
            return QVTR;
        }
    }
}

