/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.cip.workflow.jobs;

import de.uka.ipd.sdq.cip.configuration.CompletionConfiguration;
import de.uka.ipd.sdq.cip.configuration.CompletionConfigurationProvider;
import de.uka.ipd.sdq.cip.configuration.Transformation;
import de.uka.ipd.sdq.cip.workflow.jobs.PrepareTransformationsJob;
import de.uka.ipd.sdq.cip.workflow.jobs.builder.QVTOCompletionBuilder;
import de.uka.ipd.sdq.cip.workflow.jobs.builder.QVTRCompletionBuilder;
import de.uka.ipd.sdq.workflow.IBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.OrderPreservingBlackboardCompositeJob;
import de.uka.ipd.sdq.workflow.exceptions.JobFailedException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;

public class CompletionJob
extends OrderPreservingBlackboardCompositeJob<MDSDBlackboard>
implements IBlackboardInteractingJob<MDSDBlackboard> {
    public CompletionJob(CompletionConfigurationProvider configurationProvider) {
        this(configurationProvider.getCompletionConfiguration());
    }

    public CompletionJob(CompletionConfiguration configuration) {
        if (configuration == null || configuration.getTransformations().size() < 1) {
            return;
        }
        this.add(new PrepareTransformationsJob(configuration));
        for (Transformation transformation : configuration.getTransformations()) {
            switch (transformation.getQVTType()) {
                case QVTR: {
                    this.addAll(new QVTRCompletionBuilder(configuration, transformation).buildJobs());
                    break;
                }
                case QVTO: {
                    this.addAll(new QVTOCompletionBuilder(configuration, transformation).buildJobs());
                    break;
                }
                default: {
                    JobFailedException e = new JobFailedException("Unable to create ComplitionJob");
                    this.logger.error((Object)("unknown QVT type: " + (Object)((Object)transformation.getQVTType())), (Throwable)e);
                }
            }
        }
    }
}

