/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.cip.workflow.jobs;

import de.uka.ipd.sdq.cip.configuration.CompletionConfiguration;
import de.uka.ipd.sdq.cip.configuration.Transformation;
import de.uka.ipd.sdq.cip.workflow.jobs.PrepareTransformationsJob;
import de.uka.ipd.sdq.workflow.IBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.exceptions.JobFailedException;
import de.uka.ipd.sdq.workflow.exceptions.RollbackFailedException;
import de.uka.ipd.sdq.workflow.exceptions.UserCanceledException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.ResourceSetPartition;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class CreateCopyOfModelsJob
implements IBlackboardInteractingJob<MDSDBlackboard> {
    private Logger logger = Logger.getLogger(CreateCopyOfModelsJob.class);
    private MDSDBlackboard blackboard = null;
    private String modelPartition;
    private String projectID;
    private String transformationID;

    public CreateCopyOfModelsJob(CompletionConfiguration completionConfiguration, Transformation transformation) {
        this.projectID = completionConfiguration.getProjectID();
        this.modelPartition = completionConfiguration.getInputPartitionName();
        URI qvtFileURI = URI.createURI((String)transformation.getQVTFileURI());
        this.transformationID = String.valueOf(qvtFileURI.lastSegment().replace(qvtFileURI.fileExtension(), "")) + completionConfiguration.getTransformations().indexOf(transformation);
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        IFolder modelFolder = PrepareTransformationsJob.createFolder(PrepareTransformationsJob.getModelFolder(this.projectID).getFolder(this.transformationID), this.logger);
        this.copyModelsFromBlackboard(modelFolder);
    }

    private void copyModelsFromBlackboard(IFolder modelFolder) throws JobFailedException {
        URI baseURI = URI.createURI((String)("file:/" + modelFolder.getLocation().toOSString()));
        ResourceSetPartition partition = (ResourceSetPartition)this.blackboard.getPartition(this.modelPartition);
        ResourceSet resourceSet = partition.getResourceSet();
        for (Resource resource : resourceSet.getResources()) {
            if (!resource.getURI().isFile()) continue;
            URI oldURI = resource.getURI();
            String[] oldURISegments = oldURI.segments();
            URI newURI = baseURI;
            if (oldURISegments.length > 1) {
                newURI = newURI.appendSegment(oldURISegments[oldURISegments.length - 2]);
            }
            newURI = newURI.appendSegment(oldURISegments[oldURISegments.length - 1]);
            resource.setURI(newURI);
            try {
                resource.save(new HashMap());
                partition.setContents(resource.getURI(), (List)resource.getContents());
            }
            catch (IOException e) {
                this.logger.error((Object)("Unable to store resource " + resource.getURI()), (Throwable)e);
            }
        }
        try {
            partition.storeAllResources();
        }
        catch (IOException e) {
            this.logger.error((Object)"unable to store all resources", (Throwable)e);
            throw new JobFailedException("Unable to store all Resources");
        }
    }

    public void setBlackboard(MDSDBlackboard blackboard) {
        this.blackboard = blackboard;
    }

    public String getName() {
        return null;
    }

    public void rollback(IProgressMonitor monitor) throws RollbackFailedException {
    }
}

