/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.cip.workflow.jobs;

import de.uka.ipd.sdq.cip.configuration.CompletionConfiguration;
import de.uka.ipd.sdq.cip.configuration.Transformation;
import de.uka.ipd.sdq.cip.workflow.jobs.PrepareTransformationsJob;
import de.uka.ipd.sdq.workflow.IBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.IJob;
import de.uka.ipd.sdq.workflow.exceptions.JobFailedException;
import de.uka.ipd.sdq.workflow.exceptions.RollbackFailedException;
import de.uka.ipd.sdq.workflow.exceptions.UserCanceledException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.ResourceSetPartition;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class CreateWorkingCopyOfModelsJob
implements IJob,
IBlackboardInteractingJob<MDSDBlackboard> {
    private static final Logger logger = Logger.getLogger(CreateWorkingCopyOfModelsJob.class);
    private MDSDBlackboard blackboard = null;
    private String projectID;
    private String modelPartitionID;
    private String transformationID;

    public CreateWorkingCopyOfModelsJob(CompletionConfiguration completionConfiguration, Transformation transformation) {
        this.projectID = completionConfiguration.getProjectID();
        this.modelPartitionID = completionConfiguration.getInputPartitionName();
        URI qvtFileURI = URI.createURI((String)transformation.getQVTFileURI());
        this.transformationID = String.valueOf(qvtFileURI.lastSegment().replace(qvtFileURI.fileExtension(), "")) + completionConfiguration.getTransformations().indexOf(transformation);
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        IFolder modelFolder = PrepareTransformationsJob.createFolder(PrepareTransformationsJob.getModelFolder(this.projectID).getFolder(this.transformationID), logger);
        String modelBasePath = "file:/" + modelFolder.getLocation().toOSString();
        ResourceSetPartition partition = (ResourceSetPartition)this.blackboard.getPartition(this.modelPartitionID);
        ResourceSet resourceSet = partition.getResourceSet();
        for (Resource ressource : resourceSet.getResources()) {
            if (!ressource.getURI().isFile()) continue;
            URI uri = ressource.getURI();
            String relativePath = uri.lastSegment();
            URI newURI = URI.createURI((String)(String.valueOf(modelBasePath) + "/" + relativePath));
            ressource.setURI(newURI);
            try {
                ressource.save(new HashMap());
                partition.setContents(ressource.getURI(), (List)ressource.getContents());
            }
            catch (IOException e) {
                logger.error((Object)("Unable to store resource " + ressource.getURI()), (Throwable)e);
            }
        }
        try {
            partition.storeAllResources();
        }
        catch (IOException e) {
            logger.error((Object)"unable to store all resources", (Throwable)e);
            throw new JobFailedException("Unable to store all Resources", (Throwable)e);
        }
    }

    public String getName() {
        return "Create working copy of models";
    }

    public void rollback(IProgressMonitor monitor) throws RollbackFailedException {
        logger.warn((Object)"Unable to perform rollback for this job");
    }

    public void setBlackboard(MDSDBlackboard blackboard) {
        this.blackboard = blackboard;
    }
}

