/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.cip.workflow.jobs;

import de.uka.ipd.sdq.cip.configuration.CompletionConfiguration;
import de.uka.ipd.sdq.workflow.IJob;
import de.uka.ipd.sdq.workflow.exceptions.JobFailedException;
import de.uka.ipd.sdq.workflow.exceptions.RollbackFailedException;
import de.uka.ipd.sdq.workflow.exceptions.UserCanceledException;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class PrepareTransformationsJob
implements IJob {
    private Logger logger = Logger.getLogger(PrepareTransformationsJob.class);
    private String projectID;

    public PrepareTransformationsJob(CompletionConfiguration configuration) {
        this.projectID = configuration.getProjectID();
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        PrepareTransformationsJob.createFolder(PrepareTransformationsJob.getModelFolder(this.projectID), this.logger);
        PrepareTransformationsJob.createFolder(PrepareTransformationsJob.getTracesFolder(this.projectID), this.logger);
        PrepareTransformationsJob.createFolder(PrepareTransformationsJob.getHOTTracesFolder(this.projectID), this.logger);
        PrepareTransformationsJob.createFolder(PrepareTransformationsJob.getLogFolder(this.projectID), this.logger);
    }

    protected static IProject getProject(String projectId) {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(projectId);
    }

    public static IFolder getModelFolder(String projectID) {
        return PrepareTransformationsJob.getProject(projectID).getFolder("model");
    }

    public static IFolder getTracesFolder(String projectID) {
        return PrepareTransformationsJob.getProject(projectID).getFolder("traces");
    }

    public static IFolder getHOTTracesFolder(String projectID) {
        return PrepareTransformationsJob.getProject(projectID).getFolder("traces-hot");
    }

    public static IFolder getLogFolder(String projectID) {
        return PrepareTransformationsJob.getProject(projectID).getFolder("logs");
    }

    public static IFolder createFolder(IFolder folder, Logger logger) throws JobFailedException {
        if (folder.getProject().isOpen() && !folder.exists()) {
            logger.debug((Object)("Creating folder " + folder.getName()));
            try {
                folder.create(false, true, null);
            }
            catch (CoreException e) {
                logger.error((Object)"unable to create model folder");
                throw new JobFailedException(e);
            }
        }
        return folder;
    }

    public String getName() {
        return "Prepare project for completion";
    }

    public void rollback(IProgressMonitor monitor) throws RollbackFailedException {
    }
}

