/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.cip.workflow.jobs;

import de.uka.ipd.sdq.cip.ConstantsContainer;
import de.uka.ipd.sdq.cip.configuration.CompletionConfiguration;
import de.uka.ipd.sdq.cip.configuration.QVTConfigurationHelper;
import de.uka.ipd.sdq.cip.configuration.Transformation;
import de.uka.ipd.sdq.cip.workflow.jobs.PrepareTransformationsJob;
import de.uka.ipd.sdq.workflow.IBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.IJob;
import de.uka.ipd.sdq.workflow.OrderPreservingBlackboardCompositeJob;
import de.uka.ipd.sdq.workflow.exceptions.JobFailedException;
import de.uka.ipd.sdq.workflow.exceptions.UserCanceledException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.ResourceSetPartition;
import de.uka.ipd.sdq.workflow.mdsd.emf.qvtr.jobs.QVTRTransformationJobConfiguration;
import de.uka.ipd.sdq.workflow.mdsd.oaw.XpandGeneratorJob;
import java.util.HashMap;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xpand2.output.Outlet;

public class PrettyPrintQvtJob
extends OrderPreservingBlackboardCompositeJob<MDSDBlackboard>
implements IBlackboardInteractingJob<MDSDBlackboard> {
    private CompletionConfiguration completionConfiguration = null;
    private Transformation transformation = null;
    private QVTRTransformationJobConfiguration jobConfiguration = null;
    private MDSDBlackboard blackboard = null;
    private static final String PRETTYPRINT_EXPRESSION = "template::prettyprint::trafo FOR model";

    public PrettyPrintQvtJob(QVTRTransformationJobConfiguration jobConfiguration, CompletionConfiguration completionConfiguration, Transformation transformation) {
        this.jobConfiguration = jobConfiguration;
        this.transformation = transformation;
        this.completionConfiguration = completionConfiguration;
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        assert (this.completionConfiguration != null);
        assert (this.transformation != null);
        assert (this.jobConfiguration != null);
        this.add((IJob)this.getGeneratorJob(this.getModelSlot(), PRETTYPRINT_EXPRESSION));
        super.execute(monitor);
    }

    private HashMap<String, Object> getModelSlot() {
        HashMap<String, Object> sC2 = new HashMap<String, Object>();
        ResourceSetPartition partition = (ResourceSetPartition)((MDSDBlackboard)this.myBlackboard).getPartition("de.uka.ipd.sdq.cip.hotpartition");
        URI modelURI = URI.createURI((String)PrepareTransformationsJob.getModelFolder(this.completionConfiguration.getProjectID()).getFile("qvt.xmi").getFullPath().toPortableString());
        sC2.put("model", partition.getFirstContentElement(modelURI));
        return sC2;
    }

    private Outlet[] getQVTOutlets() throws JobFailedException {
        IFolder modelFolder = PrepareTransformationsJob.createFolder(PrepareTransformationsJob.getModelFolder(this.completionConfiguration.getProjectID()).getFolder(QVTConfigurationHelper.createTransformationID(this.completionConfiguration, this.transformation)), this.logger);
        Outlet outlet = new Outlet(modelFolder.getFullPath().toString());
        outlet.setName("transformation");
        this.transformation.setQVTFileURI(modelFolder.getFile("trasformation.qvt").getFullPath().toString());
        return new Outlet[]{outlet};
    }

    private XpandGeneratorJob getGeneratorJob(HashMap<String, Object> slots, String expression) throws JobFailedException {
        XpandGeneratorJob job = new XpandGeneratorJob(slots, ConstantsContainer.HOT_METAMODELS, this.getQVTOutlets(), expression);
        job.setCheckProtectedRegions(true);
        return job;
    }
}

