/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.cip.workflow.jobs;

import de.uka.ipd.sdq.cip.configuration.CompletionConfiguration;
import de.uka.ipd.sdq.cip.configuration.QVTConfigurationHelper;
import de.uka.ipd.sdq.cip.configuration.Transformation;
import de.uka.ipd.sdq.workflow.IBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.exceptions.JobFailedException;
import de.uka.ipd.sdq.workflow.exceptions.RollbackFailedException;
import de.uka.ipd.sdq.workflow.exceptions.UserCanceledException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.ModelLocation;
import de.uka.ipd.sdq.workflow.mdsd.emf.qvto.QVTOTransformationJobConfiguration;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;

public class QVTOConfigurationJob
implements IBlackboardInteractingJob<MDSDBlackboard> {
    private CompletionConfiguration completionConfiguration = null;
    private Transformation transformation = null;
    private QVTOTransformationJobConfiguration jobConfiguration = null;
    private MDSDBlackboard blackboard = null;

    public QVTOConfigurationJob(QVTOTransformationJobConfiguration jobConfiguration, CompletionConfiguration completionConfiguration, Transformation transformation) {
        this.jobConfiguration = jobConfiguration;
        this.transformation = transformation;
        this.completionConfiguration = completionConfiguration;
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        assert (this.completionConfiguration != null);
        assert (this.transformation != null);
        assert (this.jobConfiguration != null);
        ModelLocation[] modelLocations = QVTConfigurationHelper.getModelsFromBlackboard(this.blackboard, this.completionConfiguration.getInputPartitionName());
        if (this.transformation.getOptionalModelFileURI() != null && !this.transformation.getOptionalModelFileURI().equals("")) {
            URI optionalModelURI = URI.createURI((String)this.transformation.getOptionalModelFileURI());
            ModelLocation optionalModel = QVTConfigurationHelper.loadResourceToInputPartition(this.blackboard, this.completionConfiguration.getInputPartitionName(), optionalModelURI);
            ModelLocation[] tempModelLocations = new ModelLocation[modelLocations.length + 1];
            int i = 0;
            while (i < modelLocations.length) {
                tempModelLocations[i] = modelLocations[i];
                ++i;
            }
            tempModelLocations[modelLocations.length] = optionalModel;
            modelLocations = tempModelLocations;
        }
        URI traceFileURI = QVTConfigurationHelper.getTraceFileURI(this.completionConfiguration.getProjectID());
        URI scriptFileURI = URI.createURI((String)this.transformation.getQVTFileURI());
        this.jobConfiguration.setInoutModels(modelLocations);
        this.jobConfiguration.setTraceFileURI(traceFileURI);
        this.jobConfiguration.setScriptFileURI(scriptFileURI);
        this.jobConfiguration.setOptions(new HashMap());
    }

    public QVTOTransformationJobConfiguration getJobConfiguration() {
        return this.jobConfiguration;
    }

    public void setBlackboard(MDSDBlackboard blackboard) {
        this.blackboard = blackboard;
    }

    public String getName() {
        return "Configure QVTO transformation";
    }

    public void rollback(IProgressMonitor monitor) throws RollbackFailedException {
    }
}

