/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.cip.workflow.jobs;

import de.uka.ipd.sdq.cip.configuration.CompletionConfiguration;
import de.uka.ipd.sdq.cip.configuration.QVTConfigurationHelper;
import de.uka.ipd.sdq.cip.configuration.Transformation;
import de.uka.ipd.sdq.cip.workflow.jobs.PrepareTransformationsJob;
import de.uka.ipd.sdq.workflow.IBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.exceptions.JobFailedException;
import de.uka.ipd.sdq.workflow.exceptions.RollbackFailedException;
import de.uka.ipd.sdq.workflow.exceptions.UserCanceledException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.ModelLocation;
import de.uka.ipd.sdq.workflow.mdsd.emf.qvtr.QVTRScript;
import de.uka.ipd.sdq.workflow.mdsd.emf.qvtr.jobs.QVTRTransformationJobConfiguration;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;

public class QVTRConfigurationJob
implements IBlackboardInteractingJob<MDSDBlackboard> {
    private CompletionConfiguration completionConfiguration = null;
    private Transformation transformation = null;
    private QVTRTransformationJobConfiguration jobConfiguration = null;
    private MDSDBlackboard blackboard = null;

    public QVTRConfigurationJob(QVTRTransformationJobConfiguration jobConfiguration, CompletionConfiguration completionConfiguration, Transformation transformation) {
        this.jobConfiguration = jobConfiguration;
        this.transformation = transformation;
        this.completionConfiguration = completionConfiguration;
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        assert (this.completionConfiguration != null);
        assert (this.transformation != null);
        assert (this.jobConfiguration != null);
        String modelPartitionID = this.completionConfiguration.getInputPartitionName();
        ModelLocation[] inputModelLocations = QVTConfigurationHelper.getModelsFromBlackboard(this.blackboard, modelPartitionID);
        Collection<Object> metamodels = QVTConfigurationHelper.getMetaModelsFromBlackboard(this.blackboard, modelPartitionID);
        ModelLocation[] outputModelLocations = new ModelLocation[]{QVTConfigurationHelper.createResourceToInputPartition(this.blackboard, modelPartitionID, URI.createURI((String)PrepareTransformationsJob.getModelFolder(this.completionConfiguration.getProjectID()).getFile("output.xmi").getFullPath().toPortableString()))};
        ModelLocation[] configModelLocations = null;
        if (this.transformation.getConfigFileURI() != null && !this.transformation.getConfigFileURI().isEmpty()) {
            configModelLocations = new ModelLocation[]{QVTConfigurationHelper.loadResourceToInputPartition(this.blackboard, modelPartitionID, URI.createURI((String)this.transformation.getConfigFileURI()))};
            metamodels.addAll(QVTConfigurationHelper.getMetaModelsFromFile(URI.createURI((String)this.transformation.getMetamodelFileURI())));
        }
        QVTRScript qvtrScript = QVTConfigurationHelper.createQVTScript(this.transformation.getQVTFileURI(), metamodels, null, null);
        URI traceFileURI = QVTConfigurationHelper.getTraceFileURI(this.completionConfiguration.getProjectID());
        Boolean isDebug = this.completionConfiguration.getDebug();
        PrintStream extendedDebuggingLog = null;
        if (isDebug.booleanValue()) {
            try {
                extendedDebuggingLog = new PrintStream(new FileOutputStream(PrepareTransformationsJob.getLogFolder(this.completionConfiguration.getProjectID()).getFile(String.valueOf(QVTConfigurationHelper.createTransformationID(this.completionConfiguration, this.transformation)) + ".log").getRawLocation().toOSString()), true);
            }
            catch (FileNotFoundException e) {
                throw new JobFailedException("Could not create extended logging output", (Throwable)e);
            }
        }
        this.jobConfiguration.setDebug(isDebug);
        this.jobConfiguration.addModelLocationSets(inputModelLocations);
        this.jobConfiguration.addModelLocationSets(outputModelLocations);
        if (configModelLocations != null) {
            this.jobConfiguration.addModelLocationSets(configModelLocations);
        }
        this.jobConfiguration.setTraceFileURI(traceFileURI);
        this.jobConfiguration.setExtendedDebuggingLog(extendedDebuggingLog);
        this.jobConfiguration.setQVTRScript(qvtrScript);
    }

    public QVTRTransformationJobConfiguration getJobConfiguration() {
        return this.jobConfiguration;
    }

    public void setBlackboard(MDSDBlackboard blackboard) {
        this.blackboard = blackboard;
    }

    public String getName() {
        return "Configure QVTR transformation";
    }

    public void rollback(IProgressMonitor monitor) throws RollbackFailedException {
        if (this.jobConfiguration.getExtendedDebuggingLog() != null) {
            this.jobConfiguration.getExtendedDebuggingLog().close();
        }
        try {
            PrepareTransformationsJob.getLogFolder(this.completionConfiguration.getProjectID()).refreshLocal(1, monitor);
        }
        catch (CoreException e) {
            throw new RollbackFailedException("Could not refresh workspace", (Throwable)e);
        }
    }
}

