/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.cip.workflow.jobs;

import de.uka.ipd.sdq.cip.ConstantsContainer;
import de.uka.ipd.sdq.cip.configuration.CompletionConfiguration;
import de.uka.ipd.sdq.cip.configuration.QVTConfigurationHelper;
import de.uka.ipd.sdq.cip.configuration.Transformation;
import de.uka.ipd.sdq.cip.workflow.jobs.PrepareTransformationsJob;
import de.uka.ipd.sdq.workflow.IBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.exceptions.JobFailedException;
import de.uka.ipd.sdq.workflow.exceptions.RollbackFailedException;
import de.uka.ipd.sdq.workflow.exceptions.UserCanceledException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.ModelLocation;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.ResourceSetPartition;
import de.uka.ipd.sdq.workflow.mdsd.emf.qvtr.QVTRScript;
import de.uka.ipd.sdq.workflow.mdsd.emf.qvtr.jobs.QVTRTransformationJobConfiguration;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;

public class QVTRHotConfigurationJob
implements IBlackboardInteractingJob<MDSDBlackboard> {
    private CompletionConfiguration completionConfiguration = null;
    private Transformation transformation = null;
    private QVTRTransformationJobConfiguration jobConfiguration = null;
    private MDSDBlackboard blackboard = null;

    public QVTRHotConfigurationJob(QVTRTransformationJobConfiguration jobConfiguration, CompletionConfiguration completionConfiguration, Transformation transformation) {
        this.jobConfiguration = jobConfiguration;
        this.transformation = transformation;
        this.completionConfiguration = completionConfiguration;
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        assert (this.completionConfiguration != null);
        assert (this.transformation != null);
        assert (this.jobConfiguration != null);
        String modelPartitionID = this.completionConfiguration.getInputPartitionName();
        if (this.blackboard.hasPartition("de.uka.ipd.sdq.cip.hotpartition")) {
            this.blackboard.removePartition("de.uka.ipd.sdq.cip.hotpartition");
        }
        ResourceSetPartition hotPartition = new ResourceSetPartition();
        this.blackboard.addPartition("de.uka.ipd.sdq.cip.hotpartition", (Object)hotPartition);
        hotPartition.initialiseResourceSetEPackages(ConstantsContainer.HOT_METAMODELS);
        ModelLocation[] featureConfigLocation = new ModelLocation[]{QVTConfigurationHelper.loadResourceToInputPartition(this.blackboard, "de.uka.ipd.sdq.cip.hotpartition", URI.createURI((String)this.transformation.getFeatureFileURI()))};
        ModelLocation[] outputModelLocations = new ModelLocation[]{QVTConfigurationHelper.createResourceToInputPartition(this.blackboard, modelPartitionID, URI.createURI((String)PrepareTransformationsJob.getModelFolder(this.completionConfiguration.getProjectID()).getFile("qvt.xmi").getFullPath().toPortableString()))};
        Collection<Object> metamodels = QVTConfigurationHelper.getMetaModelsFromBlackboard(this.blackboard, "de.uka.ipd.sdq.cip.hotpartition");
        QVTRScript qvtrScript = QVTConfigurationHelper.createQVTScript("platform:/plugin/de.uka.ipd.sdq.cip/completion/FeatureConfig2QVT.qvt", metamodels, null, null);
        URI traceFileURI = QVTConfigurationHelper.getTraceFileURI(this.completionConfiguration.getProjectID());
        Boolean isDebug = this.completionConfiguration.getDebug();
        this.jobConfiguration.setDebug(isDebug);
        this.jobConfiguration.addModelLocationSets(featureConfigLocation);
        this.jobConfiguration.addModelLocationSets(outputModelLocations);
        this.jobConfiguration.setTraceFileURI(traceFileURI);
        this.jobConfiguration.setQVTRScript(qvtrScript);
    }

    public void setBlackboard(MDSDBlackboard blackboard) {
        this.blackboard = blackboard;
    }

    public String getName() {
        return "Configure QVTR HOT transformation";
    }

    public void rollback(IProgressMonitor monitor) throws RollbackFailedException {
    }
}

