/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.cip.workflow.jobs;

import de.uka.ipd.sdq.cip.configuration.CompletionConfiguration;
import de.uka.ipd.sdq.cip.configuration.QVTConfigurationHelper;
import de.uka.ipd.sdq.cip.configuration.Transformation;
import de.uka.ipd.sdq.cip.workflow.jobs.PrepareTransformationsJob;
import de.uka.ipd.sdq.workflow.IBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.exceptions.JobFailedException;
import de.uka.ipd.sdq.workflow.exceptions.RollbackFailedException;
import de.uka.ipd.sdq.workflow.exceptions.UserCanceledException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.ModelLocation;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.ResourceSetPartition;
import de.uka.ipd.sdq.workflow.mdsd.emf.qvtr.jobs.QVTRTransformationJobConfiguration;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class SplitTransformationResultJob
implements IBlackboardInteractingJob<MDSDBlackboard> {
    private Logger logger = Logger.getLogger(SplitTransformationResultJob.class);
    private MDSDBlackboard blackboard = null;
    private String modelPartitionID;
    private String projectID;
    private String transformationID;
    private QVTRTransformationJobConfiguration qvtrTransformationJobConfiguration;

    public SplitTransformationResultJob(QVTRTransformationJobConfiguration qvtrTransformationJobConfiguration, CompletionConfiguration completionConfiguration, Transformation transformation) {
        this.modelPartitionID = completionConfiguration.getInputPartitionName();
        this.qvtrTransformationJobConfiguration = qvtrTransformationJobConfiguration;
        this.projectID = completionConfiguration.getProjectID();
        this.transformationID = QVTConfigurationHelper.createTransformationID(completionConfiguration, transformation);
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        IFolder modelFolder = PrepareTransformationsJob.createFolder(PrepareTransformationsJob.getModelFolder(this.projectID).getFolder(this.transformationID), this.logger);
        ResourceSetPartition partition = (ResourceSetPartition)this.blackboard.getPartition(this.modelPartitionID);
        ResourceSet resourceSet = partition.getResourceSet();
        ArrayList<Resource> resourcesToDelete = new ArrayList<Resource>();
        for (Resource resource : resourceSet.getResources()) {
            if (!resource.getURI().isFile()) continue;
            resourcesToDelete.add(resource);
        }
        Iterator iterator = this.qvtrTransformationJobConfiguration.getModelLocationSets().iterator();
        iterator.next();
        ModelLocation[] modelLocationArray = (ModelLocation[])iterator.next();
        int n = modelLocationArray.length;
        int n2 = 0;
        while (n2 < n) {
            ModelLocation modelLocation = modelLocationArray[n2];
            ResourceSetPartition modelPartition = (ResourceSetPartition)this.blackboard.getPartition(modelLocation.getPartitionID());
            EList topLevelObjects = (EList)modelPartition.getContents(modelLocation.getModelID());
            while (topLevelObjects.size() > 0) {
                this.createResource((EObject)topLevelObjects.get(0), partition, modelFolder);
            }
            Resource resource = modelPartition.getResourceSet().getResource(modelLocation.getModelID(), false);
            if (resource.isLoaded()) {
                try {
                    resource.delete(new HashMap());
                }
                catch (IOException e) {
                    this.logger.error((Object)("Unable to delete resource " + resource.getURI()), (Throwable)e);
                }
            }
            ++n2;
        }
        for (Resource resource : resourcesToDelete) {
            partition.getResourceSet().getResources().remove((Object)resource);
        }
    }

    private void createResource(EObject eobject, ResourceSetPartition partition, IFolder modelFolder) {
        URI baseURI = URI.createFileURI((String)modelFolder.getFullPath().toString());
        String eobjectName = eobject.eClass().getName();
        URI modelURI = baseURI.appendSegment(String.valueOf(eobjectName) + ".xmi");
        Resource resource = partition.getResourceSet().getResource(modelURI, false);
        long num = 1L;
        while (resource != null) {
            modelURI = baseURI.appendSegment(String.valueOf(eobjectName) + "_" + String.valueOf(num) + ".xmi");
            resource = partition.getResourceSet().getResource(modelURI, false);
            ++num;
        }
        resource = partition.getResourceSet().createResource(modelURI);
        resource.getContents().add((Object)eobject);
        try {
            resource.save(new HashMap());
        }
        catch (IOException e) {
            this.logger.error((Object)("Unable to store resource " + resource.getURI()), (Throwable)e);
        }
    }

    public String getName() {
        return "Clean up qvtr completion transformation result";
    }

    public void rollback(IProgressMonitor monitor) throws RollbackFailedException {
    }

    public void setBlackboard(MDSDBlackboard blackboard) {
        this.blackboard = blackboard;
    }
}

