/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.cip.workflow.jobs.builder;

import de.uka.ipd.sdq.cip.configuration.CompletionConfiguration;
import de.uka.ipd.sdq.cip.configuration.Transformation;
import de.uka.ipd.sdq.cip.configuration.TransformationType;
import de.uka.ipd.sdq.cip.workflow.jobs.PrettyPrintQvtJob;
import de.uka.ipd.sdq.cip.workflow.jobs.QVTRConfigurationJob;
import de.uka.ipd.sdq.cip.workflow.jobs.QVTRHotConfigurationJob;
import de.uka.ipd.sdq.cip.workflow.jobs.SplitTransformationResultJob;
import de.uka.ipd.sdq.cip.workflow.jobs.builder.CompletionBuilder;
import de.uka.ipd.sdq.workflow.IJob;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.SavePartitionToDiskJob;
import de.uka.ipd.sdq.workflow.mdsd.emf.qvtr.jobs.QVTRTransformationJob;
import de.uka.ipd.sdq.workflow.mdsd.emf.qvtr.jobs.QVTRTransformationJobConfiguration;
import java.util.ArrayList;
import java.util.Collection;

public class QVTRCompletionBuilder
implements CompletionBuilder {
    private CompletionConfiguration completionConfiguration;
    private Transformation transformation;

    public QVTRCompletionBuilder(CompletionConfiguration completionConfiguration, Transformation transformation) {
        this.completionConfiguration = completionConfiguration;
        this.transformation = transformation;
    }

    @Override
    public Collection<IJob> buildJobs() {
        ArrayList<IJob> jobs = new ArrayList<IJob>();
        if (this.transformation.getType() == TransformationType.FEATURE) {
            QVTRTransformationJobConfiguration qvtrHotConfig = new QVTRTransformationJobConfiguration();
            jobs.add((IJob)new QVTRHotConfigurationJob(qvtrHotConfig, this.completionConfiguration, this.transformation));
            jobs.add((IJob)new QVTRTransformationJob(qvtrHotConfig));
            jobs.add((IJob)new PrettyPrintQvtJob(qvtrHotConfig, this.completionConfiguration, this.transformation));
        }
        QVTRTransformationJobConfiguration qvtrConfig = new QVTRTransformationJobConfiguration();
        jobs.add((IJob)new QVTRConfigurationJob(qvtrConfig, this.completionConfiguration, this.transformation));
        jobs.add((IJob)new QVTRTransformationJob(qvtrConfig));
        jobs.add((IJob)new SplitTransformationResultJob(qvtrConfig, this.completionConfiguration, this.transformation));
        jobs.add((IJob)new SavePartitionToDiskJob(this.completionConfiguration.getInputPartitionName()));
        return jobs;
    }
}

